/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.nutils.io.JDIO;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConnector
implements Serializable {
    private static final long serialVersionUID = 8074213660382482620L;
    private static Logger logger = JDLogger.getLogger();
    private static String configpath = String.valueOf(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath()) + "/config/";
    private HashMap<String, Object> dbdata = new HashMap();
    private static Connection con = null;

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver").newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public DatabaseConnector() throws SQLException {
        if (con != null) {
            return;
        }
        logger.finer("Loading database");
        if (new File(String.valueOf(configpath) + "database.script").exists() && !this.checkDatabaseHeader()) {
            throw new SQLException("Database broken!");
        }
        con = DriverManager.getConnection("jdbc:hsqldb:file:" + configpath + "database;shutdown=true", "sa", "");
        con.setAutoCommit(true);
        con.createStatement().executeUpdate("SET LOGSIZE 1");
        if (!new File(String.valueOf(configpath) + "database.script").exists()) {
            logger.finer("No CONFIGURATION database found. Creating new one.");
            con.createStatement().executeUpdate("CREATE TABLE config (name VARCHAR(256), obj OTHER)");
            con.createStatement().executeUpdate("CREATE TABLE links (name VARCHAR(256), obj OTHER)");
            PreparedStatement pst = con.prepareStatement("INSERT INTO config VALUES (?,?)");
            logger.finer("Starting database wrapper");
            String[] stringArray = new File(configpath).list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tmppath = stringArray[n2];
                try {
                    if (tmppath.endsWith(".cfg")) {
                        logger.finest("Wrapping " + tmppath);
                        Object props = JDIO.loadObject(null, JDUtilities.getResourceFile("config/" + tmppath), false);
                        if (props != null) {
                            pst.setString(1, tmppath.split(".cfg")[0]);
                            pst.setObject(2, props);
                            pst.execute();
                        }
                    }
                }
                catch (Exception e) {
                    JDLogger.exception(e);
                }
                ++n2;
            }
        }
    }

    private boolean checkDatabaseHeader() {
        logger.finer("Checking database");
        File f = new File(String.valueOf(configpath) + "database.script");
        if (!f.exists()) {
            return true;
        }
        boolean databaseok = true;
        FileInputStream fis = null;
        BufferedReader in = null;
        try {
            try {
                fis = new FileInputStream(f);
                in = new BufferedReader(new InputStreamReader(fis));
                String line = "";
                int counter = 0;
                while (counter < 7) {
                    line = in.readLine();
                    if (line == null) {
                        databaseok = false;
                        break;
                    }
                    switch (counter) {
                        case 0: {
                            if (line.equals("CREATE SCHEMA PUBLIC AUTHORIZATION DBA")) break;
                            databaseok = false;
                            break;
                        }
                        case 1: {
                            if (line.equals("CREATE MEMORY TABLE CONFIG(NAME VARCHAR(256),OBJ OBJECT)")) break;
                            databaseok = false;
                            break;
                        }
                        case 2: {
                            if (line.equals("CREATE MEMORY TABLE LINKS(NAME VARCHAR(256),OBJ OBJECT)")) break;
                            databaseok = false;
                            break;
                        }
                        case 3: {
                            if (line.equals("CREATE USER SA PASSWORD \"\"")) break;
                            databaseok = false;
                            break;
                        }
                        case 4: {
                            if (line.equals("GRANT DBA TO SA")) break;
                            databaseok = false;
                            break;
                        }
                        case 5: {
                            if (line.equals("SET WRITE_DELAY 10")) break;
                            databaseok = false;
                            break;
                        }
                        case 6: {
                            if (line.equals("SET SCHEMA PUBLIC")) break;
                            databaseok = false;
                        }
                    }
                    ++counter;
                }
                while ((line = in.readLine()) != null) {
                    if (line.matches("INSERT INTO .*? VALUES\\('.*?','.*?'\\)")) continue;
                    databaseok = false;
                    break;
                }
            }
            catch (FileNotFoundException e) {
                databaseok = false;
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                databaseok = false;
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return databaseok;
    }

    public synchronized Object getData(String name) {
        Object ret = this.dbdata.get(name);
        try {
            ResultSet rs;
            if (ret == null && (rs = con.createStatement().executeQuery("SELECT * FROM config WHERE name = '" + name + "'")).next()) {
                ret = rs.getObject(2);
                this.dbdata.put(rs.getString(1), ret);
            }
        }
        catch (Exception e) {
            JDLogger.getLogger().warning("Database not available. Create new one: " + name);
            JDLogger.exception(Level.FINEST, e);
        }
        return ret;
    }

    public ArrayList<SubConfiguration> getSubConfigurationKeys() {
        ArrayList<SubConfiguration> ret = new ArrayList<SubConfiguration>();
        try {
            ResultSet rs = con.createStatement().executeQuery("SELECT * FROM config");
            while (rs.next()) {
                try {
                    SubConfiguration conf = SubConfiguration.getConfig((String)rs.getObject(1));
                    if (conf.getProperties().size() <= 0) continue;
                    ret.add(conf);
                }
                catch (Exception conf) {
                    // empty catch block
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void saveConfiguration(String name, Object data) {
        this.dbdata.put(name, data);
        try {
            ResultSet rs = con.createStatement().executeQuery("SELECT COUNT(name) FROM config WHERE name = '" + name + "'");
            rs.next();
            if (rs.getInt(1) > 0) {
                PreparedStatement pst = con.prepareStatement("UPDATE config SET obj = ? WHERE name = '" + name + "'");
                pst.setObject(1, data);
                pst.execute();
            } else {
                PreparedStatement pst = con.prepareStatement("INSERT INTO config VALUES (?,?)");
                pst.setString(1, name);
                pst.setObject(2, data);
                pst.execute();
            }
        }
        catch (Exception e) {
            try {
                System.out.println("First save " + name);
                PreparedStatement pst = con.prepareStatement("INSERT INTO config VALUES (?,?)");
                pst.setString(1, name);
                pst.setObject(2, data);
                pst.execute();
            }
            catch (Exception e2) {
                JDLogger.getLogger().warning("Database save error: " + name);
                JDLogger.exception(Level.FINEST, e2);
            }
        }
    }

    public void shutdownDatabase() {
        try {
            con.close();
        }
        catch (SQLException e) {
            JDLogger.exception(e);
        }
    }

    public Object getLinks() {
        try {
            ResultSet rs = con.createStatement().executeQuery("SELECT * FROM links");
            rs.next();
            return rs.getObject(2);
        }
        catch (Exception e) {
            JDLogger.exception(Level.FINEST, e);
            JDLogger.getLogger().warning("Database not available. Create new one: links");
            return null;
        }
    }

    public void saveLinks(Object obj) {
        try {
            if (this.getLinks() == null) {
                PreparedStatement pst = con.prepareStatement("INSERT INTO links VALUES (?,?)");
                pst.setString(1, "links");
                pst.setObject(2, obj);
                pst.execute();
            } else {
                PreparedStatement pst = con.prepareStatement("UPDATE links SET obj=? WHERE name='links'");
                pst.setObject(1, obj);
                pst.execute();
            }
        }
        catch (Exception e) {
            JDLogger.exception(e);
        }
    }

    public Connection getDatabaseConnection() {
        return con;
    }
}

