/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import jd.config.ConfigurationListener;
import jd.config.Property;
import jd.controlling.JDLogger;
import jd.utils.JDUtilities;

public class SubConfiguration
extends Property
implements Serializable {
    private static final long serialVersionUID = 7803718581558607222L;
    private static transient boolean SUBCONFIG_LOCK = false;
    protected String name;
    private transient ArrayList<ConfigurationListener> listener = null;
    private static transient HashMap<String, SubConfiguration> SUB_CONFIGS = new HashMap();

    public void addConfigurationListener(ConfigurationListener listener) {
        if (this.listener == null) {
            this.listener = new ArrayList();
        }
        this.removeConfigurationListener(listener);
        this.listener.add(listener);
    }

    private void fireEventPreSave() {
        if (this.listener == null) {
            return;
        }
        for (ConfigurationListener listener : this.listener) {
            listener.onPreSave(this);
        }
    }

    private void fireEventPostSave() {
        if (this.listener == null) {
            return;
        }
        for (ConfigurationListener listener : this.listener) {
            listener.onPostSave(this);
        }
    }

    public void removeConfigurationListener(ConfigurationListener listener) {
        if (listener == null) {
            return;
        }
        this.listener.remove(listener);
    }

    public SubConfiguration() {
    }

    public SubConfiguration(String name) {
        this.name = name;
        Object props = JDUtilities.getDatabaseConnector().getData(name);
        if (props != null) {
            this.setProperties((HashMap)props);
        }
    }

    public void save() {
        this.fireEventPreSave();
        JDUtilities.getDatabaseConnector().saveConfiguration(this.name, this.getProperties());
        this.fireEventPostSave();
        this.changes = false;
    }

    public String toString() {
        return this.name;
    }

    public static synchronized SubConfiguration getConfig(String name) {
        if (SUBCONFIG_LOCK) {
            JDLogger.exception(new Exception("Static Database init error!!"));
        }
        SUBCONFIG_LOCK = true;
        try {
            if (SUB_CONFIGS.containsKey(name)) {
                SubConfiguration subConfiguration = SUB_CONFIGS.get(name);
                return subConfiguration;
            }
            SubConfiguration cfg = new SubConfiguration(name);
            SUB_CONFIGS.put(name, cfg);
            cfg.save();
            SubConfiguration subConfiguration = cfg;
            return subConfiguration;
        }
        finally {
            SUBCONFIG_LOCK = false;
        }
    }

    public static SubConfiguration getConfig(Object object) {
        return SubConfiguration.getConfig(object.getClass().getSimpleName());
    }
}

