/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jd.DecryptPluginWrapper;
import jd.HostPluginWrapper;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.LinkGrabberController;
import jd.controlling.ProgressController;
import jd.gui.UserIO;
import jd.http.Browser;
import jd.nutils.JDFlags;
import jd.nutils.encoding.Encoding;
import jd.nutils.encoding.HTMLEntities;
import jd.nutils.jobber.JDRunnable;
import jd.nutils.jobber.Jobber;
import jd.parser.Regex;
import jd.parser.html.HTMLParser;
import jd.plugins.CryptedLink;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributeData
extends Thread {
    private static Logger logger = JDLogger.getLogger();
    private boolean disableDeepEmergencyScan = false;
    private String data;
    private boolean hideGrabber;
    private ArrayList<DownloadLink> linkData;
    private String orgData;
    private boolean filterNormalHTTP = false;
    private ArrayList<String> foundPasswords;
    private boolean autostart = false;

    public DistributeData(String data) {
        super("JD-DistributeData");
        this.data = new String(data);
        this.disableDeepEmergencyScan = true;
        this.foundPasswords = new ArrayList();
    }

    public DistributeData setDisableDeepEmergencyScan(boolean b) {
        this.disableDeepEmergencyScan = b;
        return this;
    }

    public DistributeData setHideGrabber(boolean b) {
        this.hideGrabber = b;
        return this;
    }

    public DistributeData setAutostart(boolean b) {
        this.autostart = b;
        return this;
    }

    public DistributeData(String data, boolean hideGrabber) {
        this(data);
        this.hideGrabber = hideGrabber;
        this.disableDeepEmergencyScan = true;
    }

    public DistributeData setFilterNormalHTTP(boolean b) {
        this.filterNormalHTTP = b;
        return this;
    }

    public static boolean hasPluginFor(String tmp, boolean filterNormalHTTP) {
        String data = tmp;
        if (DecryptPluginWrapper.getDecryptWrapper() == null) {
            return false;
        }
        data = data.replaceAll("jd://", "http://");
        for (DecryptPluginWrapper pDecrypt : DecryptPluginWrapper.getDecryptWrapper()) {
            if (!pDecrypt.usePlugin() || !pDecrypt.canHandle(data)) continue;
            return true;
        }
        for (HostPluginWrapper pHost : JDUtilities.getPluginsForHost()) {
            if (!pHost.usePlugin() || !pHost.canHandle(data)) continue;
            return true;
        }
        data = Encoding.urlDecode(data, true);
        for (DecryptPluginWrapper pDecrypt : DecryptPluginWrapper.getDecryptWrapper()) {
            if (!pDecrypt.usePlugin() || !pDecrypt.canHandle(data)) continue;
            return true;
        }
        for (HostPluginWrapper pHost : JDUtilities.getPluginsForHost()) {
            if (!pHost.usePlugin() || !pHost.canHandle(data)) continue;
            return true;
        }
        if (!filterNormalHTTP) {
            data = data.replaceAll("http://", "httpviajd://");
            data = data.replaceAll("https://", "httpsviajd://");
            for (DecryptPluginWrapper pDecrypt : DecryptPluginWrapper.getDecryptWrapper()) {
                if (!pDecrypt.usePlugin() || !pDecrypt.canHandle(data)) continue;
                return true;
            }
            for (HostPluginWrapper pHost : JDUtilities.getPluginsForHost()) {
                if (!pHost.usePlugin() || !pHost.canHandle(data)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean deepDecrypt(ArrayList<DownloadLink> decryptedLinks) {
        if (decryptedLinks.isEmpty()) {
            return false;
        }
        ArrayList newdecryptedLinks = new ArrayList();
        ArrayList notdecryptedLinks = new ArrayList();
        Jobber decryptJobbers = new Jobber(4);
        int b = decryptedLinks.size() - 1;
        while (b >= 0) {
            class DThread
            extends Thread
            implements JDRunnable {
                private DownloadLink link = null;
                private final /* synthetic */ ArrayList val$newdecryptedLinks;
                private final /* synthetic */ ArrayList val$notdecryptedLinks;

                public DThread(DownloadLink link, ArrayList arrayList, ArrayList arrayList2) {
                    this.val$newdecryptedLinks = arrayList;
                    this.val$notdecryptedLinks = arrayList2;
                    this.link = link;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String url = this.link.getDownloadURL();
                    if (url != null) {
                        url = HTMLParser.getHttpLinkList((String)url);
                        try {
                            url = URLDecoder.decode(url, "UTF-8");
                        }
                        catch (Exception e) {
                            logger.warning("text not url decodeable");
                        }
                    }
                    boolean coulddecrypt = false;
                    for (DecryptPluginWrapper pDecrypt : DecryptPluginWrapper.getDecryptWrapper()) {
                        if (!pDecrypt.usePlugin() || !pDecrypt.canHandle(url)) continue;
                        try {
                            CryptedLink cLink;
                            PluginForDecrypt plg = (PluginForDecrypt)pDecrypt.getNewPluginInstance();
                            CryptedLink[] decryptableLinks = plg.getDecryptableLinks(url);
                            url = plg.cutMatches(url);
                            CryptedLink[] cryptedLinkArray = decryptableLinks;
                            int n = decryptableLinks.length;
                            int n2 = 0;
                            while (n2 < n) {
                                cLink = cryptedLinkArray[n2];
                                cLink.setDecrypterPassword(this.link.getDecrypterPassword());
                                ++n2;
                            }
                            cryptedLinkArray = decryptableLinks;
                            n = decryptableLinks.length;
                            n2 = 0;
                            while (n2 < n) {
                                cLink = cryptedLinkArray[n2];
                                cLink.setProperties(this.link.getProperties());
                                ++n2;
                            }
                            ArrayList dLinks = plg.decryptLinks(decryptableLinks);
                            coulddecrypt = true;
                            if (dLinks == null || dLinks.size() <= 0) break;
                            for (DownloadLink dLink : dLinks) {
                                dLink.addSourcePluginPasswordList(this.link.getSourcePluginPasswordList());
                            }
                            ArrayList arrayList = this.val$newdecryptedLinks;
                            synchronized (arrayList) {
                                this.val$newdecryptedLinks.addAll(dLinks);
                                break;
                            }
                        }
                        catch (Exception e) {
                            JDLogger.exception(e);
                        }
                    }
                    if (!coulddecrypt) {
                        ArrayList arrayList = this.val$notdecryptedLinks;
                        synchronized (arrayList) {
                            this.val$notdecryptedLinks.add(this.link);
                        }
                    }
                }

                public void go() throws Exception {
                    this.run();
                }
            }
            DThread dthread = new DThread(decryptedLinks.get(b), newdecryptedLinks, notdecryptedLinks);
            decryptJobbers.add(dthread);
            --b;
        }
        int todo = decryptJobbers.getJobsAdded();
        decryptJobbers.start();
        while (decryptJobbers.getJobsFinished() != todo) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        decryptJobbers.stop();
        decryptedLinks.clear();
        decryptedLinks.addAll(newdecryptedLinks);
        decryptedLinks.addAll(notdecryptedLinks);
        return newdecryptedLinks.size() > 0;
    }

    public ArrayList<DownloadLink> findLinks() {
        ArrayList<DownloadLink> ret = this.quickHosterCheck(this.data);
        if (ret != null && ret.size() == 1) {
            return ret;
        }
        if (ret != null && ret.size() == 1) {
            return ret;
        }
        this.foundPasswords.addAll(HTMLParser.findPasswords((String)this.data));
        this.data = HTMLEntities.unhtmlentities(this.data);
        this.data = this.data.replaceAll("jd://", "http://");
        ret = this.findLinksIntern();
        this.data = Encoding.urlDecode(this.data, true);
        ret.addAll(this.findLinksIntern());
        if (!this.filterNormalHTTP) {
            this.data = this.data.replaceAll("--CUT--", "\n");
            this.data = this.data.replaceAll("http://", "httpviajd://");
            this.data = this.data.replaceAll("https://", "httpsviajd://");
            ret.addAll(this.findLinksIntern());
            this.data = this.data.replaceAll("httpviajd://", "http://");
            this.data = this.data.replaceAll("httpsviajd://", "https://");
        }
        for (DownloadLink link : ret) {
            link.addSourcePluginPasswordList(this.foundPasswords);
        }
        return ret;
    }

    private ArrayList<DownloadLink> quickHosterCheck(String data) {
        String lowercasedata = data.toLowerCase();
        for (HostPluginWrapper pw : JDUtilities.getPluginsForHost()) {
            String match;
            Pattern pattern = pw.getPattern();
            if (!lowercasedata.contains(pw.getHost().toLowerCase()) || (match = new Regex(data, pattern).getMatch(-1)) == null || !match.equals(data) && (match.length() <= 10 + pw.getHost().length() || !data.startsWith(match) || match.length() * 2 <= data.length())) continue;
            DownloadLink dl = new DownloadLink((PluginForHost)pw.getNewPluginInstance(), null, pw.getHost(), Encoding.urlDecode(match, true), true);
            ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>();
            ret.add(dl);
            return ret;
        }
        return null;
    }

    private ArrayList<DownloadLink> findLinksIntern() {
        ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
        if (JDUtilities.getPluginsForHost() == null) {
            return new ArrayList<DownloadLink>();
        }
        this.orgData = this.data;
        this.reformDataString();
        ArrayList<DownloadLink> alldecrypted = this.handleDecryptPlugins();
        ArrayList<HostPluginWrapper> pHostAll = JDUtilities.getPluginsForHost();
        for (DownloadLink decrypted : alldecrypted) {
            if (this.checkdecrypted(pHostAll, links, decrypted) || decrypted.getDownloadURL() == null || this.filterNormalHTTP) continue;
            decrypted.setUrlDownload(decrypted.getDownloadURL().replaceAll("http://", "httpviajd://"));
            decrypted.setUrlDownload(decrypted.getDownloadURL().replaceAll("https://", "httpsviajd://"));
            this.checkdecrypted(pHostAll, links, decrypted);
        }
        this.useHoster(links);
        return links;
    }

    private boolean checkdecrypted(ArrayList<HostPluginWrapper> pHostAll, ArrayList<DownloadLink> links, DownloadLink decrypted) {
        if (decrypted.getDownloadURL() == null) {
            return true;
        }
        if (LinkGrabberController.isFiltered(decrypted)) {
            return true;
        }
        boolean gothost = false;
        for (HostPluginWrapper pHost : pHostAll) {
            try {
                if (!pHost.canHandle(decrypted.getDownloadURL())) continue;
                ArrayList dLinks = pHost.getPlugin().getDownloadLinks(decrypted.getDownloadURL(), decrypted.getFilePackage() != FilePackage.getDefaultFilePackage() ? decrypted.getFilePackage() : null);
                gothost = true;
                if (!pHost.usePlugin()) break;
                int c = 0;
                while (c < dLinks.size()) {
                    ((DownloadLink)dLinks.get(c)).addSourcePluginPasswordList(decrypted.getSourcePluginPasswordList());
                    ((DownloadLink)dLinks.get(c)).setSourcePluginComment(decrypted.getSourcePluginComment());
                    ((DownloadLink)dLinks.get(c)).setName(decrypted.getName());
                    ((DownloadLink)dLinks.get(c)).setFinalFileName(decrypted.getFinalFileName());
                    ((DownloadLink)dLinks.get(c)).setBrowserUrl(decrypted.getBrowserUrl());
                    if (decrypted.isAvailabilityStatusChecked()) {
                        ((DownloadLink)dLinks.get(c)).setAvailable(decrypted.isAvailable());
                    }
                    ((DownloadLink)dLinks.get(c)).setProperties(decrypted.getProperties());
                    ((DownloadLink)dLinks.get(c)).getLinkStatus().setStatusText(decrypted.getLinkStatus().getStatusString());
                    ((DownloadLink)dLinks.get(c)).setDownloadSize(decrypted.getDownloadSize());
                    ((DownloadLink)dLinks.get(c)).setSubdirectory(decrypted);
                    ++c;
                }
                links.addAll(dLinks);
                break;
            }
            catch (Exception e) {
                logger.severe("Decrypter/Search Fehler: " + e.getMessage());
                JDLogger.exception(e);
            }
        }
        return gothost;
    }

    private void useHoster(ArrayList<DownloadLink> links) {
        for (HostPluginWrapper pHost : JDUtilities.getPluginsForHost()) {
            if (!pHost.canHandle(pHost.isAcceptOnlyURIs() ? this.data : this.orgData)) continue;
            ArrayList dl = pHost.getPlugin().getDownloadLinks(pHost.isAcceptOnlyURIs() ? this.data : this.orgData, null);
            if (pHost.isAcceptOnlyURIs()) {
                this.data = pHost.getPlugin().cutMatches(this.data);
            } else {
                this.orgData = pHost.getPlugin().cutMatches(this.orgData);
            }
            if (!pHost.usePlugin()) continue;
            for (DownloadLink dll : dl) {
                if (LinkGrabberController.isFiltered(dll)) continue;
                links.add(dll);
            }
        }
    }

    public ArrayList<DownloadLink> getLinkData() {
        return this.linkData;
    }

    private ArrayList<DownloadLink> handleDecryptPlugins() {
        ArrayList<DownloadLink> decryptedLinks = new ArrayList<DownloadLink>();
        if (DecryptPluginWrapper.getDecryptWrapper() == null) {
            return decryptedLinks;
        }
        Jobber decryptJobbers = new Jobber(4);
        for (DecryptPluginWrapper pDecrypt : DecryptPluginWrapper.getDecryptWrapper()) {
            if (!pDecrypt.usePlugin() || !pDecrypt.canHandle(pDecrypt.isAcceptOnlyURIs() ? this.data : this.orgData)) continue;
            try {
                PluginForDecrypt plg = (PluginForDecrypt)pDecrypt.getNewPluginInstance();
                CryptedLink[] decryptableLinks = plg.getDecryptableLinks(plg.isAcceptOnlyURIs() ? this.data : this.orgData);
                if (plg.isAcceptOnlyURIs()) {
                    this.data = plg.cutMatches(this.data);
                } else {
                    this.orgData = plg.cutMatches(this.orgData);
                }
                class DThread
                extends Thread
                implements JDRunnable {
                    private CryptedLink[] decryptableLinks = null;
                    private PluginForDecrypt plg = null;
                    private final /* synthetic */ ArrayList val$decryptedLinks;

                    public DThread(PluginForDecrypt plg, CryptedLink[] decryptableLinks, ArrayList arrayList) {
                        this.val$decryptedLinks = arrayList;
                        this.decryptableLinks = decryptableLinks;
                        this.plg = plg;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ArrayList tmp = this.plg.decryptLinks(this.decryptableLinks);
                        ArrayList arrayList = this.val$decryptedLinks;
                        synchronized (arrayList) {
                            this.val$decryptedLinks.addAll(tmp);
                        }
                    }

                    public void go() throws Exception {
                        this.run();
                    }
                }
                DThread dthread = new DThread(plg, decryptableLinks, decryptedLinks);
                decryptJobbers.add(dthread);
            }
            catch (Exception e) {
                JDLogger.exception(e);
            }
        }
        int todo = decryptJobbers.getJobsAdded();
        decryptJobbers.start();
        while (decryptJobbers.getJobsFinished() != todo) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        decryptJobbers.stop();
        int i = 1;
        while (this.deepDecrypt(decryptedLinks)) {
            logger.info("Deepdecrypt depths: " + ++i);
        }
        return decryptedLinks;
    }

    private void reformDataString() {
        String tmp;
        if (this.data != null && (tmp = HTMLParser.getHttpLinkList((String)this.data)).length() != 0) {
            this.data = tmp;
        }
    }

    @Override
    public void run() {
        String[] ls;
        ArrayList<DownloadLink> links = this.findLinks();
        if (links.size() == 0 && !this.disableDeepEmergencyScan && (ls = HTMLParser.getHttpLinks((String)this.data, null)).length > 0) {
            String txt = "\r\n";
            String[] stringArray = ls;
            int n = ls.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                txt = String.valueOf(txt) + l + "\r\n";
                ++n2;
            }
            logger.warning("No supported links found -> search for links in source code of all urls");
            String title = JDL.L((String)"gui.dialog.deepdecrypt.title", (String)"Deep decryption?");
            String message = JDL.LF((String)"gui.dialog.deepdecrypt.message", (String)"JDownloader has not found anything on %s\r\n-------------------------------\r\nJD now loads this page to look for further links.", (Object[])new Object[]{String.valueOf(txt)});
            int res = UserIO.getInstance().requestConfirmDialog(0, title, message, JDTheme.II("gui.images.search", 32, 32), JDL.L((String)"gui.btn_continue", (String)"Continue"), null);
            if (JDFlags.hasAllFlags(res, 2)) {
                this.data = DistributeData.getLoadLinkString(this.data);
                links = this.findLinks();
            }
        }
        Collections.sort(links);
        LinkGrabberController.getInstance().addLinks(links, this.hideGrabber, this.autostart);
    }

    public void setLinkData(ArrayList<DownloadLink> linkData) {
        this.linkData = linkData;
    }

    public String getRestData() {
        return this.data;
    }

    public static void loadAndParse(String linkstring) {
        JDController.getInstance().distributeLinks(DistributeData.getLoadLinkString(linkstring));
    }

    private static String getLoadLinkString(String linkstring) {
        StringBuffer sb = new StringBuffer();
        String[] links = HTMLParser.getHttpLinks((String)linkstring, null);
        ProgressController pc = new ProgressController(JDL.LF((String)"gui.addurls.progress", (String)"Parse %s URL(s)", (Object[])new Object[]{links.length}), links.length);
        int i = 0;
        String[] stringArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            Browser br = new Browser();
            try {
                String[] found;
                new URL(l);
                pc.setStatusText(JDL.LF((String)"gui.addurls.progress.get", (String)"Parse %s URL(s). Get %s links", (Object[])new Object[]{links.length, l}));
                br.getPage(l);
                String[] stringArray2 = found = HTMLParser.getHttpLinks((String)("" + br), (String)l);
                int n3 = found.length;
                int n4 = 0;
                while (n4 < n3) {
                    String f = stringArray2[n4];
                    ++i;
                    sb.append("\r\n" + f);
                    ++n4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            pc.setStatusText(JDL.LF((String)"gui.addurls.progress.found", (String)"Parse %s URL(s). Found %s links", (Object[])new Object[]{links.length, i}));
            pc.increase(1L);
            ++n2;
        }
        JDLogger.getLogger().info("Found Links" + sb);
        pc.doFinalize(2000L);
        return sb.toString();
    }
}

