/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Timer;
import jd.Main;
import jd.controlling.DownloadControllerBroadcaster;
import jd.controlling.DownloadControllerEvent;
import jd.controlling.DownloadControllerListener;
import jd.controlling.DownloadInformations;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.nutils.JDFlags;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageEvent;
import jd.plugins.FilePackageListener;
import jd.plugins.PluginForHost;
import jd.plugins.PluginsC;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadController
implements FilePackageListener,
DownloadControllerListener,
ActionListener {
    public static final byte MOVE_BEFORE = 1;
    public static final byte MOVE_AFTER = 2;
    public static final byte MOVE_BEGIN = 3;
    public static final byte MOVE_END = 4;
    public static final byte MOVE_TOP = 5;
    public static final byte MOVE_BOTTOM = 6;
    public static final byte MOVE_UP = 7;
    public static final byte MOVE_DOWN = 8;
    public static final Object ControllerLock = new Object();
    private static DownloadController INSTANCE = null;
    private ArrayList<FilePackage> packages = new ArrayList();
    private Logger logger = null;
    private JDController controller;
    private transient DownloadControllerBroadcaster broadcaster = new DownloadControllerBroadcaster();
    private Timer asyncSaveIntervalTimer;
    private boolean saveinprogress;

    public static synchronized DownloadController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DownloadController();
        }
        return INSTANCE;
    }

    private DownloadController() {
        this.logger = JDLogger.getLogger();
        this.controller = JDUtilities.getController();
        this.initDownloadLinks();
        this.asyncSaveIntervalTimer = new Timer(2000, this);
        this.asyncSaveIntervalTimer.setInitialDelay(2000);
        this.asyncSaveIntervalTimer.setRepeats(false);
        this.broadcaster.addListener(this);
    }

    public void addListener(DownloadControllerListener l) {
        this.broadcaster.addListener(l);
    }

    public void removeListener(DownloadControllerListener l) {
        this.broadcaster.removeListener(l);
    }

    private void initDownloadLinks() {
        try {
            this.packages = this.loadDownloadLinks();
        }
        catch (Exception e) {
            this.packages = null;
        }
        if (this.packages == null) {
            this.packages = new ArrayList();
            File file = JDUtilities.getResourceFile("backup/links.linkbackup");
            if (file.exists()) {
                this.logger.warning("Strange: No Linklist,Try to restore from backup file");
                this.controller.loadContainerFile(file);
            }
            return;
        }
        if (this.packages.size() == 0 && Main.returnedfromUpdate()) {
            File file = JDUtilities.getResourceFile("backup/links.linkbackup");
            if (file.exists() && file.lastModified() >= System.currentTimeMillis() - 600000L) {
                this.logger.warning("Strange: Empty Linklist,Try to restore from backup file");
                this.controller.loadContainerFile(file);
            }
            return;
        }
        for (FilePackage filePackage : this.packages) {
            filePackage.addListener((FilePackageListener)this);
            filePackage.update_linksDisabled();
            for (DownloadLink downloadLink : filePackage.getDownloadLinkList()) {
                downloadLink.getBroadcaster().addListener(filePackage);
            }
        }
    }

    public void saveDownloadLinksAsync() {
        if (this.saveinprogress) {
            return;
        }
        this.asyncSaveIntervalTimer.restart();
    }

    public void saveDownloadLinksSync() {
        if (this.saveinprogress) {
            return;
        }
        new Thread(){

            public void run() {
                this.setName("DownloadController: Saving");
                DownloadController.this.saveDownloadLinksSyncnonThread();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDownloadLinksSyncnonThread() {
        String id = JDController.requestDelayExit("downloadcontroller");
        ArrayList<FilePackage> arrayList = this.packages;
        synchronized (arrayList) {
            this.saveinprogress = true;
            JDUtilities.getDatabaseConnector().saveLinks(this.packages);
            this.saveinprogress = false;
        }
        JDController.releaseDelayExit(id);
    }

    private ArrayList<FilePackage> loadDownloadLinks() throws Exception {
        Object obj = JDUtilities.getDatabaseConnector().getLinks();
        if (obj != null && obj instanceof ArrayList && (((ArrayList)obj).size() == 0 || ((ArrayList)obj).size() > 0 && ((ArrayList)obj).get(0) instanceof FilePackage)) {
            ArrayList packages = (ArrayList)obj;
            Iterator iterator = packages.iterator();
            PluginForHost pluginForHost = null;
            PluginsC pluginForContainer = null;
            String tmp2 = null;
            while (iterator.hasNext()) {
                FilePackage fp = (FilePackage)iterator.next();
                if (fp.getDownloadLinkList().size() == 0) {
                    iterator.remove();
                    continue;
                }
                Iterator it = fp.getDownloadLinkList().iterator();
                while (it.hasNext()) {
                    DownloadLink localLink = (DownloadLink)it.next();
                    int curState = 1;
                    int curLState = 1;
                    tmp2 = null;
                    if (localLink.getLinkStatus().isFinished() || localLink.getLinkStatus().hasStatus(32)) {
                        curState = localLink.getLinkStatus().getStatus();
                        curLState = localLink.getLinkStatus().getLatestStatus();
                        tmp2 = localLink.getLinkStatus().getErrorMessage();
                    }
                    curState = JDFlags.filterFlags(curState, 8227);
                    curLState = JDFlags.filterFlags(curLState, 8227);
                    localLink.getLinkStatus().reset();
                    localLink.getLinkStatus().setStatus(curState);
                    localLink.getLinkStatus().setLatestStatus(curLState);
                    localLink.getLinkStatus().setErrorMessage(tmp2);
                    if (localLink.getLinkStatus().isFinished() && JDUtilities.getConfiguration().getIntegerProperty("FINISHED_DOWNLOADS_ACTION") == 1) {
                        it.remove();
                        if (fp.getDownloadLinkList().size() != 0) continue;
                        iterator.remove();
                        continue;
                    }
                    try {
                        pluginForHost = JDUtilities.getNewPluginForHostInstance(localLink.getHost());
                    }
                    catch (Exception e) {
                        JDLogger.exception(e);
                    }
                    try {
                        if (localLink.getContainer() != null && (pluginForContainer = JDUtilities.getPluginForContainer(localLink.getContainer(), localLink.getContainerFile())) == null) {
                            localLink.setEnabled(false);
                        }
                    }
                    catch (NullPointerException e) {
                        JDLogger.exception(e);
                    }
                    if (pluginForHost != null) {
                        localLink.setLoadedPlugin(pluginForHost);
                    }
                    if (pluginForContainer != null) {
                        localLink.setLoadedPluginForContainer(pluginForContainer);
                    }
                    if (pluginForHost != null) continue;
                    this.logger.severe("couldn't find plugin(" + localLink.getHost() + ") for this DownloadLink." + localLink.getName());
                }
            }
            return packages;
        }
        if (obj != null && obj instanceof Vector && (((Vector)obj).size() == 0 || ((Vector)obj).size() > 0 && ((Vector)obj).get(0) instanceof FilePackage)) {
            Vector packages = (Vector)obj;
            ArrayList<FilePackage> convert = new ArrayList<FilePackage>();
            Iterator iterator = packages.iterator();
            PluginForHost pluginForHost = null;
            PluginsC pluginForContainer = null;
            String tmp1 = null;
            String tmp2 = null;
            while (iterator.hasNext()) {
                FilePackage fp = (FilePackage)iterator.next();
                if (fp.getDownloadLinkList() == null) {
                    fp.convert();
                }
                convert.add(fp);
                if (fp.getDownloadLinkList().size() == 0) {
                    convert.remove(fp);
                    continue;
                }
                Iterator it = fp.getDownloadLinkList().iterator();
                while (it.hasNext()) {
                    DownloadLink localLink = (DownloadLink)it.next();
                    if (!localLink.getLinkStatus().hasStatus(2)) {
                        tmp1 = localLink.getLinkStatus().getStatusText();
                        tmp2 = localLink.getLinkStatus().getErrorMessage();
                        localLink.getLinkStatus().reset();
                        localLink.getLinkStatus().setErrorMessage(tmp2);
                        localLink.getLinkStatus().setStatusText(tmp1);
                    }
                    if (localLink.getLinkStatus().hasStatus(2) && JDUtilities.getConfiguration().getIntegerProperty("FINISHED_DOWNLOADS_ACTION") == 1) {
                        it.remove();
                        if (fp.getDownloadLinkList().size() != 0) continue;
                        convert.remove(fp);
                        continue;
                    }
                    try {
                        pluginForHost = JDUtilities.getNewPluginForHostInstance(localLink.getHost());
                    }
                    catch (Exception e) {
                        JDLogger.exception(e);
                    }
                    try {
                        if (localLink.getContainer() != null && (pluginForContainer = JDUtilities.getPluginForContainer(localLink.getContainer(), localLink.getContainerFile())) == null) {
                            localLink.setEnabled(false);
                        }
                    }
                    catch (NullPointerException e) {
                        JDLogger.exception(e);
                    }
                    if (pluginForHost != null) {
                        localLink.setLoadedPlugin(pluginForHost);
                    }
                    if (pluginForContainer != null) {
                        localLink.setLoadedPluginForContainer(pluginForContainer);
                    }
                    if (pluginForHost != null) continue;
                    this.logger.severe("couldn't find plugin(" + localLink.getHost() + ") for this DownloadLink." + localLink.getName());
                }
            }
            return convert;
        }
        throw new Exception("Linklist incompatible");
    }

    public ArrayList<FilePackage> getPackages() {
        return this.packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(ArrayList<FilePackage> links) {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<FilePackage> arrayList = this.packages;
            synchronized (arrayList) {
                int i = 0;
                while (i < links.size()) {
                    this.addPackage(links.get(i));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(FilePackage fp) {
        if (fp == null) {
            return;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<FilePackage> arrayList = this.packages;
            synchronized (arrayList) {
                if (!this.packages.contains(fp)) {
                    fp.addListener((FilePackageListener)this);
                    this.packages.add(fp);
                    this.broadcaster.fireEvent(new DownloadControllerEvent(this, 2, fp));
                }
            }
        }
    }

    public int indexOf(FilePackage fp) {
        return this.packages.indexOf(fp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addPackageAt(FilePackage fp, int index, int repos) {
        if (fp == null) {
            return repos;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<FilePackage> arrayList = this.packages;
            synchronized (arrayList) {
                if (this.packages.size() == 0) {
                    this.addPackage(fp);
                    return repos;
                }
                boolean newadded = false;
                if (this.packages.contains(fp)) {
                    int posa = this.indexOf(fp);
                    if (posa < index) {
                        index -= ++repos;
                    }
                    this.packages.remove(fp);
                    if (index > this.packages.size() - 1) {
                        this.packages.add(fp);
                    } else if (index < 0) {
                        this.packages.add(0, fp);
                    } else {
                        this.packages.add(index, fp);
                    }
                } else {
                    if (index > this.packages.size() - 1) {
                        this.packages.add(fp);
                    } else if (index < 0) {
                        this.packages.add(0, fp);
                    } else {
                        this.packages.add(index, fp);
                    }
                    newadded = true;
                }
                if (newadded) {
                    fp.addListener((FilePackageListener)this);
                    this.broadcaster.fireEvent(new DownloadControllerEvent(this, 2, fp));
                } else {
                    this.broadcaster.fireEvent(new DownloadControllerEvent(this, 1));
                }
            }
        }
        return repos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllAt(ArrayList<FilePackage> links, int index) {
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<FilePackage> arrayList = this.packages;
            synchronized (arrayList) {
                int repos = 0;
                int i = 0;
                while (i < links.size()) {
                    repos = this.addPackageAt(links.get(i), index + i, repos);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackage(FilePackage fp2) {
        if (fp2 == null) {
            return;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<FilePackage> arrayList = this.packages;
            synchronized (arrayList) {
                fp2.abortDownload();
                fp2.removeListener((FilePackageListener)this);
                if (this.packages.remove(fp2)) {
                    this.broadcaster.fireEvent(new DownloadControllerEvent(this, 3, fp2));
                }
            }
        }
    }

    public int size() {
        return this.packages.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DownloadLink> getAllDownloadLinks() {
        ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>();
        ArrayList<FilePackage> arrayList = this.packages;
        synchronized (arrayList) {
            for (FilePackage fp : this.packages) {
                ret.addAll(fp.getDownloadLinkList());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDownloadStatus(DownloadInformations ds) {
        ds.reset();
        ds.addRunningDownloads(DownloadWatchDog.getInstance().getActiveDownloads());
        ArrayList<FilePackage> arrayList = this.packages;
        synchronized (arrayList) {
            for (FilePackage fp : this.packages) {
                ds.addPackages(1);
                ds.addDownloadLinks(fp.getDownloadLinkList().size());
                for (DownloadLink l : fp.getDownloadLinkList()) {
                    if (!l.getLinkStatus().hasStatus(8192) && l.isEnabled()) {
                        ds.addTotalDownloadSize(l.getDownloadSize());
                        ds.addCurrentDownloadSize(l.getDownloadCurrent());
                    }
                    if (l.getLinkStatus().hasStatus(8192)) {
                        ds.addDuplicateDownloads(1);
                        continue;
                    }
                    if (!l.isEnabled()) {
                        ds.addDisabledDownloads(1);
                        continue;
                    }
                    if (!l.getLinkStatus().hasStatus(2)) continue;
                    ds.addFinishedDownloads(1);
                }
            }
        }
    }

    public boolean hasDownloadLinkwithURL(String url) {
        if (url == null) {
            return false;
        }
        url = url.trim();
        for (DownloadLink dl : this.getAllDownloadLinks()) {
            if (dl.getDownloadURL() == null || !dl.getDownloadURL().equalsIgnoreCase(url)) continue;
            return true;
        }
        return false;
    }

    public DownloadLink getFirstLinkThatBlocks(DownloadLink link) {
        for (DownloadLink nextDownloadLink : this.getAllDownloadLinks()) {
            if (nextDownloadLink == link) continue;
            if (nextDownloadLink.getLinkStatus().hasStatus(2) && nextDownloadLink.getFileOutput().equalsIgnoreCase(link.getFileOutput()) && new File(nextDownloadLink.getFileOutput()).exists()) {
                return nextDownloadLink;
            }
            if (!nextDownloadLink.getLinkStatus().isPluginInProgress() || !nextDownloadLink.getFileOutput().equalsIgnoreCase(link.getFileOutput())) continue;
            return nextDownloadLink;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Object src2, Object dst, byte mode) {
        boolean type = false;
        Object src = null;
        FilePackage fp = null;
        if (src2 instanceof ArrayList) {
            if (((ArrayList)src2).isEmpty()) {
                return;
            }
            Object check = ((ArrayList)src2).get(0);
            if (check == null) {
                this.logger.warning("Null src, cannot move!");
                return;
            }
            if (check instanceof DownloadLink) {
                src = src2;
                type = false;
            } else if (check instanceof FilePackage) {
                src = src2;
                type = true;
            }
        } else if (src2 instanceof DownloadLink) {
            type = false;
            src = new ArrayList<Object>();
            ((ArrayList)src).add((DownloadLink)src2);
        } else if (src2 instanceof FilePackage) {
            type = true;
            src = new ArrayList();
            ((ArrayList)src).add((FilePackage)src2);
        }
        if (src == null) {
            this.logger.warning("Unknown src, cannot move!");
            return;
        }
        Object object = ControllerLock;
        synchronized (object) {
            ArrayList<FilePackage> arrayList = this.packages;
            synchronized (arrayList) {
                if (dst != null) {
                    if (!type) {
                        if (dst instanceof FilePackage) {
                            switch (mode) {
                                case 3: {
                                    fp = (FilePackage)dst;
                                    fp.addLinksAt((ArrayList)src, 0);
                                    return;
                                }
                                case 4: {
                                    fp = (FilePackage)dst;
                                    fp.addLinksAt((ArrayList)src, fp.size());
                                    return;
                                }
                            }
                            this.logger.warning("Unsupported mode, cannot move!");
                            return;
                        }
                        if (dst instanceof DownloadLink) {
                            switch (mode) {
                                case 1: {
                                    fp = ((DownloadLink)dst).getFilePackage();
                                    fp.addLinksAt((ArrayList)src, fp.indexOf((DownloadLink)dst));
                                    return;
                                }
                                case 2: {
                                    fp = ((DownloadLink)dst).getFilePackage();
                                    fp.addLinksAt((ArrayList)src, fp.indexOf((DownloadLink)dst) + 1);
                                    return;
                                }
                            }
                            this.logger.warning("Unsupported mode, cannot move!");
                            return;
                        }
                        this.logger.warning("Unsupported dst, cannot move!");
                        return;
                    }
                    if (dst instanceof FilePackage) {
                        switch (mode) {
                            case 1: {
                                this.addAllAt((ArrayList)src, this.indexOf((FilePackage)dst));
                                return;
                            }
                            case 2: {
                                this.addAllAt((ArrayList)src, this.indexOf((FilePackage)dst) + 1);
                                return;
                            }
                        }
                        this.logger.warning("Unsupported mode, cannot move!");
                        return;
                    }
                    if (dst instanceof DownloadLink) {
                        this.logger.warning("Unsupported mode, cannot move!");
                        return;
                    }
                } else {
                    if (type) {
                        switch (mode) {
                            case 7: {
                                int curpos = 0;
                                for (FilePackage item : (ArrayList)src) {
                                    curpos = this.indexOf(item);
                                    this.addPackageAt(item, curpos - 1, 0);
                                }
                                return;
                            }
                            case 8: {
                                int curpos = 0;
                                ArrayList fps = (ArrayList)src;
                                int i = fps.size() - 1;
                                while (i >= 0) {
                                    curpos = this.indexOf((FilePackage)fps.get(i));
                                    this.addPackageAt((FilePackage)fps.get(i), curpos + 2, 0);
                                    --i;
                                }
                                return;
                            }
                            case 5: {
                                this.addAllAt((ArrayList)src, 0);
                                return;
                            }
                            case 6: {
                                this.addAllAt((ArrayList)src, this.size() + 1);
                                return;
                            }
                        }
                        this.logger.warning("Unsupported mode, cannot move!");
                        return;
                    }
                    switch (mode) {
                        case 7: {
                            int curpos = 0;
                            for (DownloadLink item : (ArrayList)src) {
                                curpos = item.getFilePackage().indexOf(item);
                                item.getFilePackage().add(curpos - 1, item, 0);
                                if (curpos != 0) continue;
                                curpos = this.indexOf(item.getFilePackage());
                                this.addPackageAt(item.getFilePackage(), curpos - 1, 0);
                            }
                            return;
                        }
                        case 8: {
                            int curpos = 0;
                            ArrayList links = (ArrayList)src;
                            int i = links.size() - 1;
                            while (i >= 0) {
                                curpos = ((DownloadLink)links.get(i)).getFilePackage().indexOf((DownloadLink)links.get(i));
                                ((DownloadLink)links.get(i)).getFilePackage().add(curpos + 2, (DownloadLink)links.get(i), 0);
                                if (curpos == ((DownloadLink)links.get(i)).getFilePackage().size() - 1) {
                                    curpos = this.indexOf(((DownloadLink)links.get(i)).getFilePackage());
                                    this.addPackageAt(((DownloadLink)links.get(i)).getFilePackage(), curpos + 2, 0);
                                }
                                --i;
                            }
                            return;
                        }
                        case 5: {
                            ArrayList<ArrayList<DownloadLink>> split = DownloadController.splitByFilePackage((ArrayList)src);
                            for (ArrayList<DownloadLink> links : split) {
                                if (links.get(0).getFilePackage().indexOf(links.get(0)) == 0) {
                                    this.addPackageAt(links.get(0).getFilePackage(), 0, 0);
                                }
                                links.get(0).getFilePackage().addLinksAt(links, 0);
                            }
                            return;
                        }
                        case 6: {
                            ArrayList<ArrayList<DownloadLink>> split = DownloadController.splitByFilePackage((ArrayList)src);
                            for (ArrayList<DownloadLink> links : split) {
                                if (links.get(0).getFilePackage().indexOf(links.get(links.size() - 1)) == links.get(0).getFilePackage().size() - 1) {
                                    this.addPackageAt(links.get(0).getFilePackage(), this.size() + 1, 0);
                                }
                                links.get(0).getFilePackage().addLinksAt(links, links.get(0).getFilePackage().size() + 1);
                            }
                            return;
                        }
                    }
                    this.logger.warning("Unsupported mode, cannot move!");
                    return;
                }
            }
        }
    }

    public static ArrayList<ArrayList<DownloadLink>> splitByFilePackage(ArrayList<DownloadLink> links) {
        ArrayList<ArrayList<DownloadLink>> ret = new ArrayList<ArrayList<DownloadLink>>();
        boolean added = false;
        for (DownloadLink link : links) {
            ArrayList<DownloadLink> tmp;
            if (ret.size() == 0) {
                tmp = new ArrayList<DownloadLink>();
                tmp.add(link);
                ret.add(tmp);
                continue;
            }
            added = false;
            for (ArrayList<DownloadLink> check : ret) {
                if (link.getFilePackage() != check.get(0).getFilePackage()) continue;
                added = true;
                check.add(link);
            }
            if (added) continue;
            tmp = new ArrayList();
            tmp.add(link);
            ret.add(tmp);
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.asyncSaveIntervalTimer) {
            this.saveDownloadLinksSync();
        }
    }

    public void fireStructureUpdate() {
        this.broadcaster.fireEvent(new DownloadControllerEvent(this, 1));
    }

    public void fireGlobalUpdate() {
        this.broadcaster.fireEvent(new DownloadControllerEvent(this, 12));
    }

    public void fireDownloadLinkUpdate(Object param) {
        this.broadcaster.fireEvent(new DownloadControllerEvent(this, 11, param));
    }

    @Override
    public void onDownloadControllerEvent(DownloadControllerEvent event) {
        switch (event.getID()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.fireStructureUpdate();
                break;
            }
            case 1: {
                this.saveDownloadLinksAsync();
            }
        }
    }

    public void onFilePackageEvent(FilePackageEvent event) {
        switch (event.getID()) {
            case 2: {
                this.broadcaster.fireEvent(new DownloadControllerEvent(this, 4, event.getParameter()));
                break;
            }
            case 3: {
                this.broadcaster.fireEvent(new DownloadControllerEvent(this, 5, event.getParameter()));
                break;
            }
            case 1: {
                this.fireStructureUpdate();
                break;
            }
            case 999: {
                this.removePackage((FilePackage)event.getSource());
            }
        }
    }
}

