/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import jd.config.SubConfiguration;
import jd.controlling.DownloadController;
import jd.controlling.DownloadControllerEvent;
import jd.controlling.DownloadControllerListener;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.controlling.SingleDownloadController;
import jd.controlling.interaction.Interaction;
import jd.controlling.reconnect.Reconnecter;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.nutils.JDFlags;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.LinkStatus;
import jd.plugins.PluginForHost;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadWatchDog
implements ControlListener,
DownloadControllerListener {
    private boolean aborted = false;
    private boolean aborting;
    private HashMap<DownloadLink, SingleDownloadController> DownloadControllers = new HashMap();
    private static final Object nostopMark = new Object();
    private static final Object hiddenstopMark = new Object();
    private Object stopMark = nostopMark;
    private HashMap<String, Integer> activeHosts = new HashMap();
    private Logger logger = JDLogger.getLogger();
    private boolean paused = false;
    private int totalSpeed = 0;
    private Thread watchDogThread = null;
    private DownloadController dlc = null;
    private Integer activeDownloads = new Integer(0);
    private static DownloadWatchDog INSTANCE;

    public static synchronized DownloadWatchDog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DownloadWatchDog();
        }
        return INSTANCE;
    }

    public int getActiveDownloads() {
        return this.activeDownloads;
    }

    private DownloadWatchDog() {
        this.dlc = DownloadController.getInstance();
        this.dlc.addListener(this);
    }

    public void start() {
        if (this.reachedStopMark()) {
            this.stopMark = nostopMark;
        }
        if (SubConfiguration.getConfig("DOWNLOAD").getProperty("MAXSPEEDBEFOREPAUSE", null) != null) {
            this.logger.info("Restoring old speedlimit");
            SubConfiguration.getConfig("DOWNLOAD").setProperty("DOWNLOAD_MAX_SPEED_V2", SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("MAXSPEEDBEFOREPAUSE", 0));
            SubConfiguration.getConfig("DOWNLOAD").setProperty("MAXSPEEDBEFOREPAUSE", null);
            SubConfiguration.getConfig("DOWNLOAD").save();
        }
        this.startWatchDogThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopMark(Object entry) {
        Object object = this.stopMark;
        synchronized (object) {
            if (entry == null) {
                entry = nostopMark;
            }
            if (this.stopMark instanceof DownloadLink) {
                DownloadController.getInstance().fireDownloadLinkUpdate(this.stopMark);
            } else if (this.stopMark instanceof FilePackage) {
                DownloadController.getInstance().fireDownloadLinkUpdate(((FilePackage)this.stopMark).get(0));
            }
            this.stopMark = entry;
            if (entry instanceof DownloadLink) {
                DownloadController.getInstance().fireDownloadLinkUpdate(entry);
            } else if (entry instanceof FilePackage) {
                DownloadController.getInstance().fireDownloadLinkUpdate(((FilePackage)entry).get(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleStopMark(Object entry) {
        Object object = this.stopMark;
        synchronized (object) {
            if (entry == null || entry == this.stopMark) {
                this.setStopMark(nostopMark);
                return;
            }
            this.setStopMark(entry);
        }
    }

    public Object getStopMark() {
        return this.stopMark;
    }

    public boolean isStopMark(Object item) {
        return this.stopMark == item;
    }

    void abort() {
        this.logger.finer("Breche alle activeLinks ab");
        this.aborting = true;
        this.aborted = true;
        ProgressController progress = new ProgressController("Termination", this.activeDownloads.intValue());
        progress.setStatusText("Stopping all downloads " + this.activeDownloads);
        ArrayList<DownloadLink> al = new ArrayList<DownloadLink>();
        ArrayList<SingleDownloadController> cons = new ArrayList<SingleDownloadController>(this.DownloadControllers.values());
        for (SingleDownloadController singleDownloadController : cons) {
            al.add(singleDownloadController.abortDownload().getDownloadLink());
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(al);
        boolean check = true;
        this.logger.finer("Warten bis alle activeLinks abgebrochen wurden.");
        block3: while (true) {
            progress.setStatusText("Stopping all downloads " + this.activeDownloads);
            check = true;
            ArrayList<DownloadLink> links = new ArrayList<DownloadLink>(this.DownloadControllers.keySet());
            for (DownloadLink link : links) {
                if (!link.getLinkStatus().isPluginActive()) continue;
                check = false;
                break;
            }
            if (check) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException link) {
                // empty catch block
            }
            cons = new ArrayList<SingleDownloadController>(this.DownloadControllers.values());
            Iterator<Object> iterator = cons.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block3;
                SingleDownloadController singleDownloadController = (SingleDownloadController)iterator.next();
                al.add(singleDownloadController.abortDownload().getDownloadLink());
            }
            break;
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(al);
        progress.doFinalize();
        this.logger.finer("Stopped Downloads");
        this.clearDownloadListStatus();
        this.aborting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDownloadListStatus() {
        ArrayList<FilePackage> fps;
        ArrayList links = new ArrayList(this.DownloadControllers.keySet());
        for (DownloadLink link : links) {
            this.deactivateDownload(link);
        }
        PluginForHost.resetStatics();
        ArrayList<FilePackage> arrayList = fps = this.dlc.getPackages();
        synchronized (arrayList) {
            for (FilePackage filePackage : fps) {
                links = filePackage.getDownloadLinkList();
                int i = 0;
                while (i < links.size()) {
                    DownloadLink link = (DownloadLink)links.get(i);
                    int curState = 1;
                    int curLState = 1;
                    String tmp2 = null;
                    if (link.getLinkStatus().isFinished() || link.getLinkStatus().hasStatus(32)) {
                        curState = link.getLinkStatus().getStatus();
                        curLState = link.getLinkStatus().getLatestStatus();
                        tmp2 = link.getLinkStatus().getErrorMessage();
                    }
                    curState = JDFlags.filterFlags(curState, 8227);
                    curLState = JDFlags.filterFlags(curLState, 8227);
                    link.getLinkStatus().setStatusText(null);
                    link.getLinkStatus().setErrorMessage(tmp2);
                    link.setAborted(false);
                    link.getLinkStatus().setStatus(curState);
                    link.getLinkStatus().setLatestStatus(curLState);
                    link.getLinkStatus().resetWaitTime();
                    ++i;
                }
            }
        }
        DownloadController.getInstance().fireGlobalUpdate();
    }

    public ArrayList<DownloadLink> getRunningDownloads() {
        return new ArrayList<DownloadLink>(this.DownloadControllers.keySet());
    }

    @Override
    public void controlEvent(ControlEvent event) {
        if (event.getID() == 4 && event.getSource() instanceof PluginForHost) {
            this.deactivateDownload(((SingleDownloadController)event.getParameter()).getDownloadLink());
        }
    }

    public int ActiveDownloadControllers() {
        return this.DownloadControllers.keySet().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int activeDownloadsbyHosts(PluginForHost plugin) {
        HashMap<String, Integer> hashMap = this.activeHosts;
        synchronized (hashMap) {
            if (this.activeHosts.containsKey(plugin.getHost())) {
                return this.activeHosts.get(plugin.getHost());
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateDownload(DownloadLink link, SingleDownloadController con) {
        Serializable serializable;
        HashMap<DownloadLink, SingleDownloadController> hashMap = this.DownloadControllers;
        synchronized (hashMap) {
            if (this.DownloadControllers.containsKey(link)) {
                return;
            }
            this.DownloadControllers.put(link, con);
            serializable = this.activeDownloads;
            synchronized (serializable) {
                this.activeDownloads = this.activeDownloads + 1;
            }
        }
        String cl = link.getHost();
        serializable = this.activeHosts;
        synchronized (serializable) {
            if (this.activeHosts.containsKey(cl)) {
                int count = this.activeHosts.get(cl);
                this.activeHosts.put(cl, count + 1);
            } else {
                this.activeHosts.put(cl, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateDownload(DownloadLink link) {
        Serializable serializable;
        HashMap<DownloadLink, SingleDownloadController> hashMap = this.DownloadControllers;
        synchronized (hashMap) {
            if (!this.DownloadControllers.containsKey(link)) {
                this.logger.severe("Link not in ControllerList!");
                return;
            }
            this.DownloadControllers.remove(link);
            serializable = this.activeDownloads;
            synchronized (serializable) {
                this.activeDownloads = this.activeDownloads - 1;
            }
        }
        String cl = link.getHost();
        serializable = this.activeHosts;
        synchronized (serializable) {
            if (this.activeHosts.containsKey(cl)) {
                int count = this.activeHosts.get(cl);
                if (count - 1 < 0) {
                    this.logger.severe("WatchDog Counter MissMatch!!");
                    this.activeHosts.remove(cl);
                } else {
                    this.activeHosts.put(cl, count - 1);
                }
            } else {
                this.logger.severe("WatchDog Counter MissMatch!!");
            }
        }
    }

    public DownloadLink getNextDownloadLink() {
        if (this.reachedStopMark()) {
            return null;
        }
        DownloadLink nextDownloadLink2 = null;
        DownloadLink returnDownloadLink = null;
        try {
            for (FilePackage filePackage : this.dlc.getPackages()) {
                for (DownloadLink nextDownloadLink2 : filePackage.getDownloadLinkList()) {
                    if (!nextDownloadLink2.getLinkStatus().isPluginActive() && nextDownloadLink2.getLinkStatus().hasStatus(1024)) {
                        nextDownloadLink2.reset();
                        nextDownloadLink2.getLinkStatus().setStatus(1);
                    }
                    if (!nextDownloadLink2.isEnabled() || nextDownloadLink2.getLinkStatus().hasStatus(2048) || !nextDownloadLink2.getPlugin().ignoreHosterWaittime() && nextDownloadLink2.getPlugin().getRemainingHosterWaittime() > 0L || this.isDownloadLinkActive(nextDownloadLink2) || nextDownloadLink2.getLinkStatus().isPluginActive() || !nextDownloadLink2.getLinkStatus().isStatus(1)) continue;
                    int maxPerHost = this.getSimultanDownloadNumPerHost();
                    if (this.activeDownloadsbyHosts(nextDownloadLink2.getPlugin()) >= nextDownloadLink2.getPlugin().getMaxSimultanDownloadNum(nextDownloadLink2) || this.activeDownloadsbyHosts(nextDownloadLink2.getPlugin()) >= maxPerHost || !nextDownloadLink2.getPlugin().getWrapper().usePlugin()) continue;
                    if (returnDownloadLink == null) {
                        returnDownloadLink = nextDownloadLink2;
                        continue;
                    }
                    if (nextDownloadLink2.getPriority() <= returnDownloadLink.getPriority()) continue;
                    returnDownloadLink = nextDownloadLink2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnDownloadLink;
    }

    public int getSimultanDownloadNum() {
        return SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SIMULTAN", 2);
    }

    public int getSimultanDownloadNumPerHost() {
        if (SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SIMULTAN_PER_HOST", 0) == 0) {
            return Integer.MAX_VALUE;
        }
        return SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SIMULTAN_PER_HOST", 0);
    }

    public int getTotalSpeed() {
        return this.totalSpeed;
    }

    public boolean isAborted() {
        if (this.watchDogThread == null) {
            return false;
        }
        return !this.watchDogThread.isAlive();
    }

    public boolean isAlive() {
        if (this.watchDogThread == null) {
            return false;
        }
        return this.watchDogThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDownloadLinkActive(DownloadLink nextDownloadLink) {
        HashMap<DownloadLink, SingleDownloadController> hashMap = this.DownloadControllers;
        synchronized (hashMap) {
            return this.DownloadControllers.containsKey(nextDownloadLink);
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause(boolean value) {
        if (this.paused == value) {
            return;
        }
        this.paused = value;
        if (value) {
            SubConfiguration.getConfig("DOWNLOAD").setProperty("MAXSPEEDBEFOREPAUSE", SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0));
            SubConfiguration.getConfig("DOWNLOAD").setProperty("DOWNLOAD_MAX_SPEED_V2", SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("PAUSE_SPEED", 10));
            this.logger.info("Pause enabled: Reducing downloadspeed to " + SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("PAUSE_SPEED", 10) + " kb/s");
        } else {
            SubConfiguration.getConfig("DOWNLOAD").setProperty("DOWNLOAD_MAX_SPEED_V2", SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("MAXSPEEDBEFOREPAUSE", 0));
            SubConfiguration.getConfig("DOWNLOAD").setProperty("MAXSPEEDBEFOREPAUSE", null);
            this.logger.info("Pause disabled: Switch back to old downloadspeed");
        }
        SubConfiguration.getConfig("DOWNLOAD").save();
    }

    public boolean newDLStartAllowed() {
        return !this.paused && !Reconnecter.isReconnecting() && !this.aborting && !this.aborted && !Reconnecter.isReconnectPrefered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startWatchDogThread() {
        if (this.watchDogThread == null || !this.watchDogThread.isAlive()) {
            Integer n = this.activeDownloads;
            synchronized (n) {
                this.activeDownloads = 0;
            }
            this.watchDogThread = new Thread(){

                public void run() {
                    JDUtilities.getController().addControlListener(INSTANCE);
                    this.setName("DownloadWatchDog");
                    ArrayList<DownloadLink> updates = new ArrayList<DownloadLink>();
                    DownloadWatchDog.this.aborted = false;
                    DownloadWatchDog.this.aborting = false;
                    int stopCounter = 5;
                    int currentTotalSpeed = 0;
                    int inProgress = 0;
                    ArrayList removes = new ArrayList();
                    while (!DownloadWatchDog.this.aborted) {
                        Reconnecter.setReconnectRequested(false);
                        boolean hasInProgressLinks = false;
                        boolean hasTempDisabledLinks = false;
                        ArrayList<FilePackage> fps = DownloadWatchDog.this.dlc.getPackages();
                        currentTotalSpeed = 0;
                        inProgress = 0;
                        updates.clear();
                        try {
                            for (FilePackage filePackage : fps) {
                                ArrayList links = filePackage.getDownloadLinkList();
                                int i = 0;
                                while (i < links.size()) {
                                    DownloadLink link = (DownloadLink)links.get(i);
                                    if (link.getPlugin() != null) {
                                        LinkStatus linkStatus = link.getLinkStatus();
                                        if (link.isEnabled() && linkStatus.hasStatus(2048) && !linkStatus.hasStatus(262144)) {
                                            if (linkStatus.getRemainingWaittime() == 0L) {
                                                linkStatus.reset();
                                            } else if (linkStatus.getRemainingWaittime() > 0L) {
                                                hasTempDisabledLinks = true;
                                                updates.add(link);
                                            }
                                        }
                                        if (link.isEnabled() && linkStatus.hasStatus(16) && !linkStatus.hasStatus(262144)) {
                                            if (linkStatus.getRemainingWaittime() == 0L) {
                                                linkStatus.reset();
                                            } else if (linkStatus.getRemainingWaittime() > 0L) {
                                                Reconnecter.setReconnectRequested(true);
                                                updates.add(link);
                                            }
                                        }
                                        if (link.isEnabled() && link.getPlugin().getRemainingHosterWaittime() > 0L && !linkStatus.hasStatus(262144)) {
                                            Reconnecter.setReconnectRequested(true);
                                            updates.add(link);
                                        }
                                        if (link.isEnabled() && linkStatus.isPluginActive()) {
                                            hasInProgressLinks = true;
                                        }
                                        if (link.isEnabled() && linkStatus.hasStatus(1024)) {
                                            ++inProgress;
                                            currentTotalSpeed += link.getDownloadSpeed();
                                        }
                                    }
                                    ++i;
                                }
                            }
                            if (removes.size() > 0) {
                                for (DownloadLink dl : removes) {
                                    dl.getFilePackage().remove(dl);
                                }
                                removes.clear();
                            }
                            Reconnecter.doReconnectIfRequested(false);
                            if (inProgress > 0) {
                                fps = DownloadWatchDog.this.dlc.getPackages();
                                for (FilePackage filePackage : fps) {
                                    Iterator iter = filePackage.getDownloadLinkList().iterator();
                                    int maxspeed = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("DOWNLOAD_MAX_SPEED_V2", 0) * 1024;
                                    if (maxspeed == 0) {
                                        maxspeed = Integer.MAX_VALUE;
                                    }
                                    int overhead = maxspeed - currentTotalSpeed;
                                    DownloadWatchDog.this.totalSpeed = currentTotalSpeed;
                                    while (iter.hasNext()) {
                                        DownloadLink element = (DownloadLink)iter.next();
                                        if (!element.getLinkStatus().hasStatus(1024)) continue;
                                        element.setSpeedLimit(element.getDownloadSpeed() + overhead / inProgress);
                                    }
                                }
                            } else {
                                DownloadWatchDog.this.totalSpeed = 0;
                            }
                            if (updates.size() > 0) {
                                DownloadController.getInstance().fireDownloadLinkUpdate(updates);
                            }
                            int ret = 0;
                            if (Interaction.areInteractionsInProgress() && DownloadWatchDog.this.activeDownloads < DownloadWatchDog.this.getSimultanDownloadNum() && !DownloadWatchDog.this.reachedStopMark()) {
                                ret = DownloadWatchDog.this.setDownloadActive();
                            }
                            if (ret == 0) {
                                if (!(hasTempDisabledLinks || hasInProgressLinks || Reconnecter.isReconnectRequested() || DownloadWatchDog.this.getNextDownloadLink() != null || DownloadWatchDog.this.activeDownloads != 0)) {
                                    if (DownloadWatchDog.this.newDLStartAllowed()) {
                                        DownloadWatchDog.this.logger.info(String.valueOf(--stopCounter) + "rounds left to start new downloads");
                                    }
                                    if (stopCounter == 0) {
                                        DownloadWatchDog.this.totalSpeed = 0;
                                        break;
                                    }
                                }
                            } else {
                                stopCounter = 5;
                            }
                        }
                        catch (Exception e) {
                            JDLogger.exception(e);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    DownloadWatchDog.this.aborted = true;
                    while (DownloadWatchDog.this.aborting) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    JDUtilities.getController().fireControlEvent(new ControlEvent(this, 1, this));
                    JDUtilities.getController().removeControlListener(INSTANCE);
                    Interaction.handleInteraction(Interaction.INTERACTION_ALL_DOWNLOADS_FINISHED, this);
                    DownloadWatchDog.this.pause(false);
                }
            };
            this.watchDogThread.start();
        }
    }

    /*
     * Unable to fully structure code
     */
    private int setDownloadActive() {
        ret = 0;
        if (this.newDLStartAllowed()) ** GOTO lbl9
        return ret;
        while ((dlink = this.getNextDownloadLink()) != null && dlink == this.getNextDownloadLink()) {
            if (this.reachedStopMark()) {
                return ret;
            }
            this.startDownloadThread(dlink);
            ++ret;
lbl9:
            // 2 sources

            if (this.activeDownloads < this.getSimultanDownloadNum()) continue;
        }
        return ret;
    }

    public void setTotalSpeed(int totalSpeed) {
        this.totalSpeed = totalSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean reachedStopMark() {
        Object object = this.stopMark;
        synchronized (object) {
            DownloadLink dl;
            if (this.stopMark == hiddenstopMark) {
                return true;
            }
            if (this.stopMark instanceof DownloadLink) {
                return ((DownloadLink)this.stopMark).isEnabled() && (((DownloadLink)this.stopMark).getLinkStatus().isPluginActive() || ((DownloadLink)this.stopMark).getLinkStatus().hasStatus(2));
                {
                }
            }
            if (!(this.stopMark instanceof FilePackage)) {
                return false;
            }
            Iterator iterator = ((FilePackage)this.stopMark).getDownloadLinkList().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((dl = (DownloadLink)iterator.next()).getLinkStatus().hasStatus(2) || !dl.isEnabled() || dl.getLinkStatus().isPluginActive());
            return false;
        }
    }

    private void startDownloadThread(DownloadLink dlink) {
        Interaction.handleInteraction(Interaction.INTERACTION_BEFORE_DOWNLOAD, dlink);
        SingleDownloadController download = new SingleDownloadController(dlink);
        this.logger.info("Start new Download: " + dlink.getHost());
        dlink.getLinkStatus().setActive(true);
        this.activateDownload(dlink, download);
        download.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDownloadControllerEvent(DownloadControllerEvent event) {
        switch (event.getID()) {
            case 3: 
            case 5: {
                Object object = this.stopMark;
                synchronized (object) {
                    if (this.stopMark == event.getParameter()) {
                        this.setStopMark(hiddenstopMark);
                    }
                    break;
                }
            }
        }
    }
}

