/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jd.controlling.JDLogHandler;
import jd.controlling.LogFormatter;
import jd.nutils.Formatter;

public class JDLogger {
    private static Logger LOGGER = null;
    public static String LOGGER_NAME = "java_downloader";
    private static ConsoleHandler console;
    public static long INIT_TIME;

    static {
        INIT_TIME = System.currentTimeMillis();
    }

    protected JDLogger() {
    }

    public static Logger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger(LOGGER_NAME);
            LogFormatter formatter = new LogFormatter();
            LOGGER.setUseParentHandlers(false);
            console = new ConsoleHandler();
            console.setLevel(Level.ALL);
            console.setFormatter(formatter);
            LOGGER.addHandler(console);
            LOGGER.setLevel(Level.ALL);
            LOGGER.addHandler(JDLogHandler.getHandler());
            JDLogHandler.getHandler().setFormatter(formatter);
        }
        return LOGGER;
    }

    public static void timestamp(String msg) {
        JDLogger.getLogger().warning(String.valueOf(Formatter.formatMilliseconds(System.currentTimeMillis() - INIT_TIME)) + " : " + msg);
    }

    public static void exception(Throwable e) {
        JDLogger.exception(Level.SEVERE, e);
    }

    public static void removeConsoleHandler() {
        if (console != null) {
            JDLogger.getLogger().removeHandler(console);
        }
        System.err.println("Removed Consolehandler. Start with -debug to see console output");
    }

    public static void addHeader(String string) {
        JDLogger.getLogger().info("\r\n\r\n--------------------------------------" + string + "-----------------------------------");
    }

    public static void exception(Level level, Throwable e) {
        JDLogger.getLogger().log(level, String.valueOf(level.getName()) + " Exception occurred", e);
    }

    public static void quickLog() {
        System.out.println("Footstep: " + new Exception().getStackTrace()[1]);
    }

    public static void warning(Object o) {
        JDLogger.getLogger().warning(o.toString());
    }

    public static String getStackTrace(Throwable thrown) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        thrown.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String getLog(Level level) {
        Level tmp = JDLogger.getLogger().getLevel();
        JDLogger.getLogger().setLevel(level);
        try {
            ArrayList<LogRecord> buff = JDLogHandler.getHandler().getBuffer();
            StringBuilder sb = new StringBuilder();
            for (LogRecord lr : buff) {
                sb.append(JDLogHandler.getHandler().getFormatter().format(lr));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            JDLogger.getLogger().setLevel(tmp);
        }
    }
}

