/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Timer;
import jd.controlling.DownloadController;
import jd.controlling.LinkCheckBroadcaster;
import jd.controlling.LinkCheckEvent;
import jd.controlling.LinkCheckListener;
import jd.controlling.ProgressController;
import jd.controlling.ProgressControllerEvent;
import jd.controlling.ProgressControllerListener;
import jd.event.JDBroadcaster;
import jd.nutils.jobber.JDRunnable;
import jd.nutils.jobber.Jobber;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkCheck
implements ActionListener,
ProgressControllerListener {
    private static LinkCheck INSTANCE = null;
    private Timer checkTimer = null;
    private Thread checkThread = null;
    private ArrayList<DownloadLink> linksToCheck = new ArrayList();
    private boolean checkRunning = false;
    protected ProgressController pc;
    protected Jobber checkJobbers;
    private transient LinkCheckBroadcaster broadcaster = new LinkCheckBroadcaster();

    public static synchronized LinkCheck getLinkChecker() {
        if (INSTANCE == null) {
            INSTANCE = new LinkCheck();
        }
        return INSTANCE;
    }

    private LinkCheck() {
        this.checkTimer = new Timer(2000, this);
        this.checkTimer.setInitialDelay(2000);
        this.checkTimer.setRepeats(false);
    }

    public boolean isRunning() {
        return this.checkRunning;
    }

    public synchronized JDBroadcaster<LinkCheckListener, LinkCheckEvent> getBroadcaster() {
        if (this.broadcaster == null) {
            this.broadcaster = new LinkCheckBroadcaster();
        }
        return this.broadcaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkLinks(ArrayList<DownloadLink> links) {
        if (links == null || links.size() == 0) {
            return;
        }
        this.checkRunning = true;
        for (DownloadLink element : links) {
            ArrayList<DownloadLink> arrayList = this.linksToCheck;
            synchronized (arrayList) {
                if (!this.linksToCheck.contains(element)) {
                    this.linksToCheck.add(element);
                }
            }
        }
        this.checkTimer.restart();
    }

    private void checkHosterList(ArrayList<DownloadLink> hosterList) {
        if (hosterList.size() != 0) {
            DownloadLink link = hosterList.get(0);
            long timer = System.currentTimeMillis();
            boolean ret = ((PluginForHost)link.getPlugin().getWrapper().getNewPluginInstance()).checkLinks(hosterList.toArray(new DownloadLink[0]));
            if (!ret) {
                int i = 0;
                while (i < hosterList.size()) {
                    link = hosterList.get(i);
                    if (!this.checkRunning) {
                        return;
                    }
                    if (!link.getBooleanProperty("removed", false).booleanValue()) {
                        link.isAvailable();
                        this.getBroadcaster().fireEvent(new LinkCheckEvent(this, 4, link));
                    }
                    this.pc.increase(1L);
                    ++i;
                }
            } else {
                long reqtime = System.currentTimeMillis() - timer;
                for (DownloadLink d : hosterList) {
                    d.setRequestTime(reqtime);
                }
                this.getBroadcaster().fireEvent(new LinkCheckEvent(this, 4, hosterList));
                this.pc.increase(hosterList.size());
            }
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(hosterList);
    }

    private void startLinkCheck() {
        if (this.checkThread != null && this.checkThread.isAlive()) {
            return;
        }
        this.checkThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.setName("OnlineCheck");
                LinkCheck.this.getBroadcaster().fireEvent(new LinkCheckEvent(this, 1));
                LinkCheck.this.pc = new ProgressController(JDL.L((String)"gui.linkgrabber.pc.onlinecheck", (String)"Checking online availability..."));
                LinkCheck.this.pc.getBroadcaster().addListener(LinkCheck.getLinkChecker());
                LinkCheck.this.pc.setRange(0L);
                while (LinkCheck.this.linksToCheck.size() != 0) {
                    ArrayList currentList;
                    ArrayList arrayList = LinkCheck.this.linksToCheck;
                    synchronized (arrayList) {
                        currentList = new ArrayList(LinkCheck.this.linksToCheck);
                        LinkCheck.this.pc.addToMax(currentList.size());
                    }
                    HashMap<String, ArrayList<DownloadLink>> map = new HashMap<String, ArrayList<DownloadLink>>();
                    for (DownloadLink dl : currentList) {
                        ArrayList<DownloadLink> localList = (ArrayList<DownloadLink>)map.get(dl.getPlugin().getHost());
                        if (localList == null) {
                            localList = new ArrayList<DownloadLink>();
                            map.put(dl.getPlugin().getHost(), localList);
                        }
                        localList.add(dl);
                    }
                    LinkCheck.this.checkJobbers = new Jobber(4);
                    for (ArrayList hosterList : map.values()) {
                        CheckThread cthread = new CheckThread(hosterList);
                        LinkCheck.this.checkJobbers.add(cthread);
                    }
                    int todo = LinkCheck.this.checkJobbers.getJobsAdded();
                    LinkCheck.this.checkJobbers.start();
                    while (LinkCheck.this.checkJobbers.getJobsFinished() != todo) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    LinkCheck.this.checkJobbers.stop();
                    ArrayList e = LinkCheck.this.linksToCheck;
                    synchronized (e) {
                        LinkCheck.this.linksToCheck.removeAll(currentList);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e2) {
                        return;
                    }
                }
                LinkCheck.this.pc.doFinalize();
                LinkCheck.this.pc.getBroadcaster().removeListener(LinkCheck.getLinkChecker());
                LinkCheck.this.getBroadcaster().fireEvent(new LinkCheckEvent(this, 2));
                LinkCheck.this.checkRunning = false;
            }
        };
        this.checkThread.start();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.checkTimer) {
            this.checkTimer.stop();
            if (this.linksToCheck.size() > 0) {
                this.startLinkCheck();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortLinkCheck() {
        this.checkRunning = false;
        this.checkTimer.stop();
        if (this.checkThread != null && this.checkThread.isAlive()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    LinkCheck.this.pc.setStatusText(String.valueOf(LinkCheck.this.pc.getStatusText()) + ": Aborted");
                    LinkCheck.this.pc.doFinalize(5000L);
                }
            });
            this.checkJobbers.stop();
            this.checkThread.interrupt();
        }
        ArrayList<DownloadLink> arrayList = this.linksToCheck;
        synchronized (arrayList) {
            this.linksToCheck = new ArrayList();
        }
    }

    @Override
    public void onProgressControllerEvent(ProgressControllerEvent event) {
        if (event.getSource() == this.pc) {
            this.abortLinkCheck();
            this.getBroadcaster().fireEvent(new LinkCheckEvent(this, 3));
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CheckThread
    implements JDRunnable {
        private ArrayList<DownloadLink> links = null;

        public CheckThread(ArrayList<DownloadLink> links) {
            this.links = links;
        }

        public void run() {
            if (this.links == null || this.links.size() == 0) {
                return;
            }
            LinkCheck.this.checkHosterList(this.links);
        }

        @Override
        public void go() throws Exception {
            this.run();
        }
    }
}

