/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.swing.Timer;
import jd.config.SubConfiguration;
import jd.controlling.DownloadControllerEvent;
import jd.controlling.DownloadControllerListener;
import jd.controlling.JDController;
import jd.controlling.ListController;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordListController
implements ActionListener,
DownloadControllerListener,
ListController {
    private static transient SubConfiguration CONFIG = null;
    private transient ArrayList<String> LIST2;
    private static transient PasswordListController INSTANCE = null;
    private Timer asyncSaveIntervalTimer;
    private boolean saveinprogress;

    public static synchronized PasswordListController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PasswordListController();
        }
        return INSTANCE;
    }

    private PasswordListController() {
        CONFIG = SubConfiguration.getConfig("PASSWORDLIST");
        this.LIST2 = CONFIG.getGenericProperty("LIST2", new ArrayList());
        this.asyncSaveIntervalTimer = new Timer(2000, this);
        this.asyncSaveIntervalTimer.setInitialDelay(2000);
        this.asyncSaveIntervalTimer.setRepeats(false);
        this.asyncSaveIntervalTimer.stop();
        this.importOld1();
        this.importOld2();
        this.saveSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPassword(String pw) {
        if (pw == null || pw.trim().length() == 0) {
            return;
        }
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            if (this.LIST2.contains(pw)) {
                this.LIST2.remove(pw);
                this.LIST2.add(0, pw);
            } else {
                this.LIST2.add(pw);
            }
        }
        this.save();
    }

    public ArrayList<String> getPasswordList() {
        return this.LIST2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordList(ArrayList<String> list) {
        if (list == null) {
            list = new ArrayList();
        }
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            this.LIST2.clear();
            this.addPasswords(list);
            this.removeDups();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setList(String list) {
        if (list == null) {
            list = "";
        }
        String[] spl = Regex.getLines(list);
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            this.LIST2.clear();
            this.addPasswords(spl);
            this.removeDups();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getList() {
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            StringBuilder sb = new StringBuilder();
            for (String pw : this.getPasswordList()) {
                sb.append(String.valueOf(pw) + "\r\n");
            }
            return sb.toString().trim();
        }
    }

    private void importOld1() {
        try {
            LinkedList oldList = (LinkedList)SubConfiguration.getConfig("unrarPasswords").getProperty("PASSWORDLIST");
            if (oldList != null) {
                SubConfiguration.getConfig("unrarPasswords").setProperty("PASSWORDLIST", null);
                this.addPasswords(oldList);
                SubConfiguration.getConfig("unrarPasswords").save();
                this.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void importOld2() {
        try {
            String[] spl;
            String[] stringArray = spl = Regex.getLines(CONFIG.getStringProperty("LIST", ""));
            int n = spl.length;
            int n2 = 0;
            while (n2 < n) {
                String pw = stringArray[n2];
                this.addPasswords(Regex.getLines(pw));
                ++n2;
            }
            CONFIG.setProperty("LIST", "");
            CONFIG.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPasswords(Collection<String> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            for (String pw : list) {
                this.addPassword(pw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPasswords(String[] list) {
        if (list == null || list.length == 0) {
            return;
        }
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String pw = stringArray[n2];
                this.addPassword(pw);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDups() {
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            for (String pw : this.LIST2) {
                list.add(pw);
            }
            this.LIST2.clear();
            this.LIST2.addAll(list);
            this.save();
        }
    }

    public void save() {
        this.asyncSaveIntervalTimer.restart();
    }

    public void saveAsync() {
        if (this.saveinprogress) {
            return;
        }
        new Thread(){

            public void run() {
                this.setName("PasswordList: Saving");
                PasswordListController.this.saveinprogress = true;
                PasswordListController.this.saveSync();
                PasswordListController.this.saveinprogress = false;
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSync() {
        String id = JDController.requestDelayExit("passwordcontroller");
        ArrayList<String> arrayList = this.LIST2;
        synchronized (arrayList) {
            CONFIG.setProperty("LIST2", this.LIST2);
            CONFIG.save();
        }
        JDController.releaseDelayExit(id);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.asyncSaveIntervalTimer) {
            this.saveAsync();
        }
    }

    @Override
    public void onDownloadControllerEvent(DownloadControllerEvent event) {
        switch (event.getID()) {
            case 4: {
                this.addPasswords(((DownloadLink)event.getParameter()).getSourcePluginPasswordList());
                break;
            }
            case 2: {
                this.addPasswords(JDUtilities.passwordStringToArray(((FilePackage)event.getParameter()).getPassword()));
                break;
            }
        }
    }
}

