/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import jd.config.ConfigEntry;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.ProgressController;
import jd.controlling.reconnect.ReconnectMethod;
import jd.nutils.OSDetector;
import jd.parser.Regex;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class BatchReconnect
extends ReconnectMethod {
    private SubConfiguration configuration = SubConfiguration.getConfig("BATCHRECONNECT");
    private static final String PROPERTY_IP_WAIT_FOR_RETURN = "WAIT_FOR_RETURN2";
    private static final String PROPERTY_RECONNECT_EXECUTE_FOLDER = "RECONNECT_EXECUTE_FOLDER";
    private static final String PROPERTY_TERMINAL = "TERMINAL";
    private static final String PROPERTY_BATCHTEXT = "BATCH_TEXT";

    public void initConfig() {
        ConfigEntry cfg = new ConfigEntry(0, (Property)this.configuration, PROPERTY_TERMINAL, JDL.L((String)"interaction.batchreconnect.terminal", (String)"Interpreter"));
        this.config.addEntry(cfg);
        if (OSDetector.isWindows()) {
            cfg.setDefaultValue("cmd /c");
        } else {
            cfg.setDefaultValue("/bin/bash");
        }
        this.config.addEntry(new ConfigEntry(10, (Property)this.configuration, PROPERTY_BATCHTEXT, JDL.L((String)"interaction.batchreconnect.batch", (String)"Batch Script")));
        this.config.addEntry(new ConfigEntry(9, (Property)this.configuration, PROPERTY_RECONNECT_EXECUTE_FOLDER, JDL.L((String)"interaction.batchreconnect.executeIn", (String)"Ausf\u00fchren in (Ordner der Anwendung)")));
        this.config.addEntry(new ConfigEntry(8, this.configuration, PROPERTY_IP_WAIT_FOR_RETURN, JDL.L((String)"interaction.batchreconnect.waitForTermination", (String)"Warten x Sekunden bis Befehl beendet ist [sek]"), -1, 600).setDefaultValue(-1));
    }

    protected boolean runCommands(ProgressController progress) {
        int waitForReturn = this.configuration.getIntegerProperty(PROPERTY_IP_WAIT_FOR_RETURN, -1);
        String executeIn = this.configuration.getStringProperty(PROPERTY_RECONNECT_EXECUTE_FOLDER);
        String command = this.configuration.getStringProperty(PROPERTY_TERMINAL);
        String[] cmds = command.split("\\ ");
        command = cmds[0];
        int i = 0;
        while (i < cmds.length - 1) {
            cmds[i] = cmds[i + 1];
            ++i;
        }
        String batch = this.configuration.getStringProperty(PROPERTY_BATCHTEXT, "");
        String[] lines = Regex.getLines(batch);
        logger.info("Batch Verarbeitung aktiviert. Als Befehl muss der Interpreter eingetragen sein (windows: cmd.exe linux z.b. bash mac: teminal ?) Aktueller interpreter: " + command);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String element;
            cmds[cmds.length - 1] = element = stringArray[n2];
            logger.finer("Execute Batchline: " + JDUtilities.runCommand(command, cmds, executeIn, waitForReturn));
            ++n2;
        }
        return true;
    }

    public String toString() {
        return JDL.L((String)"interaction.batchreconnect.toString", (String)"Batch reconnect durchf\u00fchren");
    }
}

