/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.util.logging.Logger;
import jd.config.ConfigContainer;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.gui.UserIF;
import jd.http.IPCheck;
import jd.nutils.IPAddress;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public abstract class ReconnectMethod {
    protected static Logger logger = JDLogger.getLogger();
    public static final String PARAM_RECONNECT_TYPE = "RECONNECT_TYPE";
    public static final int LIVEHEADER = 0;
    public static final int EXTERN = 1;
    public static final int BATCH = 2;
    public static final int CLR = 3;
    public static final String PARAM_IPCHECKWAITTIME = "RECONNECT_IPCHECKWAITTIME";
    public static final String PARAM_RETRIES = "RECONNECT_RETRIES";
    public static final String PARAM_WAITFORIPCHANGE = "RECONNECT_WAITFORIPCHANGE";
    protected ConfigContainer config = null;
    private int retries = 0;

    protected ReconnectMethod() {
    }

    public final boolean doReconnect() {
        ++this.retries;
        ProgressController progress = new ProgressController(this.toString(), 10L);
        progress.setStatusText(String.valueOf(JDL.L((String)"reconnect.progress.1_retries", (String)"Reconnect #")) + this.retries);
        int waittime = JDUtilities.getConfiguration().getIntegerProperty(PARAM_IPCHECKWAITTIME, 0);
        int maxretries = JDUtilities.getConfiguration().getIntegerProperty(PARAM_RETRIES, 0);
        int waitForIp = JDUtilities.getConfiguration().getIntegerProperty(PARAM_WAITFORIPCHANGE, 10);
        logger.info("Starting " + this.toString() + " #" + this.retries);
        String preIp = IPCheck.getIPAddress(null);
        progress.increase(1L);
        progress.setStatusText(String.valueOf(JDL.L((String)"reconnect.progress.2_oldIP", (String)"Reconnect Old IP:")) + preIp);
        if (!this.runCommands(progress)) {
            logger.severe("An error occured while processing the reconnect ... Terminating");
            return false;
        }
        logger.finer("Initial Waittime: " + waittime + " seconds");
        try {
            Thread.sleep(waittime * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String afterIP = IPCheck.getIPAddress(null);
        progress.setStatusText(JDL.LF((String)"reconnect.progress.3_ipcheck", (String)"Reconnect New IP: %s / %s", (Object[])new Object[]{afterIP, preIp}));
        long endTime = System.currentTimeMillis() + (long)(waitForIp * 1000);
        logger.info("Wait " + waitForIp + " sec for new ip");
        while (System.currentTimeMillis() <= endTime && (afterIP.equals(preIp) || afterIP.equals("offline"))) {
            logger.finer("IP before: " + preIp + " after: " + afterIP);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            afterIP = IPCheck.getIPAddress(null);
            progress.setStatusText(JDL.LF((String)"reconnect.progress.3_ipcheck", (String)"Reconnect New IP: %s / %s", (Object[])new Object[]{afterIP, preIp}));
        }
        logger.finer("IP before: " + preIp + " after: " + afterIP);
        if (afterIP.equals("offline") && !afterIP.equals(preIp)) {
            logger.warning("JD could disconnect your router, but could not connect afterwards. Try to rise the option 'Wait until first IP Check'");
            endTime = System.currentTimeMillis() + 120000L;
            while (System.currentTimeMillis() <= endTime && (afterIP.equals(preIp) || afterIP.equals("offline"))) {
                logger.finer("IP before: " + preIp + " after: " + afterIP);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                afterIP = IPCheck.getIPAddress(null);
                progress.setStatusText(JDL.LF((String)"reconnect.progress.3_ipcheck", (String)"Reconnect New IP: %s / %s", (Object[])new Object[]{preIp, afterIP}));
            }
        }
        if (!afterIP.equals(preIp) && !afterIP.equals("offline")) {
            if (!IPAddress.validateIP(afterIP)) {
                logger.warning("IP " + afterIP + " was filtered by mask: " + SubConfiguration.getConfig("DOWNLOAD").getStringProperty("PARAM_GLOBAL_IP_MASK2", "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?).){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b"));
                UserIF.getInstance().displayMiniWarning(JDL.L((String)"reconnect.ipfiltered.warning.title", (String)"Wrong IP!"), JDL.LF((String)"reconnect.ipfiltered.warning.short", (String)"Die IP %s wurde als nicht erlaubt identifiziert", (Object[])new Object[]{afterIP}));
                afterIP = "offline";
            } else {
                progress.doFinalize();
                return true;
            }
        }
        if (maxretries == -1 || this.retries <= maxretries) {
            progress.doFinalize();
            return this.doReconnect();
        }
        progress.doFinalize();
        return false;
    }

    protected abstract boolean runCommands(ProgressController var1);

    public abstract void initConfig();

    public final ConfigContainer getConfig() {
        if (this.config == null) {
            this.config = new ConfigContainer();
            this.initConfig();
        }
        return this.config;
    }
}

