/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import jd.http.Cookie;
import jd.parser.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cookies {
    private LinkedList<Cookie> cookies = new LinkedList();

    public Cookies() {
    }

    public Cookies(Cookies cookies) {
        this.add(cookies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Cookies newcookies) {
        LinkedList<Cookie> linkedList = this.cookies;
        synchronized (linkedList) {
            for (Cookie cookie : newcookies.getCookies()) {
                this.add(cookie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Cookie cookie) {
        LinkedList<Cookie> linkedList = this.cookies;
        synchronized (linkedList) {
            for (Cookie cookie2 : this.cookies) {
                if (!cookie2.equals(cookie)) continue;
                cookie2.update(cookie);
                return;
            }
            this.cookies.add(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Cookie cookie) {
        LinkedList<Cookie> linkedList = this.cookies;
        synchronized (linkedList) {
            boolean b = this.cookies.remove(cookie);
            if (!b) {
                Cookie del = null;
                for (Cookie cookie2 : this.cookies) {
                    if (!cookie2.equals(cookie)) continue;
                    del = cookie2;
                    break;
                }
                if (del != null) {
                    this.cookies.remove(del);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<Cookie> linkedList = this.cookies;
        synchronized (linkedList) {
            this.cookies.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie get(String key) {
        if (key == null) {
            return null;
        }
        LinkedList<Cookie> linkedList = this.cookies;
        synchronized (linkedList) {
            for (Cookie cookie : this.cookies) {
                if (!cookie.getKey().equalsIgnoreCase(key)) continue;
                return cookie;
            }
            return null;
        }
    }

    public LinkedList<Cookie> getCookies() {
        return this.cookies;
    }

    public boolean isEmpty() {
        return this.cookies.isEmpty();
    }

    public static Cookies parseCookies(String cookieString, String host, String Date2) {
        Cookies cookies = new Cookies();
        String header = cookieString;
        String path = null;
        String expires = null;
        String domain = null;
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
        StringTokenizer st = new StringTokenizer(header, ";");
        while (true) {
            String key = null;
            String value = null;
            String cookieelement = null;
            if (!st.hasMoreTokens()) break;
            cookieelement = st.nextToken().trim();
            String[] st2 = new Regex(cookieelement, "(.*?)=(.+)").getRow(0);
            if (st2 == null || st2.length == 0) {
                key = null;
            } else if (st2.length == 1) {
                key = st2[0].trim();
            } else if (st2.length == 2) {
                key = st2[0].trim();
                value = st2[1].trim();
            }
            if (key == null) break;
            if (key.equalsIgnoreCase("path")) {
                path = value;
                continue;
            }
            if (key.equalsIgnoreCase("expires")) {
                expires = value;
                continue;
            }
            if (key.equalsIgnoreCase("domain")) {
                domain = value;
                continue;
            }
            tmp.put(key, value);
        }
        for (Map.Entry next : tmp.entrySet()) {
            Cookie cookie = new Cookie();
            if (next.getValue() == null) continue;
            cookies.add(cookie);
            cookie.setHost(host);
            cookie.setPath(path);
            cookie.setDomain(domain);
            cookie.setExpires(expires);
            cookie.setValue((String)next.getValue());
            cookie.setKey((String)next.getKey());
            cookie.setHostTime(Date2);
        }
        return cookies;
    }
}

