/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.PostFormDataRequest;
import jd.http.requests.PostRequest;
import jd.parser.Regex;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPConnection
extends HttpURLConnection
implements URLConnectionAdapter {
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    protected HashMap<String, List<String>> requestProperties = new HashMap();
    protected long[] ranges;
    protected boolean connectionnEstabilished = false;
    private Request request;
    private String customcharset = null;

    @Override
    public boolean isConnected() {
        return this.connectionnEstabilished;
    }

    public HTTPConnection(URL url, Proxy p, Handler handler) {
        super(url, p, handler);
        Map<String, List<String>> tmp = this.getRequestProperties();
        for (Map.Entry<String, List<String>> next : tmp.entrySet()) {
            this.requestProperties.put(next.getKey(), next.getValue());
        }
    }

    @Override
    public void connect() throws IOException {
        this.connectionnEstabilished = true;
        super.connect();
    }

    @Override
    public long getLongContentLength() {
        if (this.getHeaderField("content-length") == null) {
            return -1L;
        }
        return Long.parseLong(this.getHeaderField("content-length"));
    }

    @Override
    public int getContentLength() {
        if (this.getHeaderField("content-length") == null) {
            return -1;
        }
        return Integer.parseInt(this.getHeaderField("content-length"));
    }

    @Override
    public String getContentType() {
        String type = super.getContentType();
        if (type == null) {
            return "unknown";
        }
        return type;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.responseCode != 404) {
            return super.getInputStream();
        }
        return super.getErrorStream();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.requestProperties;
    }

    @Override
    public void setRequestProperty(String key, String value) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(value);
        this.requestProperties.put(key, l);
        super.setRequestProperty(key, value);
    }

    @Override
    public boolean isOK() {
        try {
            return this.getResponseCode() > -2 && this.getResponseCode() < 400;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public long[] getRange() {
        if (this.ranges != null) {
            return this.ranges;
        }
        String range = this.getHeaderField("Content-Range");
        if (range == null) {
            return null;
        }
        String[] ranges = new Regex(range, ".*?(\\d+).*?-.*?(\\d+).*?/.*?(\\d+)").getRow(0);
        if (ranges == null) {
            System.err.print("" + this);
            return null;
        }
        this.ranges = new long[]{Long.parseLong(ranges[0]), Long.parseLong(ranges[1]), Long.parseLong(ranges[2])};
        return this.ranges;
    }

    @Override
    public boolean isContentDisposition() {
        return this.getHeaderField("Content-Disposition") != null;
    }

    @Override
    public void disconnect() {
        if (this.isConnected()) {
            super.disconnect();
            this.connectionnEstabilished = false;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-->" + this.getURL() + "\r\n");
        sb.append("----------------Request------------------\r\n");
        sb.append(String.valueOf(this.getRequestMethod()) + " " + this.getURL().getPath() + (this.getURL().getQuery() != null ? "?" + this.getURL().getQuery() : "") + " HTTP/1.1\r\n");
        for (Map.Entry<String, List<String>> next : this.getRequestProperties().entrySet()) {
            String v2;
            StringBuilder value = new StringBuilder();
            for (String v2 : next.getValue()) {
                value.append(';');
                value.append(v2);
            }
            v2 = value.toString();
            if (v2.length() > 0) {
                v2 = v2.substring(1);
            }
            sb.append(next.getKey());
            sb.append(new char[]{':', ' '});
            sb.append(v2);
            sb.append(new char[]{'\r', '\n'});
        }
        sb.append(new char[]{'\r', '\n'});
        if (this.getRequest() != null) {
            if (this.getRequest() instanceof PostRequest) {
                sb.append(((PostRequest)this.getRequest()).getPostDataString());
                sb.append(new char[]{'\r', '\n'});
            } else if (this.getRequest() instanceof PostFormDataRequest) {
                sb.append(((PostFormDataRequest)this.getRequest()).getPostDataString());
                sb.append(new char[]{'\r', '\n'});
            }
        }
        sb.append("----------------Response------------------\r\n");
        for (Map.Entry<String, List<String>> next : this.getHeaderFields().entrySet()) {
            int i = next.getValue().size() - 1;
            while (i >= 0) {
                if (next.getKey() == null) {
                    sb.append(next.getValue().get(i));
                    sb.append(new char[]{'\r', '\n'});
                } else {
                    sb.append(next.getKey());
                    sb.append(new char[]{':', ' '});
                    sb.append(next.getValue().get(i));
                    sb.append(new char[]{'\r', '\n'});
                }
                --i;
            }
        }
        sb.append(new char[]{'\r', '\n'});
        return sb.toString();
    }

    @Override
    public void setRequest(Request request) {
        this.request = request;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public String getCharset() {
        int i;
        if (this.customcharset != null) {
            return this.customcharset;
        }
        return this.getContentType() != null && (i = this.getContentType().toLowerCase().indexOf("charset=")) > 0 ? this.getContentType().substring(i + 8).trim() : null;
    }

    @Override
    public void setCharset(String Charset2) {
        this.customcharset = Charset2;
    }
}

