/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jd.controlling.JDLogger;

public class DynByteBuffer {
    private ByteBuffer buffer;

    public DynByteBuffer(int l) {
        this.buffer = ByteBuffer.allocateDirect(l);
    }

    public void put(byte[] buffer, int read) {
        this.checkBufferSize(read);
        this.buffer.put(buffer);
    }

    public void clear() {
        this.buffer.clear();
    }

    public String toString() {
        return new String(this.getLast(this.buffer.position()));
    }

    public byte[] toByteArray() {
        return this.getLast(this.buffer.position());
    }

    public String toString(String codepage) {
        try {
            return new String(this.getLast(this.buffer.position()), codepage);
        }
        catch (UnsupportedEncodingException e) {
            JDLogger.exception(e);
            return new String(this.getLast(this.buffer.position()));
        }
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int limit() {
        return this.buffer.limit();
    }

    public int position() {
        return this.buffer.position();
    }

    private void checkBufferSize(int read) {
        if (this.buffer.remaining() < read) {
            ByteBuffer newbuffer = ByteBuffer.allocateDirect(this.buffer.capacity() * 2);
            this.buffer.flip();
            newbuffer.put(this.buffer);
            this.buffer = newbuffer;
        }
    }

    public byte get() {
        return this.buffer.get();
    }

    public Buffer flip() {
        return this.buffer.flip();
    }

    public ByteBuffer compact() {
        return this.buffer.compact();
    }

    public byte[] getLast(int num) {
        int posi = this.buffer.position();
        num = Math.min(posi, num);
        this.buffer.position(posi - num);
        byte[] b = new byte[num];
        this.buffer.get(b);
        this.buffer.position(posi);
        return b;
    }

    public byte[] getSub(int start, int end) {
        int posi = this.buffer.position();
        this.buffer.position(start);
        byte[] b = new byte[end - start];
        this.buffer.get(b);
        this.buffer.position(posi);
        return b;
    }
}

