/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import jd.nutils.DynByteBuffer;
import jd.nutils.OSDetector;
import jd.nutils.ProcessListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Executer
extends Thread {
    public static final String CODEPAGE = OSDetector.isWindows() ? "ISO-8859-1" : "UTF-8";
    private boolean debug = true;
    private String codepage = CODEPAGE;
    public static int LISTENER_ERRORSTREAM = 1;
    public static int LISTENER_STDSTREAM = 2;
    private String command;
    private ArrayList<String> parameter;
    private String runIn;
    private DynByteBuffer inputStreamBuffer;
    private DynByteBuffer errorStreamBuffer;
    private ArrayList<ProcessListener> listener = new ArrayList();
    private ArrayList<ProcessListener> elistener = new ArrayList();
    private int waitTimeout = 60;
    private int exitValue = -1;
    private Process process;
    private StreamObserver sbeObserver;
    private StreamObserver sboObserver;
    private OutputStream outputStream = null;
    private Exception exception = null;
    private boolean processgotinterrupted = false;

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getCodepage() {
        return this.codepage;
    }

    public void setCodepage(String codepage) {
        this.codepage = codepage;
    }

    public Executer(String command) {
        this.command = command;
        this.parameter = new ArrayList();
        this.inputStreamBuffer = new DynByteBuffer(4096);
        this.errorStreamBuffer = new DynByteBuffer(4096);
        this.setName("Executer: " + command);
    }

    public void addParameter(String par) {
        this.parameter.add(par);
    }

    public void addParameters(String[] par) {
        if (par == null) {
            return;
        }
        String[] stringArray = par;
        int n = par.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            this.parameter.add(p);
            ++n2;
        }
    }

    public String getCommand() {
        return this.command;
    }

    public String getErrorStream() {
        return this.errorStreamBuffer.toString(this.codepage);
    }

    public ArrayList<String> getParameter() {
        return this.parameter;
    }

    public String getRunin() {
        return this.runIn;
    }

    public String getOutputStream() {
        return this.inputStreamBuffer.toString(this.codepage);
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public void run() {
        if (this.command == null || this.command.trim().length() == 0) {
            System.out.println("Execute Parameter error: No Command");
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.command);
        params.addAll(this.parameter);
        if (this.isDebug()) {
            StringBuilder out = new StringBuilder();
            for (String p : params) {
                out.append(p);
                out.append(' ');
            }
            System.out.println("Execute: " + out + " in " + this.runIn);
        }
        ProcessBuilder pb = new ProcessBuilder(params.toArray(new String[0]));
        if (this.runIn != null && this.runIn.length() > 0) {
            if (new File(this.runIn).exists()) {
                pb.directory(new File(this.runIn));
            } else if (new File((String)params.get(0)).getParentFile().exists()) {
                pb.directory(new File((String)params.get(0)).getParentFile());
            } else {
                System.out.println("Working directory " + this.runIn + " does not exist!");
            }
        }
        try {
            this.processgotinterrupted = false;
            this.process = pb.start();
            if (this.waitTimeout == 0) {
                return;
            }
            this.outputStream = this.process.getOutputStream();
            this.sbeObserver = new StreamObserver(this.process.getErrorStream(), this.errorStreamBuffer);
            this.sbeObserver.setName(String.valueOf(this.getName()) + " ERRstreamobserver");
            this.sboObserver = new StreamObserver(this.process.getInputStream(), this.inputStreamBuffer);
            this.sbeObserver.setName(String.valueOf(this.getName()) + " STDstreamobserver");
            this.sbeObserver.start();
            this.sboObserver.start();
            if (this.waitTimeout > 0) {
                Thread timeoutThread = new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(Executer.this.waitTimeout * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            Executer.this.process.destroy();
                        }
                        catch (Exception e) {
                            Executer.this.processgotinterrupted = true;
                        }
                    }
                };
                timeoutThread.start();
            }
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e1) {
                this.process.destroy();
                this.processgotinterrupted = true;
            }
            this.exitValue = this.processgotinterrupted ? -1 : this.process.exitValue();
            if (this.sboObserver.isAlive()) {
                this.sboObserver.requestInterrupt();
            }
            if (this.sbeObserver.isAlive()) {
                this.sbeObserver.requestInterrupt();
            }
            while (this.sbeObserver != null && this.sbeObserver.isAlive() || this.sboObserver != null && this.sboObserver.isAlive()) {
                Thread.sleep(50L);
            }
        }
        catch (IOException e1) {
            this.exception = e1;
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.exception = e;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public void interrupt() {
        super.interrupt();
        if (this.sbeObserver != null) {
            this.sbeObserver.interrupt();
        }
        if (this.sboObserver != null) {
            this.sboObserver.interrupt();
        }
        this.process.destroy();
    }

    public DynByteBuffer getInputStreamBuffer() {
        return this.inputStreamBuffer;
    }

    public void writetoOutputStream(String data) {
        if (data == null || data.length() == 0) {
            data = "";
        }
        try {
            this.outputStream.write(data.getBytes());
            this.outputStream.write("\n".getBytes());
            if (this.isDebug()) {
                System.out.println("Out>" + data);
            }
            this.outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DynByteBuffer getErrorStreamBuffer() {
        return this.errorStreamBuffer;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setParameter(ArrayList<String> parameter) {
        this.parameter = parameter;
    }

    public void setRunin(String runin) {
        this.runIn = runin;
    }

    public void setWaitTimeout(int waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    public void waitTimeout() {
        while (this.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public boolean gotInterrupted() {
        return this.processgotinterrupted;
    }

    public void addProcessListener(ProcessListener listener, int flag) {
        this.removeProcessListener(listener, flag);
        if ((flag & LISTENER_STDSTREAM) > 0) {
            this.listener.add(listener);
        }
        if ((flag & LISTENER_ERRORSTREAM) > 0) {
            this.elistener.add(listener);
        }
    }

    private void fireEvent(String line, DynByteBuffer sb, int flag) {
        if ((flag & LISTENER_STDSTREAM) > 0) {
            for (ProcessListener listener : this.listener) {
                listener.onProcess(this, line, sb);
            }
        }
        if ((flag & LISTENER_ERRORSTREAM) > 0) {
            for (ProcessListener elistener : this.elistener) {
                elistener.onProcess(this, line, sb);
            }
        }
    }

    private void fireEvent(DynByteBuffer buffer, int read, int flag) {
        if ((flag & LISTENER_STDSTREAM) > 0) {
            for (ProcessListener listener : this.listener) {
                listener.onBufferChanged(this, buffer, read);
            }
        }
        if ((flag & LISTENER_ERRORSTREAM) > 0) {
            for (ProcessListener elistener : this.elistener) {
                elistener.onBufferChanged(this, buffer, read);
            }
        }
    }

    public void removeProcessListener(ProcessListener listener, int flag) {
        if ((flag & LISTENER_STDSTREAM) > 0) {
            this.listener.remove(listener);
        }
        if ((flag & LISTENER_ERRORSTREAM) > 0) {
            this.elistener.remove(listener);
        }
    }

    class StreamObserver
    extends Thread {
        private BufferedInputStream reader;
        private DynByteBuffer dynbuf;
        private boolean started;
        private boolean interruptRequestet = false;
        private boolean eof = false;

        public StreamObserver(InputStream stream, DynByteBuffer buffer) {
            this.reader = new BufferedInputStream(stream);
            this.dynbuf = buffer;
        }

        public void run() {
            this.started = true;
            try {
                Executer.this.fireEvent(this.dynbuf, 0, this == Executer.this.sbeObserver ? LISTENER_ERRORSTREAM : LISTENER_STDSTREAM);
                while (!this.eof) {
                    String line;
                    int num = this.readLine();
                    if (!this.interruptRequestet) {
                        this.eof = false;
                    }
                    if (num <= 0) {
                        Thread.sleep(50L);
                        continue;
                    }
                    try {
                        line = new String(this.dynbuf.getLast(num), Executer.this.codepage).trim();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                        line = new String(this.dynbuf.getLast(num)).trim();
                    }
                    if (line.length() <= 0) continue;
                    if (Executer.this.isDebug()) {
                        System.out.println(this + ": " + line);
                    }
                    Executer.this.fireEvent(line, this.dynbuf, this == Executer.this.sbeObserver ? LISTENER_ERRORSTREAM : LISTENER_STDSTREAM);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private int readLine() throws IOException, InterruptedException {
            int i = 0;
            byte[] buffer = new byte[1];
            while (true) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                int read = 0;
                read = this.reader.read(buffer);
                if (read < 0) {
                    this.eof = true;
                    return i;
                }
                i += read;
                this.dynbuf.put(buffer, read);
                if (buffer[0] == 8 || buffer[0] == 13 || buffer[0] == 10) {
                    return i;
                }
                Executer.this.fireEvent(this.dynbuf, read, this == Executer.this.sbeObserver ? LISTENER_ERRORSTREAM : LISTENER_STDSTREAM);
            }
        }

        public boolean isStarted() {
            return this.started;
        }

        public void requestInterrupt() {
            this.interruptRequestet = true;
        }
    }
}

