/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

public class OSDetector {
    private static byte OS_ID = (byte)-1;
    private static String OS_STRING;
    public static final byte OS_LINUX_OTHER = 6;
    public static final byte OS_MAC_OTHER = 5;
    public static final byte OS_WINDOWS_OTHER = 4;
    public static final byte OS_WINDOWS_NT = 3;
    public static final byte OS_WINDOWS_2000 = 2;
    public static final byte OS_WINDOWS_XP = 0;
    public static final byte OS_WINDOWS_2003 = 7;
    public static final byte OS_WINDOWS_VISTA = 1;
    public static final byte OS_WINDOWS_7 = 8;

    private static void getOS() {
        String OS = OSDetector.getOSString().toLowerCase();
        OS_ID = OS.indexOf("windows 7") > -1 ? (byte)8 : (OS.indexOf("windows xp") > -1 ? (byte)0 : (OS.indexOf("windows vista") > -1 ? (byte)1 : (OS.indexOf("windows 2000") > -1 ? (byte)2 : (OS.indexOf("windows 2003") > -1 ? (byte)7 : (OS.indexOf("nt") > -1 ? (byte)3 : (OS.indexOf("windows") > -1 ? (byte)4 : (OS.indexOf("mac") > -1 ? (byte)5 : (byte)6)))))));
    }

    public static byte getOSID() {
        if (OS_ID < 0) {
            OSDetector.getOS();
        }
        return OS_ID;
    }

    public static boolean isLinux() {
        byte id = OSDetector.getOSID();
        switch (id) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMac() {
        byte id = OSDetector.getOSID();
        switch (id) {
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWindows() {
        byte id = OSDetector.getOSID();
        switch (id) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGnome() {
        if (!OSDetector.isLinux()) {
            return false;
        }
        String gdmSession = System.getenv("GDMSESSION");
        if (gdmSession != null && gdmSession.toLowerCase().contains("gnome")) {
            return true;
        }
        String desktopSession = System.getenv("DESKTOP_SESSION");
        if (desktopSession != null && desktopSession.toLowerCase().contains("gnome")) {
            return true;
        }
        String gnomeDesktopSessionId = System.getenv("GNOME_DESKTOP_SESSION_ID");
        return gnomeDesktopSessionId != null && gnomeDesktopSessionId.trim().length() > 0;
    }

    public static boolean isKDE() {
        if (!OSDetector.isLinux()) {
            return false;
        }
        String gdmSession = System.getenv("GDMSESSION");
        if (gdmSession != null && gdmSession.toLowerCase().contains("kde")) {
            return true;
        }
        String desktopSession = System.getenv("DESKTOP_SESSION");
        if (desktopSession != null && desktopSession.toLowerCase().contains("kde")) {
            return true;
        }
        String windowManager = System.getenv("WINDOW_MANAGER");
        return windowManager != null && windowManager.trim().toLowerCase().endsWith("kde");
    }

    public static String getOSString() {
        if (OS_STRING == null) {
            OS_STRING = System.getProperty("os.name");
        }
        return OS_STRING;
    }

    public static void setOSString(String property) {
        OS_STRING = property;
    }
}

