/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.encoding;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import jd.controlling.JDLogger;
import jd.nutils.encoding.Base64;
import jd.nutils.encoding.HTMLEntities;

public class Encoding {
    public static byte[] base16Decode(String code) {
        while (code.length() % 2 > 0) {
            code = String.valueOf(code) + "0";
        }
        byte[] res = new byte[code.length() / 2];
        int i = 0;
        while (i < code.length()) {
            res[i / 2] = (byte)Integer.parseInt(code.substring(i, i + 2), 16);
            i += 2;
        }
        return res;
    }

    public static String htmlDecode(String str) {
        if (str == null) {
            return null;
        }
        try {
            str = URLDecoder.decode(str, "UTF-8");
        }
        catch (Exception e) {
            JDLogger.exception(e);
        }
        str = HTMLEntities.unhtmlentities(str);
        str = HTMLEntities.unhtmlAmpersand(str);
        str = HTMLEntities.unhtmlAngleBrackets(str);
        str = HTMLEntities.unhtmlDoubleQuotes(str);
        str = HTMLEntities.unhtmlQuotes(str);
        str = HTMLEntities.unhtmlSingleQuotes(str);
        return str;
    }

    public static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception e) {
            JDLogger.exception(e);
            return str;
        }
    }

    public static boolean isUrlCoded(String str) {
        if (str == null) {
            return false;
        }
        try {
            return URLDecoder.decode(str, "UTF-8").length() != str.length();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String formEncoding(String str) {
        if (str == null) {
            return null;
        }
        if (Encoding.isUrlCoded(str)) {
            return str.replaceAll(" ", "+");
        }
        return Encoding.urlEncode(str);
    }

    public static String urlEncode_light(String url) {
        if (url == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < url.length()) {
            char ch = url.charAt(i);
            if (ch == ' ') {
                sb.append("%20");
            } else if (ch >= '!' && ch <= '&') {
                sb.append(ch);
            } else if (ch >= '(' && ch <= ';') {
                sb.append(ch);
            } else if (ch == '=') {
                sb.append(ch);
            } else if (ch >= '?' && ch <= '_') {
                sb.append(ch);
            } else if (ch >= 'a' && ch <= '~') {
                sb.append(ch);
            } else {
                try {
                    sb.append(URLEncoder.encode(String.valueOf(ch), "UTF-8"));
                }
                catch (Exception e) {
                    JDLogger.exception(e);
                    return url;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String urlDecode(String urlcoded, boolean isUrl) {
        if (urlcoded == null) {
            return null;
        }
        if (isUrl) {
            urlcoded = urlcoded.replaceAll("%2F", "/");
            urlcoded = urlcoded.replaceAll("%3A", ":");
            urlcoded = urlcoded.replaceAll("\\+", "%20");
            urlcoded = urlcoded.replaceAll("%3F", "?");
            urlcoded = urlcoded.replaceAll("%3D", "=");
            urlcoded = urlcoded.replaceAll("%26", "&");
            urlcoded = urlcoded.replaceAll("%23", "#");
        } else {
            try {
                urlcoded = URLDecoder.decode(urlcoded, "UTF-8");
            }
            catch (Exception e) {
                JDLogger.exception(e);
            }
        }
        return urlcoded;
    }

    public static String UTF8Decode(String str) {
        return Encoding.UTF8Decode(str, null);
    }

    public static String UTF8Decode(String str, String sourceEncoding) {
        if (str == null) {
            return null;
        }
        try {
            if (sourceEncoding != null) {
                return new String(str.getBytes(sourceEncoding), "UTF-8");
            }
            return new String(str.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            JDLogger.exception(e);
            return str;
        }
    }

    public static String UTF8Encode(String str) {
        try {
            return new String(str.getBytes("UTF-8"));
        }
        catch (Exception e) {
            JDLogger.exception(e);
            return null;
        }
    }

    public static String Base64Decode(String base64) {
        if (base64 == null) {
            return null;
        }
        try {
            byte[] plain = Base64.decode(base64);
            String string = new String(plain);
            if ((double)Encoding.filterString(string).length() < (double)plain.length / 1.5) {
                return base64;
            }
            return new String(plain);
        }
        catch (Exception e) {
            return base64;
        }
    }

    public static String Base64Encode(String plain) {
        if (plain == null) {
            return null;
        }
        String base64 = new String(Base64.encodeToByte(plain.getBytes(), false));
        return base64;
    }

    public static String filterString(String str) {
        String allowed = "QWERTZUIOP\u00dcASDFGHJKL\u00d6\u00c4YXCVBNMqwertzuiopasdfghjklyxcvbnm\u00f6\u00e4\u00fc;:,._-&$%(){}#~+ 1234567890<>='\"/";
        return Encoding.filterString(str, allowed);
    }

    public static String filterString(String str, String filter) {
        if (str == null || filter == null) {
            return "";
        }
        byte[] org = str.getBytes();
        byte[] mask = filter.getBytes();
        byte[] ret = new byte[org.length];
        int count = 0;
        int i = 0;
        while (i < org.length) {
            byte letter = org[i];
            byte[] byArray = mask;
            int n = mask.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                if (letter == element) {
                    ret[count] = letter;
                    ++count;
                    break;
                }
                ++n2;
            }
            ++i;
        }
        return new String(ret).trim();
    }

    public static String deepHtmlDecode(String string) {
        String decoded;
        String tmp = Encoding.htmlDecode(string);
        int i = 50;
        while (!tmp.equals(decoded = Encoding.htmlDecode(tmp))) {
            tmp = decoded;
            if (i-- > 0) continue;
            System.err.println("Max Decodeingloop 50 reached!!!");
            return tmp;
        }
        return tmp;
    }

    public static String urlTotalEncode(String string) {
        byte[] org = string.getBytes();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < org.length) {
            sb.append('%');
            String code = Integer.toHexString(org[i]);
            sb.append(code.substring(code.length() - 2));
            ++i;
        }
        return "" + sb;
    }
}

