/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.io;

import java.awt.Component;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFileChooser;
import jd.controlling.JDLogger;
import jd.nutils.JDHash;
import jd.nutils.io.JDFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDIO {
    private static File currentDirectory;
    public static Vector<File> saveReadObject;

    static {
        saveReadObject = new Vector();
    }

    public static boolean writeLocalFile(File file, String content) {
        return JDIO.writeLocalFile(file, content, false);
    }

    public static boolean writeLocalFile(File file, String content, boolean append) {
        block5: {
            try {
                if (append || !file.isFile() || file.delete()) break block5;
                System.err.println("Konnte Datei nicht l\u00f6schen " + file);
                return false;
            }
            catch (Exception e) {
                JDLogger.exception(e);
                return false;
            }
        }
        if (file.getParent() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!append || !file.isFile()) {
            file.createNewFile();
        }
        BufferedWriter f = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "UTF8"));
        f.write(content);
        f.close();
        return true;
    }

    public static String validateFileandPathName(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("([\\\\|<|>|\\||\"|:|\\*|\\?|/|\\x00])+", "_");
    }

    public static boolean saveToFile(File file, byte[] b) {
        block4: {
            try {
                if (!file.isFile() || file.delete()) break block4;
                System.err.println("Konnte Datei nicht \u00fcberschreiben " + file);
                return false;
            }
            catch (Exception e) {
                JDLogger.exception(e);
                return false;
            }
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file, true));
        output.write(b, 0, b.length);
        output.close();
        return true;
    }

    public static void saveObject(Component frame, Object objectToSave, File fileOutput, String name, String extension, boolean asXML) {
        if (fileOutput != null) {
            fileOutput.getParentFile().mkdirs();
        }
        if (fileOutput == null) {
            JDFileFilter fileFilter = new JDFileFilter(extension, extension, true);
            JFileChooser fileChooserSave = new JFileChooser();
            fileChooserSave.setFileFilter(fileFilter);
            fileChooserSave.setSelectedFile(new File(String.valueOf(name != null ? name : "*") + (extension != null ? extension : ".*")));
            if (currentDirectory != null) {
                fileChooserSave.setCurrentDirectory(currentDirectory);
            }
            if (fileChooserSave.showSaveDialog(frame) == 0) {
                fileOutput = fileChooserSave.getSelectedFile();
                currentDirectory = fileChooserSave.getCurrentDirectory();
            }
        }
        if (fileOutput != null) {
            if (fileOutput.isDirectory()) {
                fileOutput = new File(fileOutput, String.valueOf(name) + extension);
            }
            JDIO.waitOnObject(fileOutput);
            saveReadObject.add(fileOutput);
            if (fileOutput.exists()) {
                fileOutput.delete();
            }
            try {
                FileOutputStream fos = new FileOutputStream(fileOutput);
                BufferedOutputStream buff = new BufferedOutputStream(fos);
                if (asXML) {
                    XMLEncoder xmlEncoder = new XMLEncoder(buff);
                    xmlEncoder.writeObject(objectToSave);
                    xmlEncoder.close();
                } else {
                    ObjectOutputStream oos = new ObjectOutputStream(buff);
                    oos.writeObject(objectToSave);
                    oos.close();
                }
                buff.close();
                fos.close();
            }
            catch (FileNotFoundException e) {
                JDLogger.exception(e);
            }
            catch (IOException e) {
                JDLogger.exception(e);
            }
            String hashPost = JDHash.getMD5(fileOutput);
            if (hashPost == null) {
                System.err.println("Schreibfehler: " + fileOutput + " Datei wurde nicht erstellt");
            }
            saveReadObject.remove(fileOutput);
        } else {
            System.err.println("Schreibfehler: Fileoutput: null");
        }
    }

    public static void waitOnObject(File file) {
        int c = 0;
        while (saveReadObject.contains(file)) {
            if (c++ > 1000) {
                return;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                JDLogger.exception(e);
            }
        }
    }

    public static Object loadObject(Component frame, File fileInput, boolean asXML) {
        Object objectLoaded = null;
        if (fileInput == null) {
            JFileChooser fileChooserLoad = new JFileChooser();
            if (currentDirectory != null) {
                fileChooserLoad.setCurrentDirectory(currentDirectory);
            }
            if (fileChooserLoad.showOpenDialog(frame) == 0) {
                fileInput = fileChooserLoad.getSelectedFile();
                currentDirectory = fileChooserLoad.getCurrentDirectory();
            }
        }
        if (fileInput != null) {
            JDIO.waitOnObject(fileInput);
            saveReadObject.add(fileInput);
            try {
                FileInputStream fis = new FileInputStream(fileInput);
                BufferedInputStream buff = new BufferedInputStream(fis);
                if (asXML) {
                    XMLDecoder xmlDecoder = new XMLDecoder(new BufferedInputStream(buff));
                    objectLoaded = xmlDecoder.readObject();
                    xmlDecoder.close();
                } else {
                    ObjectInputStream ois = new ObjectInputStream(buff);
                    objectLoaded = ois.readObject();
                    ois.close();
                }
                fis.close();
                buff.close();
                saveReadObject.remove(fileInput);
                return objectLoaded;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                saveReadObject.remove(fileInput);
            }
        }
        return null;
    }

    public static String getLocalFile(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return "";
        }
        try {
            String line;
            BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            StringBuffer ret = new StringBuffer();
            String sep = System.getProperty("line.separator");
            while ((line = f.readLine()) != null) {
                ret.append(String.valueOf(line) + sep);
            }
            f.close();
            return ret.toString();
        }
        catch (IOException e) {
            JDLogger.exception(e);
            return "";
        }
    }

    public static String getFileExtension(File ret) {
        if (ret == null) {
            return null;
        }
        return JDIO.getFileExtension(ret.getAbsolutePath());
    }

    public static String getFileExtension(String str) {
        if (str == null) {
            return null;
        }
        int i3 = str.lastIndexOf(".");
        if (i3 > 0) {
            return str.substring(i3 + 1);
        }
        return null;
    }

    public static boolean copyFile(File in, File out) {
        FileChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            if (!out.exists()) {
                out.getParentFile().mkdirs();
                out.createNewFile();
            }
            inChannel = new FileInputStream(in).getChannel();
            outChannel = new FileOutputStream(out).getChannel();
            inChannel.transferTo(0L, inChannel.size(), (WritableByteChannel)((Object)outChannel));
            return true;
        }
        catch (FileNotFoundException e1) {
            JDLogger.exception(e1);
            if (inChannel != null) {
                try {
                    inChannel.close();
                    if (outChannel != null) {
                        outChannel.close();
                    }
                }
                catch (IOException e) {
                    JDLogger.exception(e);
                    return false;
                }
            }
            return false;
        }
        catch (IOException e) {
            JDLogger.exception(e);
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (IOException e2) {
                JDLogger.exception(e2);
                return false;
            }
            return true;
        }
    }

    public static boolean removeDirectoryOrFile(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            String[] stringArray = children = dir.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                boolean success = JDIO.removeDirectoryOrFile(new File(dir, element));
                if (!success) {
                    return false;
                }
                ++n2;
            }
        }
        return dir.delete();
    }

    public static ArrayList<File> listFiles(File dir) {
        if (!dir.isDirectory()) {
            return null;
        }
        ArrayList<File> ret = new ArrayList<File>();
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                ret.addAll(JDIO.listFiles(f));
            } else {
                ret.add(f);
            }
            ++n2;
        }
        return ret;
    }
}

