/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.jobber;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import jd.controlling.JDLogger;
import jd.nutils.jobber.JDRunnable;

public class Jobber {
    private int paralellWorkerNum;
    private LinkedList<JDRunnable> jobList;
    private Vector<Worker> workerList = new Vector();
    private ArrayList<WorkerListener> listener;
    private boolean killWorkerAfterQueueFinished = true;
    private boolean running = false;
    private Integer jobsAdded = new Integer(0);
    boolean debug = false;
    private Jobber INSTANCE = null;
    private Integer jobsFinished = new Integer(0);
    private Integer jobsStarted = new Integer(0);

    public int getJobsAdded() {
        return this.jobsAdded;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJobsFinished() {
        Integer n = this.jobsFinished;
        synchronized (n) {
            return this.jobsFinished;
        }
    }

    public int getJobsStarted() {
        return this.jobsStarted;
    }

    public Jobber(int i) {
        this.INSTANCE = this;
        this.paralellWorkerNum = i;
        this.jobList = new LinkedList();
        this.listener = new ArrayList();
    }

    public boolean isAlive() {
        return this.running;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.createWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWorker() {
        Vector<Worker> vector = this.workerList;
        synchronized (vector) {
            this.workerList = new Vector();
            int i = 0;
            while (i < this.paralellWorkerNum) {
                this.workerList.add(new Worker(i, this.INSTANCE));
                ++i;
            }
        }
        if (this.debug) {
            System.out.println("created " + this.paralellWorkerNum + " worker");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        if (this.workerList == null) {
            return;
        }
        Vector<Worker> vector = this.workerList;
        synchronized (vector) {
            Vector<Worker> tmp = new Vector<Worker>(this.workerList);
            for (Worker w : tmp) {
                if (w == null) continue;
                w.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void workerdone() {
        int count = 0;
        Vector<Worker> vector = this.workerList;
        synchronized (vector) {
            Vector<Worker> tmp = new Vector<Worker>(this.workerList);
            for (Worker w : tmp) {
                if (!w.isAlive()) continue;
                ++count;
            }
            if (count <= 1) {
                this.running = false;
                if (this.debug) {
                    System.out.println(this + " All worker finished, this Jobber has done his job!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JDRunnable getNextJDRunnable() {
        if (!this.isAlive() || this.jobList == null) {
            return null;
        }
        LinkedList<JDRunnable> linkedList = this.jobList;
        synchronized (linkedList) {
            block9: {
                if (this.jobList.size() != 0) break block9;
                ArrayList<WorkerListener> arrayList = this.listener;
                synchronized (arrayList) {
                    for (WorkerListener wl : this.listener) {
                        wl.onJobListFinished(this);
                    }
                }
                return null;
            }
            return this.jobList.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkerListener(WorkerListener wl) {
        ArrayList<WorkerListener> arrayList = this.listener;
        synchronized (arrayList) {
            this.listener.add(wl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkerListener(WorkerListener wl) {
        ArrayList<WorkerListener> arrayList = this.listener;
        synchronized (arrayList) {
            this.listener.remove(wl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJobFinished(JDRunnable job) {
        ArrayList<WorkerListener> arrayList = this.listener;
        synchronized (arrayList) {
            for (WorkerListener wl : this.listener) {
                wl.onJobFinished(this, job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJobException(JDRunnable job, Exception e) {
        ArrayList<WorkerListener> arrayList = this.listener;
        synchronized (arrayList) {
            for (WorkerListener wl : this.listener) {
                wl.onJobException(this, job, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJobStarted(JDRunnable job) {
        ArrayList<WorkerListener> arrayList = this.listener;
        synchronized (arrayList) {
            for (WorkerListener wl : this.listener) {
                wl.onJobStarted(this, job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(JDRunnable runnable) {
        if (this.jobList == null) {
            System.out.println("Dhoo...No joblist available!?");
            return -1;
        }
        LinkedList<JDRunnable> linkedList = this.jobList;
        synchronized (linkedList) {
            this.jobList.add(runnable);
            Serializable serializable = this.jobsAdded;
            synchronized (serializable) {
                this.jobsAdded = this.jobsAdded + 1;
            }
            if (this.debug) {
                System.out.println(this + " RINGRING!!!!");
            }
            if (this.workerList != null) {
                serializable = this.workerList;
                synchronized (serializable) {
                    Vector<Worker> tmp = new Vector<Worker>(this.workerList);
                    for (Worker w : tmp) {
                        if (w == null) continue;
                        Worker worker = w;
                        synchronized (worker) {
                            if (w.waitFlag) {
                                if (this.debug) {
                                    System.out.println("Dhoo...Hey " + w + "!! Time to wake up and do some work.");
                                }
                                w.waitFlag = false;
                                w.notify();
                                break;
                            }
                        }
                    }
                }
            }
            return this.jobList.size();
        }
    }

    public void setKillWorkerAfterQueueFinished(boolean killWorkerAfterQueueFinished) {
        this.killWorkerAfterQueueFinished = killWorkerAfterQueueFinished;
    }

    public boolean isKillWorkerAfterQueueFinished() {
        return this.killWorkerAfterQueueFinished;
    }

    public class Worker
    extends Thread {
        private int id;
        private boolean waitFlag;
        private Jobber INSTANCE;

        public int getWorkerID() {
            return this.id;
        }

        public Worker(int i, Jobber instance) {
            super("JDWorkerThread" + i);
            this.waitFlag = false;
            this.INSTANCE = instance;
            this.id = i;
            this.start();
        }

        public String toString() {
            return "Worker no." + this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object;
                JDRunnable ra;
                if ((ra = Jobber.this.getNextJDRunnable()) == null) {
                    if (Jobber.this.killWorkerAfterQueueFinished) {
                        this.INSTANCE.workerdone();
                        return;
                    }
                    if (Jobber.this.debug) {
                        System.out.println(this + ": Work is done..I'll sleep now.");
                    }
                    this.waitFlag = true;
                    object = this;
                    synchronized (object) {
                        while (this.waitFlag) {
                            try {
                                this.wait();
                            }
                            catch (Exception e) {
                                return;
                            }
                            if (!Jobber.this.debug) continue;
                            System.out.println(this + " good morning...get up!");
                        }
                    }
                    if (!Jobber.this.debug) continue;
                    System.out.println(this + ": I'm up");
                    continue;
                }
                object = Jobber.this.jobsStarted;
                synchronized (object) {
                    Jobber jobber = Jobber.this;
                    jobber.jobsStarted = jobber.jobsStarted + 1;
                }
                Jobber.this.fireJobStarted(ra);
                try {
                    ra.go();
                }
                catch (Exception e) {
                    JDLogger.exception(e);
                    Jobber.this.fireJobException(ra, e);
                }
                object = Jobber.this.jobsFinished;
                synchronized (object) {
                    Jobber jobber = Jobber.this;
                    jobber.jobsFinished = jobber.jobsFinished + 1;
                }
                Jobber.this.fireJobFinished(ra);
            }
        }
    }

    public abstract class WorkerListener {
        public abstract void onJobFinished(Jobber var1, JDRunnable var2);

        public abstract void onJobException(Jobber var1, JDRunnable var2, Exception var3);

        public abstract void onJobListFinished(Jobber var1);

        public abstract void onJobStarted(Jobber var1, JDRunnable var2);
    }
}

