/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.nativeintegration;

import com.apple.eio.FileManager;
import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.DnDWebBrowser;
import jd.nutils.Executer;
import jd.nutils.OSDetector;

public abstract class LocalBrowser
implements Serializable {
    private static final long serialVersionUID = 7153058016440180347L;
    private static LocalBrowser[] BROWSERLIST = null;
    private String name;

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private LocalBrowser(String name) {
        this.name = name;
    }

    public static synchronized LocalBrowser[] getBrowserList() {
        if (BROWSERLIST != null) {
            return BROWSERLIST;
        }
        ArrayList<LocalBrowser> ret = new ArrayList<LocalBrowser>();
        try {
            BrowserLauncher launcher = new BrowserLauncher();
            for (Object o : launcher.getBrowserList()) {
                ret.add(new LocalBrowser(o.toString()){
                    private static final long serialVersionUID = 7078868188658406674L;

                    public void openURL(URL url) throws Exception {
                        if (url == null) {
                            return;
                        }
                        BrowserLauncher launcher = new BrowserLauncher();
                        launcher.openURLinBrowser(this.getName(), url.toString());
                    }
                });
            }
        }
        catch (BrowserLaunchingInitializingException e) {
            e.printStackTrace();
        }
        catch (UnsupportedOperatingSystemException e) {
            e.printStackTrace();
        }
        if (OSDetector.isMac()) {
            ret.add(new LocalBrowser("MAC Default"){
                private static final long serialVersionUID = 914161109428877932L;

                public void openURL(URL url) throws IOException {
                    if (url == null) {
                        return;
                    }
                    FileManager.openURL((String)url.toString());
                }
            });
            if (new File("/Applications/Firefox.app").exists()) {
                ret.add(new LocalBrowser("Firefox"){
                    private static final long serialVersionUID = 2089733398098794579L;

                    public void openURL(URL url) throws Exception {
                        if (url == null) {
                            return;
                        }
                        Executer exec = new Executer("open");
                        exec.addParameters(new String[]{"/Applications/Firefox.app", "-new-tab", url.toString()});
                        exec.setWaitTimeout(10);
                        exec.start();
                        exec.waitTimeout();
                        if (exec.getException() != null) {
                            throw exec.getException();
                        }
                    }
                });
            } else {
                ret.add(new LocalBrowser("Firefox"){
                    private static final long serialVersionUID = -558662621604100570L;

                    public void openURL(URL url) throws Exception {
                        if (url == null) {
                            return;
                        }
                        Executer exec = new Executer("open");
                        exec.addParameters(new String[]{"/Applications/Safari.app", "-new-tab", url.toString()});
                        exec.setWaitTimeout(10);
                        exec.start();
                        exec.waitTimeout();
                        if (exec.getException() != null) {
                            throw exec.getException();
                        }
                    }
                });
            }
        }
        if (OSDetector.isLinux() && ret.size() == 0) {
            Executer exec = new Executer("firefox");
            exec.addParameter("-v");
            exec.setWaitTimeout(10);
            exec.start();
            exec.waitTimeout();
            if (exec.getException() == null) {
                ret.add(new LocalBrowser("Firefox"){
                    private static final long serialVersionUID = 6186304252605346654L;

                    public void openURL(URL url) throws Exception {
                        if (url == null) {
                            return;
                        }
                        Executer exec = new Executer("firefox");
                        exec.addParameters(new String[]{"-new-tab", url.toString()});
                        exec.setWaitTimeout(10);
                        exec.start();
                        exec.waitTimeout();
                        if (exec.getException() != null) {
                            throw exec.getException();
                        }
                    }
                });
            }
        }
        if (OSDetector.isWindows()) {
            ret.add(new LocalBrowser("Win Default"){
                private static final long serialVersionUID = 6862234646985946728L;

                public void openURL(URL url) throws Exception {
                    Executer exec = new Executer("cmd");
                    exec.addParameters(new String[]{"/c", "start " + url});
                    exec.setWaitTimeout(10);
                    exec.start();
                    exec.waitTimeout();
                    if (exec.getException() != null) {
                        throw exec.getException();
                    }
                }
            });
        }
        if (ret.size() == 0) {
            ret.add(new LocalBrowser("Java Browser"){
                private static final long serialVersionUID = 1L;

                public void openURL(final URL url) throws Exception {
                    new GuiRunnable<Object>(){

                        public Object runSave() {
                            DnDWebBrowser javaBrowser = new DnDWebBrowser(null);
                            javaBrowser.goTo(url);
                            javaBrowser.setDefaultCloseOperation(2);
                            javaBrowser.setSize(800, 600);
                            javaBrowser.setVisible(true);
                            return null;
                        }
                    }.start();
                }
            });
        }
        BROWSERLIST = ret.toArray(new LocalBrowser[0]);
        return BROWSERLIST;
    }

    public void openURL(String url) throws Exception {
        if (url == null) {
            return;
        }
        this.openURL(new URL(url));
    }

    public abstract void openURL(URL var1) throws Exception;

    public static void openURL(String browser, URL url) throws Exception {
        if (url == null) {
            return;
        }
        LocalBrowser[] browsers = LocalBrowser.getBrowserList();
        if (browsers == null || browsers.length == 0) {
            return;
        }
        if (browser != null) {
            LocalBrowser[] localBrowserArray = browsers;
            int n = browsers.length;
            int n2 = 0;
            while (n2 < n) {
                LocalBrowser b = localBrowserArray[n2];
                if (browser.equalsIgnoreCase(b.toString())) {
                    b.openURL(url);
                    return;
                }
                ++n2;
            }
        }
        browsers[0].openURL(url);
    }

    public static void openDefaultURL(URL url) throws Exception {
        LocalBrowser[] browsers = LocalBrowser.getBrowserList();
        if (browsers == null || browsers.length == 0) {
            return;
        }
        browsers[0].openURL(url);
    }

    public static void openinFirefox(String url) {
        String path = null;
        if (OSDetector.isWindows()) {
            if (new File("C:\\Program Files\\Mozilla Firefox\\firefox.exe").exists()) {
                path = "C:\\Program Files\\Mozilla Firefox\\firefox.exe";
            } else if (new File("C:\\Programme\\Mozilla Firefox\\firefox.exe").exists()) {
                path = "C:\\Programme\\Mozilla Firefox\\firefox.exe";
            }
            if (path != null) {
                Executer exec = new Executer(path);
                exec.addParameters(new String[]{url});
                exec.start();
            }
        } else if (OSDetector.isMac()) {
            if (new File("/Applications/Firefox.app").exists()) {
                path = "/Applications/Firefox.app";
                Executer exec = new Executer("open");
                exec.addParameters(new String[]{path, url});
                exec.start();
            }
        } else if (OSDetector.isLinux()) {
            Executer exec = new Executer("firefox");
            exec.addParameters(new String[]{url});
            exec.start();
        }
    }

    /* synthetic */ LocalBrowser(String string, LocalBrowser localBrowser) {
        this(string);
    }
}

