/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import jd.controlling.JDLogger;
import jd.event.JDBroadcaster;
import jd.event.MessageEvent;
import jd.event.MessageListener;
import jd.nutils.io.JDIO;
import jd.nutils.svn.ExportEditor;
import jd.nutils.svn.ExportReporterBaton;
import jd.nutils.svn.InfoEventHandler;
import jd.nutils.svn.ResolveHandler;
import jd.nutils.svn.StatusEventHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subversion
implements ISVNEventHandler {
    private SVNRepository repository;
    private SVNURL svnurl;
    private String user;
    private String pass;
    private ISVNAuthenticationManager authManager;
    private SVNClientManager clientManager;
    private SVNUpdateClient updateClient;
    private SVNCommitClient commitClient;
    private SVNWCClient wcClient;
    private JDBroadcaster<MessageListener, MessageEvent> broadcaster;

    public Subversion(String url) throws SVNException {
        this.setupType(url);
        this.checkRoot();
        this.initBroadcaster();
    }

    private void initBroadcaster() {
        this.broadcaster = new JDBroadcaster<MessageListener, MessageEvent>(){

            @Override
            protected void fireEvent(MessageListener listener, MessageEvent event) {
                listener.onMessage(event);
            }
        };
    }

    public JDBroadcaster<MessageListener, MessageEvent> getBroadcaster() {
        return this.broadcaster;
    }

    public Subversion(String url, String user, String pass) throws SVNException {
        this.setupType(url);
        this.user = user;
        this.pass = pass;
        this.authManager = SVNWCUtil.createDefaultAuthenticationManager((String)this.user, (String)this.pass);
        this.repository.setAuthenticationManager(this.authManager);
        this.checkRoot();
        this.initBroadcaster();
    }

    private void checkRoot() throws SVNException {
        SVNNodeKind nodeKind = this.repository.checkPath("", -1L);
        if (nodeKind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"No entry at URL ''{0}''", (Object)this.svnurl);
            throw new SVNException(err);
        }
        if (nodeKind == SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Entry at URL ''{0}'' is a file while directory was expected", (Object)this.svnurl);
            throw new SVNException(err);
        }
    }

    private void setupType(String url) throws SVNException {
        this.svnurl = SVNURL.parseURIDecoded((String)url);
        if (url.startsWith("http")) {
            DAVRepositoryFactory.setup();
            this.repository = DAVRepositoryFactory.create((SVNURL)this.svnurl);
        } else if (url.startsWith("svn")) {
            SVNRepositoryFactoryImpl.setup();
            this.repository = SVNRepositoryFactoryImpl.create((SVNURL)this.svnurl);
        } else {
            FSRepositoryFactory.setup();
            this.repository = FSRepositoryFactory.create((SVNURL)this.svnurl);
        }
    }

    public long export(File file) throws SVNException {
        JDIO.removeDirectoryOrFile(file);
        file.mkdirs();
        ExportEditor exportEditor = new ExportEditor(file);
        long rev = this.latestRevision();
        ExportReporterBaton reporterBaton = new ExportReporterBaton(rev);
        this.repository.update(rev, null, true, (ISVNReporterBaton)reporterBaton, (ISVNEditor)exportEditor);
        return rev;
    }

    public long latestRevision() throws SVNException {
        return this.repository.getLatestRevision();
    }

    public ArrayList<SVNLogEntry> getChangeset(int start, int end) throws SVNException {
        Collection log = this.repository.log(new String[]{""}, null, (long)start, (long)end, true, true);
        ArrayList<SVNLogEntry> list = new ArrayList<SVNLogEntry>();
        list.addAll(log);
        return list;
    }

    public long update(File file, SVNRevision revision) throws SVNException {
        file.mkdirs();
        SVNUpdateClient updateClient = this.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        if (revision == null) {
            revision = SVNRevision.HEAD;
        }
        try {
            System.out.println("SVN Update at " + file);
            long l = updateClient.doUpdate(file, revision, SVNDepth.INFINITY, false, true);
            return l;
        }
        catch (Exception e) {
            JDLogger.getLogger().finer(e.getMessage());
            try {
                System.out.println("SVN Checkout at " + file);
                long l = updateClient.doCheckout(this.svnurl, file, SVNRevision.HEAD, revision, SVNDepth.INFINITY, true);
                System.out.println("SVN Update finished");
                return l;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                System.out.println("SVN Update finished");
                return -1L;
            }
        }
        finally {
            System.out.println("SVN Update finished");
        }
    }

    public SVNRepository getRepository() {
        return this.repository;
    }

    private SVNUpdateClient getUpdateClient() {
        if (this.updateClient == null) {
            this.updateClient = this.getClientManager().getUpdateClient();
            this.updateClient.setEventHandler((ISVNEventHandler)this);
        }
        return this.updateClient;
    }

    private synchronized SVNClientManager getClientManager() {
        if (this.clientManager == null) {
            this.clientManager = SVNClientManager.newInstance((ISVNOptions)SVNWCUtil.createDefaultOptions((boolean)true), (ISVNAuthenticationManager)this.authManager);
        }
        return this.clientManager;
    }

    public SVNCommitInfo commit(File dstPath, String message) throws SVNException {
        this.getWCClient().doAdd(dstPath, true, false, true, SVNDepth.INFINITY, false, false);
        SVNCommitPacket packet = this.getCommitClient().doCollectCommitItems(new File[]{dstPath}, false, false, SVNDepth.INFINITY, null);
        this.getCommitClient().doCommit(packet, true, false, message, null);
        return null;
    }

    public SVNWCClient getWCClient() {
        if (this.wcClient == null) {
            this.wcClient = this.getClientManager().getWCClient();
            this.wcClient.setEventHandler((ISVNEventHandler)this);
        }
        return this.wcClient;
    }

    public void showInfo(File wcPath, SVNRevision revision, boolean isRecursive) throws SVNException {
        if (revision == null) {
            revision = SVNRevision.HEAD;
        }
        this.getWCClient().doInfo(wcPath, revision, isRecursive, (ISVNInfoHandler)new InfoEventHandler());
    }

    public static void main(String[] args) throws SVNException {
        Subversion svn = new Subversion("svn://svn.jdownloader.org/jdownloader/trunk/ressourcen/jd/languages", "", "");
        File file = new File("C:\\Users\\Coalado\\.jd_home\\tmp\\lfe\\lng\\en.loc");
        svn.update(file, SVNRevision.HEAD);
        svn.resolveConflicts(file.getParentFile(), new ResolveHandler(){

            public String resolveConflict(SVNInfo info, File file, String contents, int startMine, int endMine, int startTheirs, int endTheirs) {
                String mine = contents.substring(startMine, endMine).trim();
                return mine;
            }
        });
        svn.commit(file, "resolved");
    }

    public void resolveConflicts(File file, final ResolveHandler handler) throws SVNException {
        this.getWCClient().doInfo(file, SVNRevision.UNDEFINED, SVNRevision.WORKING, SVNDepth.getInfinityOrEmptyDepth((boolean)true), null, new ISVNInfoHandler(){

            public void handleInfo(SVNInfo info) {
                File file = info.getConflictWrkFile();
                if (file != null) {
                    try {
                        Subversion.this.resolveConflictedFile(info, info.getFile(), handler);
                        Subversion.this.getWCClient().doResolve(info.getFile(), SVNDepth.INFINITY, null);
                        System.out.println(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public ArrayList<SVNInfo> getInfo(File file) {
        final ArrayList<SVNInfo> ret = new ArrayList<SVNInfo>();
        try {
            this.getWCClient().doInfo(file, SVNRevision.UNDEFINED, SVNRevision.WORKING, SVNDepth.getInfinityOrEmptyDepth((boolean)true), null, new ISVNInfoHandler(){

                public void handleInfo(SVNInfo info) {
                    ret.add(info);
                }
            });
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void resolveConflictedFile(SVNInfo info, File file, ResolveHandler handler) throws Exception {
        int mineStart;
        String mine = "<<<<<<< .mine";
        String delim = "=======";
        String theirs = ">>>>>>> .r";
        String txt = JDIO.getLocalFile(file);
        while ((mineStart = txt.indexOf("<<<<<<< .mine")) >= 0) {
            String solve;
            int delimStart = txt.indexOf("=======", mineStart += "<<<<<<< .mine".length());
            int theirsEnd = txt.indexOf(">>>>>>> .r", delimStart + "=======".length());
            int end = theirsEnd + ">>>>>>> .r".length();
            while (txt.charAt(end) != '\r' && txt.charAt(end) != '\n') {
                ++end;
            }
            String pre = txt.substring(0, mineStart - "<<<<<<< .mine".length());
            String post = txt.substring(end);
            while (pre.endsWith("\r") || pre.endsWith("\n")) {
                pre = pre.substring(0, pre.length() - 1);
            }
            while (post.startsWith("\r") || post.startsWith("\n")) {
                post = post.substring(1);
            }
            pre = String.valueOf(pre) + "\r\n";
            post = "\r\n" + post;
            if (pre.trim().length() == 0) {
                pre = pre.trim();
            }
            if (post.trim().length() == 0) {
                post = post.trim();
            }
            if ((solve = handler.resolveConflict(info, file, txt, mineStart, delimStart, delimStart + "=======".length(), theirsEnd)) == null) {
                throw new Exception("Could not resolve");
            }
            txt = String.valueOf(pre) + solve.trim() + post;
        }
        JDIO.writeLocalFile(file, txt);
    }

    public void showStatus(File wcPath, boolean isRecursive, boolean isRemote, boolean isReportAll, boolean isIncludeIgnored, boolean isCollectParentExternals) throws SVNException {
        this.getClientManager().getStatusClient().doStatus(wcPath, isRecursive, isRemote, isReportAll, isIncludeIgnored, isCollectParentExternals, (ISVNStatusHandler)new StatusEventHandler(isRemote));
    }

    private SVNCommitClient getCommitClient() {
        if (this.commitClient == null) {
            this.commitClient = this.getClientManager().getCommitClient();
            this.commitClient.setEventHandler((ISVNEventHandler)this);
            this.commitClient.setCommitParameters(new ISVNCommitParameters(){

                public boolean onDirectoryDeletion(File directory) {
                    return false;
                }

                public boolean onFileDeletion(File file) {
                    return false;
                }

                public ISVNCommitParameters.Action onMissingDirectory(File file) {
                    return ISVNCommitParameters.DELETE;
                }

                public ISVNCommitParameters.Action onMissingFile(File file) {
                    return ISVNCommitParameters.DELETE;
                }
            });
        }
        return this.commitClient;
    }

    public void cleanUp(File dstPath, boolean deleteWCProperties) throws SVNException {
        this.getWCClient().doCleanup(dstPath, deleteWCProperties);
    }

    public void revert(File dstPath) throws SVNException {
        try {
            this.getWCClient().doRevert(new File[]{dstPath}, SVNDepth.INFINITY, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cleanUp(dstPath, false);
        }
    }

    public void lock(File dstPath, String message) throws SVNException {
        this.getWCClient().doLock(new File[]{dstPath}, false, message);
    }

    public void unlock(File dstPath) throws SVNException {
        this.getWCClient().doUnlock(new File[]{dstPath}, false);
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        String nullString = " ";
        SVNEventAction action = event.getAction();
        String pathChangeType = nullString;
        if (action == SVNEventAction.ADD) {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "A     " + event.getFile()));
            return;
        }
        if (action == SVNEventAction.COPY) {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "A  +  " + event.getFile()));
            return;
        }
        if (action == SVNEventAction.DELETE) {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "D     " + event.getFile()));
            return;
        }
        if (action == SVNEventAction.LOCKED) {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "L     " + event.getFile()));
            return;
        }
        if (action == SVNEventAction.LOCK_FAILED) {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "failed to lock    " + event.getFile()));
            return;
        }
        if (action == SVNEventAction.UPDATE_ADD) {
            pathChangeType = "A";
        } else if (action == SVNEventAction.UPDATE_DELETE) {
            pathChangeType = "D";
        } else if (action == SVNEventAction.UPDATE_UPDATE) {
            SVNStatusType contentsStatus = event.getContentsStatus();
            if (contentsStatus == SVNStatusType.CHANGED) {
                pathChangeType = "U";
            } else if (contentsStatus == SVNStatusType.CONFLICTED) {
                pathChangeType = "C";
            } else if (contentsStatus == SVNStatusType.MERGED) {
                pathChangeType = "G";
            }
        } else {
            if (action == SVNEventAction.UPDATE_EXTERNAL) {
                this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "Fetching external item into '" + event.getFile().getAbsolutePath() + "'"));
                this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "External at revision " + event.getRevision()));
                return;
            }
            if (action == SVNEventAction.UPDATE_COMPLETED) {
                this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "At revision " + event.getRevision()));
                return;
            }
        }
        SVNStatusType propertiesStatus = event.getPropertiesStatus();
        String propertiesChangeType = nullString;
        if (propertiesStatus == SVNStatusType.CHANGED) {
            propertiesChangeType = "U";
        } else if (propertiesStatus == SVNStatusType.CONFLICTED) {
            propertiesChangeType = "C";
        } else if (propertiesStatus == SVNStatusType.MERGED) {
            propertiesChangeType = "G";
        }
        String lockLabel = nullString;
        SVNStatusType lockType = event.getLockStatus();
        if (lockType == SVNStatusType.LOCK_UNLOCKED) {
            lockLabel = "B";
        }
        if (pathChangeType != nullString || propertiesChangeType != nullString || lockLabel != nullString) {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), String.valueOf(pathChangeType) + propertiesChangeType + lockLabel + "       " + event.getFile()));
        }
        if (action == SVNEventAction.COMMIT_MODIFIED) {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "Sending   " + event.getFile()));
        } else if (action == SVNEventAction.COMMIT_DELETED) {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "Deleting   " + event.getFile()));
        } else if (action == SVNEventAction.COMMIT_REPLACED) {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "Replacing   " + event.getFile()));
        } else if (action == SVNEventAction.COMMIT_DELTA_SENT) {
            this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "Transmitting file data...."));
        } else if (action == SVNEventAction.COMMIT_ADDED) {
            String mimeType = event.getMimeType();
            if (SVNProperty.isBinaryMimeType((String)mimeType)) {
                this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "Adding  (bin)  " + event.getFile()));
            } else {
                this.broadcaster.fireEvent(new MessageEvent((Object)this, action.getID(), "Adding         " + event.getFile()));
            }
        }
    }

    public void checkCancelled() throws SVNCancelException {
    }
}

