/*
 * Decompiled with CFR 0.152.
 */
package jd.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Regex {
    private Matcher matcher;

    public static String[] getLines(String arg) {
        if (arg == null) {
            return new String[0];
        }
        String[] temp = arg.split("[\r\n]{1,2}");
        String[] output = new String[temp.length];
        int i = 0;
        while (i < temp.length) {
            output[i] = temp[i].trim();
            ++i;
        }
        return output;
    }

    public static long getSize(String string) {
        String[][] matches = new Regex(string, Pattern.compile("([\\d]+)[\\.|\\,|\\:]([\\d]+)", 2)).getMatches();
        if (matches == null || matches.length == 0) {
            matches = new Regex(string, Pattern.compile("([\\d]+)", 2)).getMatches();
        }
        if (matches == null || matches.length == 0) {
            return -1L;
        }
        double res = 0.0;
        if (matches[0].length == 1) {
            res = Double.parseDouble(matches[0][0]);
        }
        if (matches[0].length == 2) {
            res = Double.parseDouble(String.valueOf(matches[0][0]) + "." + matches[0][1]);
        }
        if (Regex.matches((Object)string, Pattern.compile("(gb|gbyte|gig)", 2))) {
            res *= 1.073741824E9;
        } else if (Regex.matches((Object)string, Pattern.compile("(mb|mbyte|megabyte)", 2))) {
            res *= 1048576.0;
        } else if (Regex.matches((Object)string, Pattern.compile("(kb|kbyte|kilobyte)", 2))) {
            res *= 1024.0;
        }
        return Math.round(res);
    }

    public static boolean matches(Object str, Pattern pat) {
        return new Regex(str, pat).matches();
    }

    public static boolean matches(Object page, String string) {
        return new Regex(page, string).matches();
    }

    public Regex(Matcher matcher) {
        if (matcher == null) {
            return;
        }
        this.matcher = matcher;
    }

    public Regex(Object data, Pattern pattern) {
        this(data.toString(), pattern);
    }

    public Regex(Object data, String pattern) {
        this(data.toString(), pattern);
    }

    public Regex(Object data, String pattern, int flags) {
        this(data.toString(), pattern, flags);
    }

    public Regex(String data, Pattern pattern) {
        if (data == null || pattern == null) {
            return;
        }
        this.matcher = pattern.matcher(data);
    }

    public Regex(String data, String pattern) {
        if (data == null || pattern == null) {
            return;
        }
        this.matcher = Pattern.compile(pattern, 34).matcher(data);
    }

    public Regex(String data, String pattern, int flags) {
        if (data == null || pattern == null) {
            return;
        }
        this.matcher = Pattern.compile(pattern, flags).matcher(data);
    }

    public int count() {
        if (this.matcher == null) {
            return 0;
        }
        this.matcher.reset();
        int c = 0;
        Matcher matchertmp = this.matcher;
        while (matchertmp.find()) {
            ++c;
        }
        return c;
    }

    public String getMatch(int group) {
        if (this.matcher == null) {
            return null;
        }
        Matcher matchertmp = this.matcher;
        this.matcher.reset();
        if (matchertmp.find()) {
            return matchertmp.group(group + 1);
        }
        return null;
    }

    public Matcher getMatcher() {
        this.matcher.reset();
        return this.matcher;
    }

    public String[][] getMatches() {
        if (this.matcher == null) {
            return null;
        }
        Matcher matchertmp = this.matcher;
        this.matcher.reset();
        ArrayList<String[]> ar = new ArrayList<String[]>();
        while (matchertmp.find()) {
            String[] group;
            int c = matchertmp.groupCount();
            int d = 1;
            if (c == 0) {
                group = new String[c + 1];
                d = 0;
            } else {
                group = new String[c];
            }
            int i = d;
            while (i <= c) {
                group[i - d] = matchertmp.group(i);
                ++i;
            }
            ar.add(group);
        }
        if (ar.size() == 0) {
            return new String[0][];
        }
        return (String[][])ar.toArray((T[])new String[0][]);
    }

    public String[] getColumn(int x) {
        if (this.matcher == null) {
            return null;
        }
        ++x;
        Matcher matchertmp = this.matcher;
        this.matcher.reset();
        ArrayList<String> ar = new ArrayList<String>();
        while (matchertmp.find()) {
            ar.add(matchertmp.group(x));
        }
        return ar.toArray(new String[ar.size()]);
    }

    public boolean matches() {
        this.matcher.reset();
        return this.matcher.find();
    }

    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        String[][] match = this.getMatches();
        int i = 0;
        while (i < match.length) {
            int j = 0;
            while (j < match[i].length) {
                ret.append("match[");
                ret.append(i);
                ret.append("][");
                ret.append(j);
                ret.append("] = ");
                ret.append(match[i][j]);
                ret.append(System.getProperty("line.separator"));
                ++j;
            }
            ++i;
        }
        this.matcher.reset();
        return ret.toString();
    }

    public static long getMilliSeconds(String wait) {
        String[][] matches = new Regex(wait, "([\\d]+) ?[\\.|\\,|\\:] ?([\\d]+)").getMatches();
        if (matches == null || matches.length == 0) {
            matches = new Regex(wait, Pattern.compile("([\\d]+)")).getMatches();
        }
        if (matches == null || matches.length == 0) {
            return -1L;
        }
        double res = 0.0;
        if (matches[0].length == 1) {
            res = Double.parseDouble(matches[0][0]);
        }
        if (matches[0].length == 2) {
            res = Double.parseDouble(String.valueOf(matches[0][0]) + "." + matches[0][1]);
        }
        res = Regex.matches((Object)wait, Pattern.compile("(h|st)", 2)) ? (res *= 3600000.0) : (Regex.matches((Object)wait, Pattern.compile("(m)", 2)) ? (res *= 60000.0) : (res *= 1000.0));
        return Math.round(res);
    }

    public static long getMilliSeconds(String expire, String timeformat, Locale l) {
        SimpleDateFormat dateFormat = l != null ? new SimpleDateFormat(timeformat, l) : new SimpleDateFormat(timeformat);
        if (expire == null) {
            return -1L;
        }
        try {
            Date date = dateFormat.parse(expire);
            return date.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public String getMatch(int entry, int group) {
        if (this.matcher == null) {
            return null;
        }
        Matcher matchertmp = this.matcher;
        this.matcher.reset();
        ++entry;
        int groupCount = 0;
        while (matchertmp.find()) {
            if (groupCount == group) {
                return matchertmp.group(entry);
            }
            ++groupCount;
        }
        return null;
    }

    public String[] getRow(int y) {
        if (this.matcher == null) {
            return null;
        }
        Matcher matchertmp = this.matcher;
        this.matcher.reset();
        int groupCount = 0;
        while (matchertmp.find()) {
            if (groupCount == y) {
                int c = matchertmp.groupCount();
                String[] group = new String[c];
                int i = 1;
                while (i <= c) {
                    group[i - 1] = matchertmp.group(i);
                    ++i;
                }
                return group;
            }
            ++groupCount;
        }
        return null;
    }

    public static int getMilliSeconds2(String wait) {
        String minutes = new Regex(wait, "(\\d*?)[ ]*m").getMatch(0);
        String hours = new Regex(wait, "(\\d*?)[ ]*(h|st)").getMatch(0);
        String seconds = new Regex(wait, "(\\d*?)[ ]*se").getMatch(0);
        if (minutes == null) {
            minutes = "0";
        }
        if (hours == null) {
            hours = "0";
        }
        if (seconds == null) {
            seconds = "0";
        }
        return Integer.parseInt(hours) * 60 * 60 * 1000 + Integer.parseInt(minutes) * 60 * 1000 + Integer.parseInt(seconds) * 1000;
    }

    public static String escape(String pattern) {
        char[] specials = new char[]{'(', '[', '{', '\\', '^', '-', '$', '|', ']', '}', ')', '?', '*', '+', '.'};
        StringBuilder sb = new StringBuilder();
        sb.setLength(pattern.length());
        int i = 0;
        while (i < pattern.length()) {
            char act = pattern.charAt(i);
            char[] cArray = specials;
            int n = specials.length;
            int n2 = 0;
            while (n2 < n) {
                char s = cArray[n2];
                if (act == s) {
                    sb.append('\\');
                    break;
                }
                ++n2;
            }
            sb.append(act);
            ++i;
        }
        return sb.toString().trim();
    }
}

