/*
 * Decompiled with CFR 0.152.
 */
package jd.update;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import jd.nutils.Executer;
import jd.nutils.OSDetector;

public class Restarter {
    private static boolean WAIT_FOR_JDOWNLOADER_TERM = false;
    private static boolean RESTART = false;
    private static Logger logger;

    public static String getStackTrace(Throwable thrown) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        thrown.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static void main(String[] args) {
        try {
            FileHandler handler = new FileHandler("restarter.log", false);
            logger = Logger.getLogger("org.jdownloader");
            logger.addHandler(handler);
        }
        catch (IOException handler) {
            // empty catch block
        }
        try {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (arg.equalsIgnoreCase("-restart")) {
                    RESTART = true;
                }
                ++n2;
            }
            while (new File("JDownloader.jar").exists() && !new File("JDownloader.jar").canWrite()) {
                logger.severe("Wait for jdownloader terminating");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            new File("update/tools/tinyupdate.jar").deleteOnExit();
            new File("update/tools/tinyupdate.jar").delete();
            Restarter.move(new File("update"));
            int i = 0;
            while (!Restarter.removeFiles() && i <= 3) {
                Thread.sleep(2000L);
                ++i;
            }
            if (RESTART) {
                if (OSDetector.isMac()) {
                    Executer exec = new Executer("open");
                    exec.addParameters(new String[]{"-n", "jDownloader.app"});
                    exec.setRunin(new File(".").getAbsolutePath());
                    exec.setWaitTimeout(0);
                    exec.start();
                } else {
                    Executer exec = new Executer("java");
                    exec.addParameters(new String[]{"-jar", "-Xmx512m", "JDownloader.jar", "-rtfu2"});
                    exec.setRunin(new File(".").getAbsolutePath());
                    exec.setWaitTimeout(0);
                    exec.start();
                }
                Thread.sleep(1000L);
                System.exit(0);
            }
        }
        catch (Throwable e) {
            logger.severe(Restarter.getStackTrace(e));
        }
    }

    public static String getLocalFile(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return "";
        }
        try {
            String line;
            BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            StringBuffer ret = new StringBuffer();
            String sep = System.getProperty("line.separator");
            while ((line = f.readLine()) != null) {
                ret.append(String.valueOf(line) + sep);
            }
            f.close();
            return ret.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String[] getLines(String arg) {
        if (arg == null) {
            return new String[0];
        }
        String[] temp = arg.split("[\r\n]{1,2}");
        String[] output = new String[temp.length];
        int i = 0;
        while (i < temp.length) {
            output[i] = temp[i].trim();
            ++i;
        }
        return output;
    }

    public static boolean removeDirectoryOrFile(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            String[] stringArray = children = dir.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                boolean success = Restarter.removeDirectoryOrFile(new File(dir, element));
                if (!success) {
                    return false;
                }
                ++n2;
            }
        }
        return dir.delete();
    }

    public static boolean removeFiles() {
        File outdated = new File("outdated.dat");
        String[] remove = Restarter.getLines(Restarter.getLocalFile(outdated));
        String homedir = outdated.getParent();
        boolean ret = true;
        if (remove != null) {
            String[] stringArray = remove;
            int n = remove.length;
            int n2 = 0;
            while (n2 < n) {
                File delete;
                String file = stringArray[n2];
                if (file.length() != 0 && !file.matches(".*?" + File.separator + "?\\.+" + File.separator + ".*?") && (delete = new File(homedir, file)).exists()) {
                    if (Restarter.removeDirectoryOrFile(delete)) {
                        logger.info("Removed " + file);
                    } else {
                        ret = false;
                        logger.info(" FAILED to Removed " + file);
                    }
                }
                ++n2;
            }
        }
        return ret;
    }

    public static void move(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    Restarter.move(f);
                } else {
                    String n3 = new File("update").getAbsolutePath();
                    File newFile = new File(f.getAbsolutePath().replace(n3, "").substring(1)).getAbsoluteFile();
                    int waittime = 15000;
                    while (newFile.exists() && !newFile.delete() && !WAIT_FOR_JDOWNLOADER_TERM) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if ((waittime -= 1000) < 0) {
                            logger.severe("COULD NOT DELETE");
                            break block12;
                        }
                        logger.severe("WAIT FOR DELETE");
                    }
                    if (!newFile.exists()) {
                        WAIT_FOR_JDOWNLOADER_TERM = true;
                        logger.severe("DELETE OLD OK");
                    } else {
                        logger.severe("DELETE OLD FAILED");
                    }
                    newFile.getParentFile().mkdirs();
                    logger.severe(newFile + " exists: " + newFile.exists());
                    logger.severe(f + " new exists: " + f.exists());
                    logger.severe("RENAME :" + f.renameTo(newFile));
                    if (f.getParentFile().list().length == 0) {
                        f.getParentFile().delete();
                    }
                }
            }
            ++n2;
        }
        if (dir.list() != null && dir.list().length == 0) {
            dir.delete();
        }
    }
}

