/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.io.UnsupportedEncodingException;
import jd.controlling.JDLogger;

public class JDHexUtils {
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    public static final String REGEX_FIND_ALL_HEX = "[[a-fA-F0-9]{2}]*?";
    public static final String REGEX_MATCH_ALL_HEX = "([[a-fA-F0-9]{2}]*?)";
    public static final String REGEX_HTTP_NEWLINE = String.valueOf(JDHexUtils.getHexString("\r")) + "{1}" + JDHexUtils.getHexString("\n") + "{1}";

    public static String toString(String hexString) {
        if (hexString == null) {
            return null;
        }
        return new String(JDHexUtils.getByteArray(hexString));
    }

    public static byte[] getByteArray(String hexString) {
        if (hexString == null) {
            return null;
        }
        int length = hexString.length();
        byte[] buffer = new byte[(length + 1) / 2];
        boolean evenByte = true;
        byte nextByte = 0;
        int bufferOffset = 0;
        if (length % 2 == 1) {
            evenByte = false;
        }
        int i = 0;
        while (i < length) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new NumberFormatException("Invalid hex digit '" + c + "'.");
            }
            if (evenByte) {
                nextByte = (byte)(nibble << 4);
            } else {
                nextByte = (byte)(nextByte + (byte)nibble);
                buffer[bufferOffset++] = nextByte;
            }
            evenByte = !evenByte;
            ++i;
        }
        return buffer;
    }

    public static String getHexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        byte[] byArray = raw;
        int n = raw.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
            ++n2;
        }
        try {
            return new String(hex, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            JDLogger.exception(e);
            return null;
        }
    }

    public static String getHexString(String string) {
        block4: {
            if (string != null) break block4;
            return null;
        }
        try {
            byte[] raw = string.getBytes("ASCII");
            byte[] hex = new byte[2 * raw.length];
            int index = 0;
            byte[] byArray = raw;
            int n = raw.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                int v = b & 0xFF;
                hex[index++] = HEX_CHAR_TABLE[v >>> 4];
                hex[index++] = HEX_CHAR_TABLE[v & 0xF];
                ++n2;
            }
            return new String(hex, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            JDLogger.exception(e);
            return null;
        }
    }
}

