/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jd.config.CFGConfig;
import jd.controlling.JDLogger;
import jd.gui.swing.jdgui.userio.UserIOGui;
import jd.http.Browser;
import jd.nutils.JDHash;
import jd.nutils.SimpleFTP;
import jd.nutils.io.JDIO;
import jd.nutils.svn.Subversion;
import jd.parser.Regex;
import jd.update.FileUpdate;
import jd.update.WebUpdater;
import org.tmatesoft.svn.core.SVNException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Updater {
    public static StringBuilder SERVERLIST = new StringBuilder();
    private String branch;
    private File pluginsDir;
    private WebUpdater webupdater;
    private ArrayList<FileUpdate> remoteFileList;
    private File workingDir = new File(".").getCanonicalFile();
    private JFrame frame;
    private static String UPDATE_SUB_DIR;
    private static String UPDATE_SUB_SRC;
    private File updateDir;
    private File svn = new File(this.workingDir, UPDATE_SUB_SRC);
    private static String UPDATE_SERVER;
    private File jars;
    private String latestBranch;

    static {
        SERVERLIST.append("-1:http://update1.jdownloader.org/%BRANCH%/\r\n");
        UPDATE_SUB_DIR = "exclude_jd_update";
        UPDATE_SUB_SRC = "exclude_jd_src";
        UPDATE_SERVER = "http://update1.jdownloader.org/";
    }

    public static void main(String[] args) throws Exception {
        String branch = null;
        branch = "Synthy2";
        Browser.setGlobalConnectTimeout(500000);
        Browser.setGlobalReadTimeout(500000);
        Updater upd = new Updater();
        if (branch != null) {
            WebUpdater.getConfig("WEBUPDATE").setProperty("BRANCH", branch);
        }
        WebUpdater.getConfig("WEBUPDATE").save();
        System.out.println("STATUS: Webupdate");
        upd.webupdate();
        upd.removeFileOverhead();
        System.out.println("STATUS: move plugins");
        upd.movePlugins(Updater.getCFG("plugins_dir"));
        upd.moveJars(Updater.getCFG("dist_dir"));
        upd.cleanUp();
        if (branch == null) {
            branch = JOptionPane.showInputDialog(upd.frame, (Object)"branchname");
        }
        upd.createBranch(branch);
        ArrayList<File> list = upd.getFileList();
        upd.upload(list);
        upd.merge();
        upd.checkHashes();
        upd.uploadHashList();
        System.exit(0);
    }

    private void cleanUp() {
        String[] rest;
        String[] outdated;
        String[] stringArray = outdated = Regex.getLines(JDIO.getLocalFile(new File(this.updateDir, "outdated.dat")));
        int n = outdated.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (new File(this.workingDir, path).exists()) {
                JDIO.removeDirectoryOrFile(new File(this.workingDir, path));
                System.err.println(" CLEAN UP: " + new File(this.workingDir, path).getAbsolutePath());
            }
            if (new File(this.updateDir, path).exists()) {
                JDIO.removeDirectoryOrFile(new File(this.updateDir, path));
                System.err.println(" CLEAN UP: " + new File(this.updateDir, path).getAbsolutePath());
            }
            ++n2;
        }
        String[] stringArray2 = rest = new String[]{"info.txt", "jd/img/default/flags", "plugins/JDPremium.jar", "tools/Windows/recycle.exe", "jd/img/screenshots", "jd/img/synthetica"};
        int n3 = rest.length;
        n = 0;
        while (n < n3) {
            String path = stringArray2[n];
            if (new File(this.workingDir, path).exists()) {
                JDIO.removeDirectoryOrFile(new File(this.workingDir, path));
                System.err.println(" CLEAN UP: " + new File(this.workingDir, path).getAbsolutePath());
            }
            if (new File(this.updateDir, path).exists()) {
                JDIO.removeDirectoryOrFile(new File(this.updateDir, path));
                System.err.println(" CLEAN UP: " + new File(this.updateDir, path).getAbsolutePath());
            }
            ++n;
        }
    }

    private String createBranch(String id) throws IOException {
        this.branch = id;
        String ret = new Browser().getPage(String.valueOf(UPDATE_SERVER) + "createBranch.php?pass=" + Updater.getCFG("updateHashPW") + "&parent=" + this.latestBranch + "&branch=" + id);
        System.out.println(ret);
        return id;
    }

    public Updater() throws IOException, SVNException {
        this.svn.mkdirs();
        this.updateDir = new File(this.workingDir, UPDATE_SUB_DIR);
        this.updateDir.mkdirs();
        this.initGUI();
    }

    public static String getCFG(String key) {
        CFGConfig cfg = CFGConfig.getConfig("LOCALCONFIG");
        String ret = cfg.getStringProperty(key);
        if (ret == null) {
            JFrame frame = new JFrame();
            frame.setAlwaysOnTop(true);
            frame.setVisible(true);
            ret = JOptionPane.showInputDialog(frame, (Object)("get Config: " + key));
            cfg.setProperty(key, ret);
            cfg.save();
        }
        return ret;
    }

    private void moveJars(String string) throws IOException {
        File f;
        this.jars = new File(string);
        this.copyDirectory(new File(this.jars, "libs"), new File(this.updateDir, "libs"));
        String hash = JDHash.getMD5(new File(this.workingDir, "JDownloader.jar"));
        this.copyFile(new File(this.jars, "JDownloader.jar"), new File(this.updateDir, "JDownloader.jar"));
        if (!JDHash.getMD5(new File(this.updateDir, "JDownloader.jar")).equals(hash)) {
            try {
                Subversion svn = new Subversion("svn://svn.jdownloader.org/jdownloader");
                long head = svn.latestRevision();
                new File(this.updateDir, "config").mkdirs();
                JDIO.saveToFile(new File(this.updateDir, "config/version.cfg"), String.valueOf(head).getBytes());
            }
            catch (SVNException e) {
                e.printStackTrace();
            }
        }
        this.copyFile(new File(this.jars, "tinyupdate.jar"), new File(this.updateDir, "tools/tinyupdate.jar"));
        this.copyFile(new File(this.jars.getParentFile(), "ressourcen\\outdated.dat"), new File(this.updateDir, "outdated.dat"));
        File[] fileArray = new File(this.jars.getParentFile(), "ressourcen\\pluginressourcen").listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = fileArray[n2];
            this.copyDirectory(f, this.updateDir);
            ++n2;
        }
        fileArray = new File(this.jars, "pluginressourcen").listFiles();
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            f = fileArray[n2];
            this.copyDirectory(f, this.updateDir);
            ++n2;
        }
        this.copyDirectory(new File(this.jars.getParentFile(), "ressourcen\\licenses"), new File(this.updateDir, "licenses"));
        this.copyDirectory(new File(this.jars.getParentFile(), "ressourcen\\jd"), new File(this.updateDir, "jd"));
        this.copyDirectory(new File(this.jars.getParentFile(), "ressourcen\\tools"), new File(this.updateDir, "tools"));
        this.copyDirectory(new File(this.jars.getParentFile(), "ressourcen\\libs"), new File(this.updateDir, "libs"));
    }

    private void clone2(String branch, String path) throws IOException {
        LinkedHashMap<String, String> map = this.createHashList(this.workingDir);
        Browser br = new Browser();
        br.forceDebug(true);
        map.put("pass", Updater.getCFG("updateHashPW"));
        br.postPage(String.valueOf(path) + "?pass=" + Updater.getCFG("updateHashPW") + "&branch=" + branch, map);
        System.out.println("" + br);
        if (!(br.containsHTML("<b>fail</b>") || br.containsHTML("<b>Warning</b>") || br.containsHTML("<b>Error</b>"))) {
            System.out.println("CLONE OK " + path);
            return;
        }
        JOptionPane.showConfirmDialog(this.frame, "MD5 ERROR!!!! See log" + path);
    }

    private void checkHashes() throws IOException {
        while (true) {
            LinkedHashMap<String, String> map = this.createHashList(this.workingDir);
            Browser br = new Browser();
            br.forceDebug(true);
            map.put("pass", Updater.getCFG("updateHashPW"));
            br.postPage("http://update1.jdownloader.org/checkHashes.php?pass=" + Updater.getCFG("updateHashPW") + "&branch=" + this.branch, map);
            System.out.println("" + br);
            if (br.containsHTML("success") && !br.containsHTML("<b>Warning</b>") && !br.containsHTML("<b>Error</b>")) break;
            JOptionPane.showConfirmDialog(this.frame, "MD5 ERROR!!!! See log");
        }
    }

    private void uploadHashList() throws Exception {
        while (true) {
            LinkedHashMap<String, String> map = this.createHashList(this.workingDir);
            Browser br = new Browser();
            br.forceDebug(true);
            System.out.println(br.postPage("http://update1.jdownloader.org/unlock.php?pass=" + Updater.getCFG("updateHashPW") + "&branch=" + this.branch, "server=" + SERVERLIST.toString().replaceAll("\\%BRANCH\\%", this.branch)));
            map.put("pass", Updater.getCFG("updateHashPW"));
            map.put("addonlist", "");
            br.postPage("http://update1.jdownloader.org/updateHashList.php?pass=" + Updater.getCFG("updateHashPW") + "&branch=" + this.branch, map);
            System.out.println("" + br);
            if (br.containsHTML("success") && !br.containsHTML("<b>Warning</b>") && !br.containsHTML("<b>Error</b>")) break;
            JOptionPane.showConfirmDialog(this.frame, "MD5 ERROR!!!! See log");
        }
    }

    private LinkedHashMap<String, String> createHashList(File dir) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ArrayList<File> list = this.getLocalFileList(dir, false);
        for (File f : list) {
            String path = f.getAbsolutePath().replace(dir.getAbsolutePath(), "");
            if ((path = path.replace("\\", "/")).trim().length() == 0 || f.isDirectory()) continue;
            String hash = JDHash.getMD5(f);
            int i = 1;
            String nH = hash;
            while (map.containsKey(nH)) {
                nH = String.valueOf(hash) + "_" + i;
                ++i;
            }
            map.put(nH, path);
        }
        return map;
    }

    private void merge() throws IOException {
        this.copyDirectory(this.updateDir, this.workingDir);
    }

    private boolean upload(ArrayList<File> list) throws IOException {
        SimpleFTP.uploadSecure("update1.jdownloader.org", 2121, Updater.getCFG("update1_ftp_user"), Updater.getCFG("update1_ftp_pass"), "/http/" + this.branch, this.updateDir, list.toArray(new File[0]));
        return true;
    }

    private ArrayList<File> getFileList() {
        System.out.println("Demerge updatelist");
        ArrayList<File> listUpdate = this.getLocalFileList(this.updateDir, true);
        listUpdate.remove(0);
        Iterator<File> it = listUpdate.iterator();
        while (it.hasNext()) {
            File file = it.next();
            String newHash = JDHash.getMD5(file);
            String newFile = file.getAbsolutePath().replace(this.updateDir.getAbsolutePath(), "");
            if ((newFile = newFile.replace("\\", "/")).trim().length() == 0) continue;
            File localFile = new File(this.workingDir, newFile);
            if (file.isDirectory() && localFile.isDirectory() && localFile.exists()) {
                it.remove();
                continue;
            }
            String localHash = JDHash.getMD5(localFile);
            if (localHash != null && localHash.equalsIgnoreCase(newHash)) {
                it.remove();
                continue;
            }
            System.out.println("Update: " + localFile);
        }
        System.out.println("Demerge updatelist finished: " + listUpdate.size() + " files");
        return listUpdate;
    }

    private void movePlugins(String cfg) throws IOException {
        if (cfg == null) {
            return;
        }
        this.pluginsDir = new File(cfg);
        File file = new File(this.updateDir, "jd/plugins/hoster");
        JDIO.removeDirectoryOrFile(file);
        this.copyDirectory(new File(this.pluginsDir, "hoster"), file);
        System.out.println("Updated BIN->" + file);
        file = new File(this.updateDir, "jd/plugins/decrypter");
        JDIO.removeDirectoryOrFile(file);
        this.copyDirectory(new File(this.pluginsDir, "decrypter"), file);
        System.out.println("Updated BIN->" + file);
        file = new File(this.updateDir, "jd/dynamics");
        JDIO.removeDirectoryOrFile(file);
        this.copyDirectory(new File(this.pluginsDir.getParentFile(), "dynamics"), file);
        System.out.println("Updated BIN->" + file);
    }

    public void copyDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.getAbsolutePath().contains(".svn")) {
            return;
        }
        if (srcPath.isDirectory()) {
            if (!dstPath.exists()) {
                System.out.println("Create Dir" + dstPath);
                dstPath.mkdir();
            }
            String[] files = srcPath.list();
            int i = 0;
            while (i < files.length) {
                this.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
                ++i;
            }
        } else {
            this.copyFile(srcPath, dstPath);
        }
    }

    private void copyFile(File srcPath, File dstPath) throws IOException {
        String hashd = JDHash.getMD5(dstPath);
        String hashs = JDHash.getMD5(srcPath);
        if (srcPath.getAbsolutePath().contains(".svn")) {
            return;
        }
        if (!srcPath.exists()) {
            System.out.println("File or directory does not exist.");
            System.exit(0);
        } else {
            int len;
            if (hashs.equalsIgnoreCase(hashd)) {
                return;
            }
            if (dstPath.exists()) {
                dstPath.delete();
            }
            FileInputStream in = new FileInputStream(srcPath);
            dstPath.getParentFile().mkdirs();
            dstPath.createNewFile();
            FileOutputStream out = new FileOutputStream(dstPath);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            System.out.println("        Copy File " + srcPath + " -> " + dstPath);
        }
    }

    private void removeFileOverhead() throws Exception {
        ArrayList<File> localFiles = this.getLocalFileList(this.workingDir, false);
        StringBuilder sb = new StringBuilder();
        ArrayList<String> remRequested = new ArrayList<String>();
        File tmp = new File(this.updateDir, "/tmp/");
        JDIO.removeDirectoryOrFile(tmp);
        tmp.mkdirs();
        tmp = new File(this.updateDir, "/config/");
        JDIO.removeDirectoryOrFile(tmp);
        tmp.mkdirs();
        tmp = new File(this.updateDir, "/backup/");
        JDIO.removeDirectoryOrFile(tmp);
        tmp.mkdirs();
        tmp = new File(this.workingDir, "/tmp/");
        JDIO.removeDirectoryOrFile(tmp);
        tmp.mkdirs();
        tmp = new File(this.workingDir, "/config/");
        JDIO.removeDirectoryOrFile(tmp);
        tmp.mkdirs();
        tmp = new File(this.workingDir, "/backup/");
        JDIO.removeDirectoryOrFile(tmp);
        tmp.mkdirs();
        int i = 0;
        for (File f : localFiles) {
            if (f.isDirectory() || this.containsFile(f) || f.getAbsolutePath().equalsIgnoreCase(this.workingDir.getAbsolutePath())) continue;
            sb.append(String.valueOf(f.getAbsolutePath()) + "\r\n");
            remRequested.add(f.getAbsolutePath());
            ++i;
        }
        String removeFiles = UserIOGui.getInstance().requestTextAreaDialog("Files to remove", "These " + i + " files were found localy, but not in the remotehashlist. The will be removed if you don't delete them.", sb.toString());
        if (removeFiles != null) {
            String[] stringArray = Regex.getLines(removeFiles);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                File del = new File(line.trim());
                if (del.exists()) {
                    System.out.println("Delete " + del.getAbsolutePath());
                    while (!JDIO.removeDirectoryOrFile(del)) {
                        JOptionPane.showConfirmDialog(this.frame, "COuld not delete " + del.getAbsolutePath());
                    }
                }
                ++n2;
            }
        }
        for (String path : remRequested) {
            File f = new File(path);
            if (!f.exists()) continue;
            String newPath = path.replace(this.workingDir.getAbsolutePath(), this.updateDir.getAbsolutePath());
            File newFile = new File(newPath);
            if (newFile.exists() && newFile.lastModified() >= f.lastModified()) {
                System.out.println("Removed " + path + "(newer file in " + this.updateDir.getAbsolutePath());
                f.delete();
                continue;
            }
            if (newFile.exists()) {
                System.out.println("Rename " + path + "-->" + newPath + "(newer file in " + this.workingDir.getAbsolutePath());
                newFile.delete();
                f.renameTo(newFile);
                continue;
            }
            System.out.println("Move " + path + "->" + newFile.getAbsolutePath());
            f.renameTo(newFile);
        }
    }

    private void initGUI() {
        this.frame = new JFrame();
        this.frame.setTitle("Updater");
        this.frame.setAlwaysOnTop(true);
        this.frame.setVisible(true);
    }

    private void webupdate() {
        try {
            this.webupdater = new WebUpdater();
            this.webupdater.setIgnorePlugins(false);
            this.webupdater.setWorkingdir(this.workingDir);
            this.webupdater.setOSFilter(false);
            this.remoteFileList = this.webupdater.getAvailableFiles();
            this.latestBranch = this.webupdater.getBranch();
            ArrayList update = (ArrayList)this.remoteFileList.clone();
            this.webupdater.filterAvailableUpdates(update);
            System.out.println("UPdate: " + update);
            this.webupdater.updateFiles(update, null);
        }
        catch (Exception e) {
            JDLogger.exception(e);
            this.remoteFileList = new ArrayList();
        }
    }

    private boolean containsFile(File f) {
        for (FileUpdate fu : this.remoteFileList) {
            String remote = fu.getLocalFile().getAbsolutePath();
            String local = f.getAbsolutePath();
            if (!(f.isDirectory() ? remote.startsWith(local) : f.exists() && remote.equals(local) && JDHash.getMD5(f).equalsIgnoreCase(fu.getRemoteHash()))) continue;
            return true;
        }
        return false;
    }

    private ArrayList<File> getLocalFileList(File dir, boolean noFilter) {
        ArrayList<File> ret = new ArrayList<File>();
        if (!noFilter && (dir.getAbsolutePath().contains("addonlist.lst") || dir.getAbsolutePath().contains(UPDATE_SUB_SRC) || dir.getAbsolutePath().contains(UPDATE_SUB_DIR))) {
            return ret;
        }
        ret.add(dir);
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                ret.addAll(this.getLocalFileList(f, noFilter));
            } else if (noFilter || !f.getAbsolutePath().contains("addonlist.lst") && !f.getAbsolutePath().contains(UPDATE_SUB_SRC) && !f.getAbsolutePath().contains(UPDATE_SUB_DIR)) {
                ret.add(f);
            }
            ++n2;
        }
        return ret;
    }
}

