/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.jdtrayicon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import jd.controlling.DownloadController;
import jd.controlling.DownloadInformations;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.components.JDProgressBar;
import jd.nutils.Formatter;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class TrayIconTooltip
extends JWindow {
    private static final long serialVersionUID = -400023413449818691L;
    private TrayInfo trayInfo;
    private JLabel lblSpeed;
    private JLabel lblDlRunning;
    private JLabel lblDlFinished;
    private JLabel lblDlTotal;
    private JDProgressBar prgTotal;
    private JLabel lblETA;
    private JLabel lblProgress;
    private Point estimatedTopLeft;
    private TrayIcon trayIcon;
    private DownloadInformations ds = new DownloadInformations();

    public TrayIconTooltip() {
        JPanel toolPanel = new JPanel((LayoutManager)new MigLayout("wrap 2", "[fill, grow][fill, grow]"));
        toolPanel.setOpaque(true);
        toolPanel.setBackground(new Color(12177129));
        toolPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, toolPanel.getBackground().darker()));
        toolPanel.add((Component)new JLabel(JDL.L((String)"plugins.optional.trayIcon.downloads", (String)"Downloads:")), "spanx 2");
        toolPanel.add((Component)new JLabel(JDL.L((String)"plugins.optional.trayIcon.dl.running", (String)"Running:")), "gapleft 10");
        this.lblDlRunning = new JLabel("");
        toolPanel.add(this.lblDlRunning);
        toolPanel.add((Component)new JLabel(JDL.L((String)"plugins.optional.trayIcon.dl.finished", (String)"Finished:")), "gapleft 10");
        this.lblDlFinished = new JLabel("");
        toolPanel.add(this.lblDlFinished);
        toolPanel.add((Component)new JLabel(JDL.L((String)"plugins.optional.trayIcon.dl.total", (String)"Total:")), "gapleft 10");
        this.lblDlTotal = new JLabel("");
        toolPanel.add(this.lblDlTotal);
        toolPanel.add(new JLabel(JDL.L((String)"plugins.optional.trayIcon.speed", (String)"Speed:")));
        this.lblSpeed = new JLabel("");
        toolPanel.add(this.lblSpeed);
        toolPanel.add(new JLabel(JDL.L((String)"plugins.optional.trayIcon.progress", (String)"Progress: ")));
        this.lblProgress = new JLabel("");
        toolPanel.add(this.lblProgress);
        this.prgTotal = new JDProgressBar();
        toolPanel.add((Component)this.prgTotal, "spanx 2");
        toolPanel.add(new JLabel(JDL.L((String)"plugins.optional.trayIcon.eta", (String)"ETA:")));
        this.lblETA = new JLabel("");
        toolPanel.add(this.lblETA);
        this.setVisible(false);
        this.setAlwaysOnTop(true);
        this.add(toolPanel);
        this.pack();
    }

    public void show(Point point, TrayIcon trayIcon) {
        this.trayIcon = trayIcon;
        this.estimatedTopLeft = point;
        if (this.trayInfo != null) {
            this.trayInfo.interrupt();
        }
        this.trayInfo = new TrayInfo();
        this.trayInfo.start();
    }

    public void hideWindow() {
        new GuiRunnable<Object>(){

            public Object runSave() {
                if (TrayIconTooltip.this.isVisible()) {
                    TrayIconTooltip.this.setVisible(false);
                }
                return null;
            }
        }.start();
    }

    private void setLocation() {
        new GuiRunnable<Object>(){

            public Object runSave() {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int limitX = (int)screenSize.getWidth() / 2;
                int limitY = (int)screenSize.getHeight() / 2;
                Point pp = TrayIconTooltip.this.estimatedTopLeft;
                if (pp.x <= limitX) {
                    if (pp.y <= limitY) {
                        TrayIconTooltip.this.setLocation(pp.x, pp.y + ((TrayIconTooltip)TrayIconTooltip.this).trayIcon.getSize().height);
                    } else {
                        TrayIconTooltip.this.setLocation(pp.x, pp.y - TrayIconTooltip.this.getHeight());
                    }
                } else if (pp.y <= limitY) {
                    TrayIconTooltip.this.setLocation(pp.x - TrayIconTooltip.this.getWidth(), pp.y + ((TrayIconTooltip)TrayIconTooltip.this).trayIcon.getSize().height);
                } else {
                    TrayIconTooltip.this.setLocation(pp.x - TrayIconTooltip.this.getWidth(), pp.y - TrayIconTooltip.this.getHeight());
                }
                return null;
            }
        }.waitForEDT();
    }

    private class TrayInfo
    extends Thread
    implements Runnable {
        private TrayInfo() {
        }

        public void run() {
            TrayIconTooltip.this.pack();
            TrayIconTooltip.this.setLocation();
            TrayIconTooltip.this.setVisible(true);
            TrayIconTooltip.this.toFront();
            final DownloadController dlc = JDUtilities.getDownloadController();
            while (TrayIconTooltip.this.isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        dlc.getDownloadStatus(TrayIconTooltip.this.ds);
                        TrayIconTooltip.this.lblDlRunning.setText(String.valueOf(TrayIconTooltip.this.ds.getRunningDownloads()));
                        TrayIconTooltip.this.lblDlFinished.setText(String.valueOf(TrayIconTooltip.this.ds.getFinishedDownloads()));
                        TrayIconTooltip.this.lblDlTotal.setText(String.valueOf(TrayIconTooltip.this.ds.getDownloadCount()));
                        TrayIconTooltip.this.lblSpeed.setText(String.valueOf(Formatter.formatReadable((long)JDUtilities.getController().getSpeedMeter())) + "/s");
                        TrayIconTooltip.this.lblProgress.setText(String.valueOf(Formatter.formatFilesize((double)TrayIconTooltip.this.ds.getCurrentDownloadSize(), (int)0)) + " / " + Formatter.formatFilesize((double)TrayIconTooltip.this.ds.getTotalDownloadSize(), (int)0));
                        TrayIconTooltip.this.prgTotal.setMaximum(TrayIconTooltip.this.ds.getTotalDownloadSize());
                        TrayIconTooltip.this.prgTotal.setValue(TrayIconTooltip.this.ds.getCurrentDownloadSize());
                        long etanum = 0L;
                        if (JDUtilities.getController().getSpeedMeter() > 1024) {
                            etanum = (TrayIconTooltip.this.ds.getTotalDownloadSize() - TrayIconTooltip.this.ds.getCurrentDownloadSize()) / (long)JDUtilities.getController().getSpeedMeter();
                        }
                        TrayIconTooltip.this.lblETA.setText(Formatter.formatSeconds((long)etanum));
                        TrayIconTooltip.this.pack();
                    }
                });
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
            TrayIconTooltip.this.hideWindow();
        }
    }
}

