/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSMediaRuleImpl
implements CSSMediaRule,
Serializable {
    private CSSStyleSheetImpl _parentStyleSheet = null;
    private CSSRule _parentRule = null;
    private MediaList _media = null;
    private CSSRuleList _rules = null;

    public CSSMediaRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, MediaList media) {
        this._parentStyleSheet = parentStyleSheet;
        this._parentRule = parentRule;
        this._media = media;
    }

    @Override
    public short getType() {
        return 4;
    }

    @Override
    public String getCssText() {
        StringBuffer sb = new StringBuffer("@media ");
        sb.append(this.getMedia().toString()).append(" {");
        int i = 0;
        while (i < this.getCssRules().getLength()) {
            CSSRule rule = this.getCssRules().item(i);
            sb.append(rule.getCssText()).append(" ");
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 4) {
                throw new DOMExceptionImpl(13, 7);
            }
            this._media = ((CSSMediaRuleImpl)r)._media;
            this._rules = ((CSSMediaRuleImpl)r)._rules;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    @Override
    public CSSRule getParentRule() {
        return this._parentRule;
    }

    @Override
    public MediaList getMedia() {
        return this._media;
    }

    @Override
    public CSSRuleList getCssRules() {
        return this._rules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(rule));
            CSSOMParser parser = new CSSOMParser();
            parser.setParentStyleSheet(this._parentStyleSheet);
            CSSRule r = parser.parseRule(is);
            ((CSSRuleListImpl)this.getCssRules()).insert(r, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        return index;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            ((CSSRuleListImpl)this.getCssRules()).delete(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
    }

    public void setRuleList(CSSRuleListImpl rules) {
        this._rules = rules;
    }

    public String toString() {
        return this.getCssText();
    }
}

