/*
 * Decompiled with CFR 0.152.
 */
package jd.http.ext;

import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import jd.http.Browser;
import jd.http.Request;
import jd.http.ext.BasicBrowserEnviroment;
import jd.http.ext.ExtBrowserException;
import jd.http.ext.ExtHTMLFrameElement;
import jd.http.ext.ExtHTMLFrameImpl;
import jd.http.ext.FrameController;
import jd.http.ext.FrameStatusEvent;
import jd.http.ext.FullBrowserEnviroment;
import jd.http.ext.InputController;
import jd.http.ext.RendererUtilities;
import jd.http.ext.UserAgentDelegate;
import jd.http.ext.events.ExtBrowserEvent;
import jd.http.ext.events.ExtBrowserEventSender;
import jd.http.ext.events.ExtBrowserListener;
import jd.http.ext.events.JSInteraction;
import jd.http.ext.interfaces.BrowserEnviroment;
import jd.http.ext.security.JSPermissionRestricter;
import jd.parser.Regex;
import org.appwork.utils.logging.Log;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDivElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLFormElementImpl;
import org.lobobrowser.html.domimpl.HTMLFrameElementImpl;
import org.lobobrowser.html.domimpl.HTMLIFrameElementImpl;
import org.lobobrowser.html.domimpl.HTMLLinkElementImpl;
import org.w3c.dom.Element;
import org.w3c.dom.html2.HTMLCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtBrowser {
    private FrameController htmlFrameController;
    private UserAgentDelegate uac;
    private Browser commContext;
    private String url;
    private InputController inputController;
    private ExtBrowserEventSender eventSender;
    private BrowserEnviroment browserEnviroment = new BasicBrowserEnviroment(null, null);

    static {
        try {
            JSPermissionRestricter.init();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws ExtBrowserException, InterruptedException {
        ExtBrowser br = new ExtBrowser();
        br.setBrowserEnviroment(new FullBrowserEnviroment(){

            public void prepareContents(Request req) {
            }
        });
        Browser.init();
        Browser.setLogger((Logger)Log.L);
        Browser.setVerbose((boolean)true);
        br.getCommContext().forceDebug(true);
        ExtBrowser eb = new ExtBrowser();
        eb.setBrowserEnviroment(new BasicBrowserEnviroment(new String[]{".*templates/linkto.*", ".*cdn.mediafire.com/css/.*", ".*/blank.html"}, null));
        try {
            eb.getPage("http://www.mediafire.com/?dzmzuzmh2md");
            eb.waitForFrame("workframe2", 10000);
            System.out.println(eb.getHtmlText());
            HTMLCollection links = eb.getDocument().getLinks();
            int i = 0;
            while (i < links.getLength()) {
                String inner;
                HTMLLinkElementImpl l = (HTMLLinkElementImpl)links.item(i);
                if (RendererUtilities.isVisible(l) && (inner = l.getInnerHTML()).toLowerCase().contains("start download")) {
                    HTMLDivElementImpl div = (HTMLDivElementImpl)l.getParentNode();
                    String myURL = l.getAbsoluteHref();
                    eb.getCommContext().openGetConnection(myURL);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFrame(final String frameID, int msTimeout) throws InterruptedException {
        for (ExtHTMLFrameImpl frame : this.getFrames(null)) {
            if (!frameID.equalsIgnoreCase(frame.getID()) || !frame.getInternalFrameController().isLoaded()) continue;
            System.out.println("Frame already loaded");
            return;
        }
        ExtBrowserListener listener = new ExtBrowserListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFrameEvent(ExtBrowserEvent event) {
                if (event instanceof FrameStatusEvent && ((FrameStatusEvent)event).getType() == FrameStatusEvent.Types.EVAL_END && frameID.equalsIgnoreCase(((ExtHTMLFrameElement)((FrameStatusEvent)event).getCaller()).getID())) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        this.notify();
                    }
                }
            }
        };
        this.getEventSender().addListener(listener);
        ExtBrowserListener extBrowserListener = listener;
        synchronized (extBrowserListener) {
            listener.wait(msTimeout);
        }
    }

    private InputController getInputController() {
        return this.inputController;
    }

    private Element getElementByID(ExtHTMLFrameElement frame, String id) {
        if (frame == null) {
            frame = this.getFrameController();
        }
        Element ret = frame.getDocument().getElementById(id);
        return ret;
    }

    private ArrayList<HTMLFormElementImpl> getForms(ExtHTMLFrameElement frame) {
        if (frame == null) {
            frame = this.getFrameController();
        }
        HTMLCollection forms = frame.getDocument().getForms();
        return this.getList(forms, new ArrayList());
    }

    private <E> ArrayList<E> getList(HTMLCollection forms, ArrayList<E> arrayList) {
        int i = 0;
        while (i < forms.getLength()) {
            arrayList.add(forms.item(i));
            ++i;
        }
        return arrayList;
    }

    public FrameController getFrameController() {
        return this.htmlFrameController;
    }

    public String getHtmlText() {
        return this.getDocument().getInnerHTML();
    }

    public HTMLDocumentImpl getDocument() {
        return this.htmlFrameController.getDocument();
    }

    public ExtBrowser() {
        this.uac = new UserAgentDelegate(this);
        this.eventSender = new ExtBrowserEventSender();
        this.commContext = new Browser();
        this.commContext.setFollowRedirects(true);
        this.commContext.setCookiesExclusive(true);
        this.htmlFrameController = new FrameController(this);
        this.inputController = new InputController();
    }

    public ExtBrowserEventSender getEventSender() {
        return this.eventSender;
    }

    public void setInputController(InputController inputController) {
        this.inputController = inputController;
    }

    public Regex getRegex(String pattern) {
        return this.htmlFrameController.getRegex(pattern);
    }

    public ExtBrowser(Browser br) {
        this.uac = new UserAgentDelegate(this);
        this.eventSender = new ExtBrowserEventSender();
        this.commContext = br.cloneBrowser();
        this.commContext.setFollowRedirects(true);
        this.commContext.setCookiesExclusive(true);
        this.htmlFrameController = new FrameController(this);
        this.inputController = new InputController();
    }

    public void getPage(String url) throws ExtBrowserException {
        this.url = url;
        try {
            this.htmlFrameController.submitForm("GET", new URL(this.commContext.getURL(url)), null, null, null);
        }
        catch (Exception e) {
            throw new ExtBrowserException(e);
        }
    }

    public BrowserEnviroment getBrowserEnviroment() {
        return this.browserEnviroment;
    }

    public void setBrowserEnviroment(BrowserEnviroment userAgent) {
        this.browserEnviroment = userAgent;
        this.commContext.setCookiesExclusive(false);
        this.commContext.setCookiesExclusive(true);
    }

    public UserAgentContext getUserAgentContext() {
        return this.uac;
    }

    public Browser getCommContext() {
        return this.commContext;
    }

    public void eval(Browser br) throws ExtBrowserException {
        this.url = br.getURL();
        this.commContext = br.cloneBrowser();
        this.commContext.setFollowRedirects(true);
        this.commContext.setCookiesExclusive(true);
        this.commContext.setRequest(br.getRequest());
        this.htmlFrameController.setCommContext(this.commContext);
        try {
            this.htmlFrameController.eval();
        }
        catch (Exception e) {
            throw new ExtBrowserException(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public ArrayList<ExtHTMLFrameImpl> getFrames(ExtHTMLFrameElement baseFrame) {
        if (baseFrame == null) {
            baseFrame = this.getFrameController();
        }
        HTMLCollection frames = baseFrame.getHtmlFrameController().getFrames();
        ArrayList<ExtHTMLFrameImpl> ret = new ArrayList<ExtHTMLFrameImpl>();
        int i = 0;
        while (i < frames.getLength()) {
            if (frames.item(i) instanceof HTMLFrameElementImpl) {
                ret.add(new ExtHTMLFrameImpl((HTMLFrameElementImpl)frames.item(i)));
            } else if (frames.item(i) instanceof HTMLIFrameElementImpl) {
                ret.add(new ExtHTMLFrameImpl((HTMLIFrameElementImpl)frames.item(i)));
            }
            ++i;
        }
        return ret;
    }

    public String getScriptableVariable(String string) {
        return this.getFrameController().getScriptableVariable(string);
    }

    public void cleanUp() {
    }

    public void onFrameEvalStart(FrameController htmlFrameController2) {
        this.getEventSender().fireEvent(new FrameStatusEvent(this, htmlFrameController2, FrameStatusEvent.Types.EVAL_START));
    }

    public void onFrameLoadStart(FrameController htmlFrameController2) {
        this.getEventSender().fireEvent(new FrameStatusEvent(this, htmlFrameController2, FrameStatusEvent.Types.LOAD_START));
    }

    public void onFrameLoadEnd(FrameController htmlFrameController2) {
        this.getEventSender().fireEvent(new FrameStatusEvent(this, htmlFrameController2, FrameStatusEvent.Types.LOAD_END));
    }

    public void onFrameEvalEnd(FrameController htmlFrameController2) {
        this.getEventSender().fireEvent(new FrameStatusEvent(this, htmlFrameController2, FrameStatusEvent.Types.EVAL_END));
    }

    public void onAlert(FrameController htmlFrameController2, String arg0) {
        this.getEventSender().fireEvent(new JSInteraction(this, htmlFrameController2, JSInteraction.Types.ALERT, arg0));
    }

    public boolean onConfirm(String arg0, FrameController htmlFrameController) {
        JSInteraction event = new JSInteraction(this, htmlFrameController, JSInteraction.Types.CONFIRM, arg0);
        this.getEventSender().fireEvent(event);
        return event.getAnswer() == JSInteraction.AnswerTypes.OK;
    }

    public String onPrompt(String arg0, String arg1, FrameController htmlFrameController2) {
        JSInteraction event = new JSInteraction(this, htmlFrameController2, JSInteraction.Types.PROMPT, arg0, arg1);
        this.getEventSender().fireEvent(event);
        return event.getAnswerString();
    }
}

