/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.controlling;

import java.util.ArrayList;
import java.util.HashMap;
import org.appwork.controlling.State;
import org.appwork.controlling.StateConflictException;
import org.appwork.controlling.StateEvent;
import org.appwork.controlling.StateEventListener;
import org.appwork.controlling.StateEventsender;
import org.appwork.controlling.StateMachineInterface;
import org.appwork.controlling.StatePathEntry;

public class StateMachine {
    private State initState;
    private State currentState;
    private StateEventsender eventSender;
    private State finalState;
    private ArrayList<StatePathEntry> path;
    private StateMachineInterface owner;
    private Object lock = new Object();
    private HashMap<State, Throwable> exceptionMap;

    public StateMachine(StateMachineInterface interfac, State startState, State endState) {
        this.owner = interfac;
        this.initState = startState;
        this.currentState = startState;
        this.finalState = endState;
        this.exceptionMap = new HashMap();
        this.eventSender = new StateEventsender();
        this.path = new ArrayList();
        this.path.add(new StatePathEntry(this.initState));
    }

    public StateMachineInterface getOwner() {
        return this.owner;
    }

    public static void validateStateChain(State initState) {
        if (initState.getParents().size() > 0) {
            throw new StateConflictException("initState must not have a parent");
        }
        StateMachine.checkState(initState);
    }

    private static State checkState(State state) {
        State finalState = null;
        for (State s : state.getChildren()) {
            State ret = StateMachine.checkState(s);
            if (finalState == null) {
                finalState = ret;
            }
            if (finalState == ret) continue;
            throw new StateConflictException("States do not all result in one common final state");
        }
        if (finalState == null) {
            throw new StateConflictException(state + " is a blind state (has no children)");
        }
        return finalState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(State newState) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentState == newState) {
                return;
            }
            if (!this.currentState.getChildren().contains(newState)) {
                throw new StateConflictException("Cannot change state from " + this.currentState + " to " + newState);
            }
        }
        this.forceState(newState);
    }

    public void fireUpdate(State currentState) {
        if (currentState != null && this.currentState != currentState) {
            throw new StateConflictException("Cannot update state " + currentState + " because current state is " + this.currentState);
        }
        StateEvent event = new StateEvent(this, 1, currentState, currentState);
        this.eventSender.fireEvent(event);
    }

    public boolean isState(State ... states) {
        State[] stateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            State s = stateArray[n2];
            if (s == this.currentState) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addListener(StateEventListener listener) {
        this.eventSender.addListener(listener);
    }

    public void removeListener(StateEventListener listener) {
        this.eventSender.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        StateEvent event;
        Object object = this.lock;
        synchronized (object) {
            if (this.currentState == this.initState) {
                return;
            }
            if (this.finalState != this.currentState) {
                throw new StateConflictException("Cannot reset from state " + this.currentState);
            }
            event = new StateEvent(this, 0, this.currentState, this.initState);
            this.currentState = this.initState;
            this.path.clear();
            this.path.add(new StatePathEntry(this.initState));
        }
        this.eventSender.fireEvent(event);
    }

    public ArrayList<StatePathEntry> getPath() {
        return this.path;
    }

    public boolean isFinal() {
        return this.finalState == this.currentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceState(State newState) {
        StateEvent event;
        Object object = this.lock;
        synchronized (object) {
            if (this.currentState == newState) {
                return;
            }
            event = new StateEvent(this, 0, this.currentState, newState);
            this.path.add(new StatePathEntry(newState));
            this.currentState = newState;
        }
        this.eventSender.fireEvent(event);
    }

    public boolean hasPassed(State ... states) {
        State[] stateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            State s = stateArray[n2];
            for (StatePathEntry e : this.path) {
                if (e.getState() != s) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isStartState() {
        return this.currentState == this.initState;
    }

    public State getState() {
        return this.currentState;
    }

    public Throwable getCause(State newState) {
        return this.exceptionMap.get(newState);
    }

    public void setCause(State failedState, Throwable e) {
        this.exceptionMap.put(failedState, e);
    }

    public StatePathEntry getLatestStateEntry(State failedState) {
        try {
            StatePathEntry entry = null;
            int i = this.path.size() - 1;
            while (i >= 0) {
                entry = this.path.get(i);
                if (entry.getState() == failedState) {
                    return entry;
                }
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

