/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.io.IOException;
import java.util.HashMap;
import org.appwork.storage.ConfigInterface;
import org.appwork.storage.Storage;
import org.appwork.storage.StorageException;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.crypto.Crypto;
import org.appwork.utils.logging.Log;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;

public class JacksonStorageChest
extends Storage {
    private final HashMap<String, Object> map = new HashMap();
    private final String name;

    public JacksonStorageChest(String name) throws StorageException {
        this.name = name;
        try {
            String str = Crypto.decrypt(IO.readFile(Application.getRessource("cfg/" + name + ".ejs")), ConfigInterface.KEY);
            HashMap load = (HashMap)ConfigInterface.getMapper().readValue(str, HashMap.class);
            this.map.putAll(load);
        }
        catch (JsonParseException e) {
            Log.exception(e);
        }
        catch (JsonMappingException e) {
            Log.exception(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public <E> E get(String key, E def) throws StorageException {
        Object ret = this.map.get(key);
        if (ret == null && def != null) {
            ret = def;
            if (def instanceof Boolean) {
                this.put(key, (Boolean)def);
            } else if (def instanceof Long) {
                this.put(key, (Long)def);
            } else if (def instanceof Integer) {
                this.put(key, (Integer)def);
            } else if (def instanceof Byte) {
                this.put(key, (Byte)def);
            } else if (def instanceof String) {
                this.put(key, (String)def);
            } else if (def instanceof Enum) {
                this.put(key, (Enum)def);
            } else if (def instanceof Double) {
                this.put(key, (Double)def);
            } else {
                throw new StorageException("Invalid datatype: " + def.getClass());
            }
        }
        if (def instanceof Enum && ret instanceof String) {
            try {
                ret = Enum.valueOf(((Enum)def).getDeclaringClass(), (String)ret);
            }
            catch (Throwable e) {
                Log.exception(e);
                this.put(key, (Enum)def);
                ret = def;
            }
        }
        return (E)ret;
    }

    @Override
    public void put(String key, Boolean value) throws StorageException {
        this.map.put(key, value);
    }

    @Override
    public void put(String key, Byte value) throws StorageException {
        this.map.put(key, value);
    }

    @Override
    public void put(String key, Enum<?> value) throws StorageException {
        this.map.put(key, value);
    }

    @Override
    public void put(String key, Integer value) throws StorageException {
        this.map.put(key, value);
    }

    @Override
    public void put(String key, Long value) throws StorageException {
        this.map.put(key, value);
    }

    @Override
    public void put(String key, String value) throws StorageException {
        this.map.put(key, value);
    }

    @Override
    public void save() throws StorageException {
        try {
            String json = ConfigInterface.getMapper().writeValueAsString(this.map);
            ConfigInterface.saveTo("cfg/" + this.name + ".ejs", json);
        }
        catch (JsonGenerationException e) {
            Log.exception(e);
        }
        catch (JsonMappingException e) {
            Log.exception(e);
        }
        catch (IOException e) {
            Log.exception(e);
        }
    }

    @Override
    public void clear() throws StorageException {
        this.map.clear();
    }

    @Override
    public void put(String key, Double value) throws StorageException {
        this.map.put(key, value);
    }

    @Override
    public void put(String key, Float value) throws StorageException {
        this.map.put(key, value);
    }
}

