/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event;

import java.util.EventListener;
import java.util.Vector;
import org.appwork.utils.event.Event;

public abstract class Eventsender<T extends EventListener, TT extends Event> {
    protected transient Vector<T> listeners = new Vector();
    protected transient Vector<T> removeRequestedListeners = new Vector();

    public void addAllListener(Vector<T> listener) {
        for (EventListener l : listener) {
            this.addListener(l);
        }
    }

    public void addListener(T listener) {
        if (this.removeRequestedListeners.contains(listener)) {
            this.removeRequestedListeners.remove(listener);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected abstract void fireEvent(T var1, TT var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(TT event) {
        Vector<T> vector = this.removeRequestedListeners;
        synchronized (vector) {
            this.listeners.removeAll(this.removeRequestedListeners);
            this.removeRequestedListeners.clear();
        }
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            this.fireEvent((EventListener)this.listeners.get(i), event);
            --i;
        }
        if (this.removeRequestedListeners.size() > 0) {
            Vector<T> vector2 = this.removeRequestedListeners;
            synchronized (vector2) {
                this.listeners.removeAll(this.removeRequestedListeners);
                this.removeRequestedListeners.clear();
            }
        }
    }

    public void removeListener(T listener) {
        if (!this.removeRequestedListeners.contains(listener)) {
            this.removeRequestedListeners.add(listener);
        }
    }
}

