/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event.queue;

import org.appwork.utils.event.queue.Queue;

public abstract class QueueItem {
    private Object result = null;
    private Exception exce = null;
    private volatile boolean finished = false;
    private volatile boolean killed = false;
    private volatile boolean started = false;
    private Queue<?> queue = null;
    private QueueItem source = null;
    private Queue.QueuePriority prio = Queue.QueuePriority.NORM;

    public QueueItem() {
    }

    public QueueItem(Queue.QueuePriority prio) {
        this.prio = prio;
    }

    protected Queue<?> getQueue() {
        return this.queue;
    }

    public Queue.QueuePriority getQueuePrio() {
        return this.prio;
    }

    public void setQueuePrio(Queue.QueuePriority prio) {
        this.prio = prio;
    }

    public void setSourceQueueItem(QueueItem source) {
        this.source = source;
    }

    public QueueItem getSourceQueueItem() {
        return this.source;
    }

    public void start(Queue<?> queue) throws Exception {
        this.queue = queue;
        this.started = true;
        try {
            try {
                this.result = this.run();
            }
            catch (Exception e) {
                this.exce = e;
                throw e;
            }
        }
        finally {
            this.finished = true;
        }
    }

    public boolean gotStarted() {
        return this.started;
    }

    public void kill() {
        if (this.finished) {
            return;
        }
        this.killed = true;
        this.finished = true;
    }

    public boolean gotKilled() {
        return this.killed;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Object getResult() {
        return this.result;
    }

    public Exception getException() {
        return this.exce;
    }

    protected abstract Object run() throws Exception;

    public void exceptionHandler(Exception e) {
    }
}

