/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;

public class LogToFileHandler
extends Handler {
    private File file;
    private BufferedWriter writer;

    public LogToFileHandler() throws IOException {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(new Date().getTime());
        this.file = Application.getRessource("logs/" + cal.get(1) + "-" + (1 + cal.get(2)) + "-" + cal.get(5) + ".log");
        this.file.getParentFile().mkdirs();
        this.file.deleteOnExit();
        if (!this.file.isFile()) {
            this.file.createNewFile();
        }
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "UTF8"));
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            Log.exception(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            Log.exception(e);
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord.getLevel() == Level.INFO) {
            try {
                this.writer.write(this.getFormatter().format(logRecord));
            }
            catch (IOException e) {
                Log.exception(e);
            }
        }
    }
}

