/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.util.ArrayList;
import java.util.Iterator;

public class ConnectionLimiter {
    private static final Object LOCK = new Object();
    private int connectioncount;
    private ArrayList<Long> list = new ArrayList();
    private int maxConcurrent = -1;
    private int timeConnections = -1;
    private long timeTime = -1L;

    public synchronized void setMaxConcurrent(int max) {
        if (max <= 0) {
            max = -1;
        }
        this.maxConcurrent = max;
    }

    public int getMaxConcurrent() {
        return this.maxConcurrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedConnection() {
        Object object = LOCK;
        synchronized (object) {
            --this.connectioncount;
        }
    }

    public long[] getConnectionTimeLimit() {
        return new long[]{this.timeConnections, this.timeTime};
    }

    public synchronized void setConnectionTimeLimit(int connections, long time) {
        if (connections > 0 && time > 0L) {
            this.timeConnections = connections;
            this.timeTime = time;
        } else {
            this.timeConnections = -1;
            this.timeTime = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void openedConnection() throws InterruptedException {
        Object object;
        if (this.maxConcurrent > 0) {
            while (true) {
                object = LOCK;
                synchronized (object) {
                    if (this.connectioncount < this.maxConcurrent) {
                        break;
                    }
                }
                Thread.sleep(250L);
            }
        }
        if (this.timeConnections > 0) {
            while (true) {
                Iterator<Long> it = this.list.iterator();
                while (it.hasNext() && it.next() + this.timeTime < System.currentTimeMillis()) {
                    it.remove();
                }
                if (this.list.size() < this.timeConnections) break;
                long wait = this.timeConnections;
                if (it.hasNext()) {
                    wait = Math.max(250L, it.next() - (System.currentTimeMillis() - this.timeTime));
                }
                Thread.sleep(wait);
            }
            this.list.add(System.currentTimeMillis());
        }
        object = LOCK;
        synchronized (object) {
            ++this.connectioncount;
        }
    }
}

