/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.AbstractDialog;

public class ConfirmDialog
extends AbstractDialog {
    private static final long serialVersionUID = -7647771640756844691L;
    private JTextPane textField;
    private String message;

    public ConfirmDialog(int flag, String title, String message, ImageIcon icon, String okOption, String cancelOption) {
        super(flag, title, icon, okOption, cancelOption);
        this.message = message;
        this.init();
    }

    @Override
    public String toString() {
        return ("dialog-" + this.getTitle() + "_" + this.message).replaceAll("\\W", "_");
    }

    @Override
    public Dimension getPreferredSize() {
        if (!BinaryLogic.containsAll(this.flagMask, 64)) {
            return super.getPreferredSize();
        }
        return new Dimension(600, 450);
    }

    @Override
    public JComponent layoutDialogContent() {
        this.textField = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return !BinaryLogic.containsAll(ConfirmDialog.this.flagMask, 64);
            }
        };
        if (BinaryLogic.containsAll(this.flagMask, 128)) {
            this.textField.setContentType("text/html");
            this.textField.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        CrossSystem.openURL(e.getURL());
                    }
                }
            });
        } else {
            this.textField.setContentType("text");
            this.textField.setMaximumSize(new Dimension(450, 600));
        }
        this.textField.setText(this.message);
        this.textField.setEditable(false);
        this.textField.setBackground(null);
        this.textField.setOpaque(false);
        this.textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        if (BinaryLogic.containsAll(this.flagMask, 64)) {
            JScrollPane sp = new JScrollPane(this.textField);
            return sp;
        }
        return this.textField;
    }
}

