/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.ConfigInterface;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.locale.Tl8;
import org.appwork.utils.logging.Log;
import org.appwork.utils.swing.dialog.AbstractDialog;

public class SearchDialog
extends AbstractDialog
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 9206575398715006581L;
    private String message;
    private JTextPane messageArea;
    private JTextComponent input;
    private JCheckBox caseSensitive = new JCheckBox(Tl8.SEARCHDIALOG_CHECKBOX_CASESENSITIVE.toString());
    private JCheckBox regularExpression = new JCheckBox(Tl8.SEARCHDIALOG_CHECKBOX_REGULAREXPRESSION.toString());

    public SearchDialog(int flag, String title, String message) throws IOException {
        super(flag | 0x10, title, ImageProvider.getImageIcon("find", 32, 32), Tl8.SEARCHDIALOG_BUTTON_FIND.toString(), null);
        try {
            this.caseSensitive.setSelected(ConfigInterface.getStorage("SearchDialog").get("caseSensitive", false));
            this.regularExpression.setSelected(ConfigInterface.getStorage("SearchDialog").get("regularExpression", false));
        }
        catch (Exception e) {
            Log.exception(e);
        }
        this.message = message;
        this.init();
    }

    @Override
    public JComponent layoutDialogContent() {
        JPanel contentpane = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 1", "[fill,grow]"));
        this.messageArea = new JTextPane();
        this.messageArea.setBorder(null);
        this.messageArea.setBackground(null);
        this.messageArea.setOpaque(false);
        this.messageArea.setText(this.message);
        this.messageArea.setEditable(false);
        this.messageArea.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        contentpane.add(this.messageArea);
        this.input = new JTextField();
        this.input.setBorder(BorderFactory.createEtchedBorder());
        this.input.addKeyListener(this);
        this.input.addMouseListener(this);
        contentpane.add((Component)this.input, "pushy,growy");
        contentpane.add((Component)this.regularExpression, "split 2, alignx right, pushx");
        contentpane.add((Component)this.caseSensitive, " alignx right");
        return contentpane;
    }

    @Override
    protected void packed() {
        this.input.selectAll();
        this.requestFocus();
        this.input.requestFocusInWindow();
    }

    public String getReturnID() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return null;
        }
        if (this.input.getText() == null || this.input.getText().equals("")) {
            return null;
        }
        try {
            ConfigInterface.getStorage("SearchDialog").put("caseSensitive", this.caseSensitive.isSelected());
            ConfigInterface.getStorage("SearchDialog").put("regularExpression", this.regularExpression.isSelected());
        }
        catch (Exception e) {
            Log.exception(e);
        }
        return this.input.getText();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.cancel();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.cancel();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive.isSelected();
    }

    public boolean isRegex() {
        return this.regularExpression.isSelected();
    }
}

