/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.interfaces.ValueConverter;
import org.appwork.utils.swing.dialog.AbstractDialog;

public class ValueDialog
extends AbstractDialog
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 9206575398715006581L;
    private String message;
    private JTextPane messageArea;
    private JSlider slider;
    private long min;
    private long max;
    private long step;
    private JTextArea converted;
    private ValueConverter valueconverter;
    private int faktor = 1;
    private long defaultValue;
    private JTextField editable;

    public ValueDialog(int flag, String title, String message, ImageIcon icon, String okOption, String cancelOption, long defaultValue, long min, long max, long step, ValueConverter valueConverter) {
        super(flag, title, icon, okOption, cancelOption);
        this.message = message;
        while (max > Integer.MAX_VALUE) {
            max /= 2L;
            defaultValue /= 2L;
            min /= 2L;
            step = Math.max(step / 2L, 1L);
            this.faktor *= 2;
        }
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.step = step;
        if (valueConverter == null) {
            valueConverter = new ValueConverter(){

                @Override
                public String toString(long value) {
                    return String.valueOf(value * (long)ValueDialog.this.faktor);
                }
            };
        }
        this.valueconverter = valueConverter;
        this.init();
    }

    @Override
    public JComponent layoutDialogContent() {
        JPanel contentpane = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 1", "[fill,grow]"));
        this.messageArea = new JTextPane();
        this.messageArea.setBorder(null);
        this.messageArea.setBackground(null);
        this.messageArea.setOpaque(false);
        this.messageArea.setText(this.message);
        this.messageArea.setEditable(false);
        this.messageArea.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        contentpane.add(this.messageArea);
        if (BinaryLogic.containsAll(this.flagMask, 64)) {
            this.converted = new JTextArea(this.valueconverter.toString(this.defaultValue));
            this.converted.setEditable(false);
            this.converted.setBackground(null);
            this.slider = new JSlider(0, (int)this.min, (int)this.max, (int)this.defaultValue);
            this.slider.setMajorTickSpacing((int)this.step);
            this.slider.setSnapToTicks(true);
            this.slider.addKeyListener(this);
            this.slider.addMouseListener(this);
            this.editable = new JTextField();
            this.editable.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ValueDialog.this.updateSlider();
                }
            });
            this.editable.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ValueDialog.this.updateSlider();
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    ValueDialog.this.converted.setText(ValueDialog.this.valueconverter.toString(ValueDialog.this.slider.getValue() * ValueDialog.this.faktor));
                    ValueDialog.this.editable.setText(String.valueOf(ValueDialog.this.slider.getValue() * ValueDialog.this.faktor));
                }
            });
            this.editable.setText(String.valueOf(this.defaultValue));
            contentpane.add((Component)this.slider, "split 2,pushy,growy,w 250");
            contentpane.add((Component)this.editable, "growx,pushx,width 80:n:n");
            contentpane.add((Component)this.converted, "pushy,growy,w 250");
        } else {
            this.converted = new JTextArea(this.valueconverter.toString(this.defaultValue));
            this.slider = new JSlider(0, (int)this.min, (int)this.max, (int)this.defaultValue);
            this.slider.setMajorTickSpacing((int)this.step);
            this.slider.setSnapToTicks(true);
            this.slider.setBorder(BorderFactory.createEtchedBorder());
            this.slider.addKeyListener(this);
            this.slider.addMouseListener(this);
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    ValueDialog.this.converted.setText(ValueDialog.this.valueconverter.toString(ValueDialog.this.slider.getValue() * ValueDialog.this.faktor));
                    ValueDialog.this.editable.setText(String.valueOf(ValueDialog.this.slider.getValue() * ValueDialog.this.faktor));
                }
            });
            contentpane.add((Component)this.slider, "pushy,growy,w 250");
            contentpane.add((Component)this.converted, "pushy,growy,w 250");
        }
        return contentpane;
    }

    private void updateSlider() {
        block2: {
            try {
                long value = Long.parseLong(this.editable.getText());
                this.slider.setValue((int)(value / (long)this.faktor));
            }
            catch (Exception e) {
                if (this.editable == null) break block2;
                this.editable.setText(String.valueOf(this.slider.getValue() * this.faktor));
            }
        }
    }

    @Override
    protected void packed() {
        this.requestFocus();
        this.slider.requestFocusInWindow();
    }

    public long getReturnValue() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return 0L;
        }
        this.updateSlider();
        return this.slider.getValue() * this.faktor;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.cancel();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.cancel();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

