/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.table.ExtDefaultRowSorter;
import org.appwork.utils.swing.table.ExtTable;
import org.appwork.utils.swing.table.ExtTableCellHeaderRenderer;
import org.appwork.utils.swing.table.ExtTableModel;

public abstract class ExtColumn<E>
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    protected static Color background = null;
    protected static Color backgroundselected = null;
    protected static Color foreground = null;
    protected static Color foregroundselected = null;
    private static final long serialVersionUID = -2662459732650363059L;
    private int clickcount = 1;
    private ExtTableModel<E> model;
    private String name;
    private boolean sortOrderToggle = true;
    private Thread sortThread = null;
    private TableCellRenderer headerrenderer;
    private ExtDefaultRowSorter<E> rowSorter;

    public ExtColumn(String name, ExtTableModel<E> table) {
        this.name = name;
        this.model = table;
        this.headerrenderer = new ExtTableCellHeaderRenderer(this);
        this.rowSorter = new ExtDefaultRowSorter();
    }

    public boolean isDefaultVisible() {
        return true;
    }

    protected boolean matchSearch(E object, Pattern pattern) {
        return false;
    }

    protected void doSort(Object obj) {
        if (this.sortThread != null) {
            return;
        }
        this.sortThread = new Thread("TableSorter " + this.getID()){

            @Override
            public void run() {
                final ArrayList selections = ExtColumn.this.model.getSelectedObjects();
                try {
                    ExtColumn.this.sortOrderToggle = !ExtColumn.this.sortOrderToggle;
                    ExtColumn.this.getModel().sort(ExtColumn.this, ExtColumn.this.sortOrderToggle);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ExtColumn.this.sortThread = null;
                new EDTHelper<Object>(){

                    @Override
                    public Object edtRun() {
                        ExtColumn.this.model.fireTableStructureChanged();
                        ExtColumn.this.model.setSelectedObjects(selections);
                        return null;
                    }
                }.start();
            }
        };
        this.sortThread.start();
    }

    protected boolean isSortOrderToggle() {
        return this.sortOrderToggle;
    }

    @Override
    public abstract Object getCellEditorValue();

    public int getClickcount() {
        return this.clickcount;
    }

    public String getID() {
        return String.valueOf(this.getClass().getSimpleName()) + this.name;
    }

    protected int getMaxWidth() {
        return -1;
    }

    public ExtTableModel<E> getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return ((ExtTable)table).getLafCellEditor(row, column).getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return ((ExtTable)table).getLafCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            return ((MouseEvent)evt).getClickCount() >= this.clickcount && this.clickcount > 0;
        }
        return true;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        E obj = this.model.getValueAt(rowIndex, columnIndex);
        if (obj == null) {
            return false;
        }
        return this.isEditable(obj);
    }

    public abstract boolean isEditable(E var1);

    public abstract boolean isEnabled(E var1);

    public abstract boolean isSortable(E var1);

    public void setClickcount(int clickcount) {
        this.clickcount = Math.max(0, clickcount);
    }

    public void setModel(ExtTableModel<E> model) {
        this.model = model;
    }

    public abstract void setValue(Object var1, E var2);

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        E obj = this.model.getValueAt(rowIndex, columnIndex);
        if (obj == null) {
            return;
        }
        this.setValue(value, obj);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.headerrenderer;
    }

    public ExtDefaultRowSorter<E> getRowSorter(boolean sortOrderToggle) {
        this.rowSorter.setSortOrderToggle(sortOrderToggle);
        return this.rowSorter;
    }

    public void setRowSorter(ExtDefaultRowSorter<E> rowSorter) {
        this.rowSorter = rowSorter;
    }

    public int getDefaultWidth() {
        return 100;
    }

    public int getMinWidth() {
        return 0;
    }
}

