/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.appwork.storage.ConfigInterface;
import org.appwork.utils.logging.Log;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.table.ExtColumn;
import org.appwork.utils.swing.table.ExtTable;

public abstract class ExtTableModel<E>
extends AbstractTableModel {
    private static final long serialVersionUID = 939549808899567618L;
    protected static final int UPDATE_STRUCTURE = 1;
    protected ArrayList<ExtColumn<E>> columns = new ArrayList();
    private String modelID;
    private ExtTable<E> table = null;
    protected ArrayList<E> tableData = new ArrayList();
    private ExtColumn<E> sortColumn;
    private boolean sortOrderToggle = true;

    public ExtTableModel(String id) {
        this.modelID = id;
        this.initColumns();
        String columnId = ConfigInterface.getStorage("ExtTableModel_" + this.modelID).get("SORTCOLUMN", this.columns.get(0).getID());
        for (ExtColumn<E> col : this.columns) {
            if (!col.getID().equals(columnId)) continue;
            this.sortColumn = col;
            break;
        }
        this.sortOrderToggle = ConfigInterface.getStorage("ExtTableModel_" + this.modelID).get("SORTORDER", false);
        this.refreshSort();
    }

    public void addColumn(ExtColumn<E> e) {
        e.setModel(this);
        this.columns.add(e);
    }

    public <T extends ExtColumn<E>> T getColumnByClass(Class<T> clazz) {
        try {
            for (ExtColumn<E> column : this.columns) {
                if (!column.getClass().equals(clazz)) continue;
                return (T)column;
            }
        }
        catch (Exception e) {
            Log.exception(e);
        }
        return null;
    }

    public void clearSelection() {
        if (this.table == null) {
            return;
        }
        this.table.getSelectionModel().clearSelection();
        this.table.getColumnModel().getSelectionModel().clearSelection();
    }

    public ArrayList<E> getSelectedObjects() {
        int[] rows;
        ArrayList<E> ret = new ArrayList<E>();
        if (this.table == null) {
            return ret;
        }
        int[] nArray = rows = this.table.getSelectedRows();
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            E elem = this.getValueAt(row, 0);
            if (elem != null) {
                ret.add(elem);
            }
            ++n2;
        }
        return ret;
    }

    public ArrayList<E> getTableObjects() {
        ArrayList<E> ret = new ArrayList<E>();
        ret.addAll(this.tableData);
        return ret;
    }

    public void setSelectedObject(final E latest) {
        if (this.table == null) {
            return;
        }
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                if (ExtTableModel.this.table == null) {
                    return null;
                }
                if (latest == null) {
                    ExtTableModel.this.clearSelection();
                    return null;
                }
                ExtTableModel.this.clearSelection();
                int row = ExtTableModel.this.getRowforObject(latest);
                ExtTableModel.this.table.addRowSelectionInterval(row, row);
                return null;
            }
        }.start();
    }

    public void setSelectedObjects(final ArrayList<E> selections) {
        if (this.table == null) {
            return;
        }
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                if (ExtTableModel.this.table == null) {
                    return null;
                }
                if (selections == null) {
                    ExtTableModel.this.clearSelection();
                    return null;
                }
                if (selections.size() == 0) {
                    return null;
                }
                ArrayList<Integer> selectedRows = new ArrayList<Integer>();
                int rowIndex = -1;
                for (Object obj : selections) {
                    rowIndex = ExtTableModel.this.getRowforObject(obj);
                    if (rowIndex < 0) continue;
                    selectedRows.add(rowIndex);
                }
                Collections.sort(selectedRows);
                for (Integer row : selectedRows) {
                    ExtTableModel.this.table.addRowSelectionInterval(row, row);
                }
                return null;
            }
        }.start();
    }

    public void addColumn(ExtColumn<E> e, int index) {
        e.setModel(this);
        this.columns.add(index, e);
    }

    public TableCellEditor getCelleditorByColumn(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    public ExtColumn<E> getCellrendererByColumn(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column).getName();
    }

    public ExtColumn<E> getExtColumn(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.tableData.size();
    }

    public ExtTable<E> getTable() {
        return this.table;
    }

    public ArrayList<E> getTableData() {
        return this.tableData;
    }

    public E getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.tableData.get(rowIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    protected abstract void initColumns();

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).isCellEditable(rowIndex, columnIndex);
    }

    public boolean isVisible(int column) {
        ExtColumn<E> col = this.getExtColumn(column);
        try {
            return ConfigInterface.getStorage("ExtTableModel_" + this.modelID).get("VISABLE_COL_" + col.getName(), col.isDefaultVisible());
        }
        catch (Exception e) {
            Log.exception(e);
            return true;
        }
    }

    protected void setTable(ExtTable<E> table) {
        this.table = table;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.columns.get(columnIndex).setValueAt(value, rowIndex, columnIndex);
    }

    public void setVisible(int column, boolean visible) {
        ExtColumn<E> col = this.getExtColumn(column);
        try {
            ConfigInterface.getStorage("ExtTableModel_" + this.modelID).put("VISABLE_COL_" + col.getName(), visible);
        }
        catch (Exception e) {
            Log.exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getObjectbyRow(int index) {
        ArrayList<E> arrayList = this.tableData;
        synchronized (arrayList) {
            if (index >= 0 && index < this.tableData.size()) {
                return this.tableData.get(index);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowforObject(E o) {
        ArrayList<E> arrayList = this.tableData;
        synchronized (arrayList) {
            return this.tableData.indexOf(o);
        }
    }

    public void sort(ExtColumn<E> column, boolean sortOrderToggle) {
        this.sortColumn = column;
        this.sortOrderToggle = sortOrderToggle;
        try {
            ConfigInterface.getStorage("ExtTableModel_" + this.modelID).put("SORTCOLUMN", column.getID());
            ConfigInterface.getStorage("ExtTableModel_" + this.modelID).put("SORTORDER", sortOrderToggle);
        }
        catch (Exception e) {
            Log.exception(e);
        }
        Collections.sort(this.getTableData(), column.getRowSorter(sortOrderToggle));
    }

    public void refreshSort() {
        this.sort(this.sortColumn == null ? this.getExtColumn(0) : this.sortColumn, this.sortOrderToggle);
    }

    public boolean isSortOrderToggle() {
        return this.sortOrderToggle;
    }

    public ExtColumn<E> getSortColumn() {
        return this.sortColumn;
    }

    public E searchNextObject(int startRow, String ret, boolean caseSensitive, boolean regex) {
        Pattern p;
        if (!regex) {
            String[] pats = ret.split("\\*");
            StringBuilder pattern = new StringBuilder();
            String[] stringArray = pats;
            int n = pats.length;
            int n2 = 0;
            while (n2 < n) {
                String pp = stringArray[n2];
                if (pattern.length() > 0) {
                    pattern.append(".*?");
                }
                pattern.append(Pattern.quote(pp));
                ++n2;
            }
            p = Pattern.compile(".*?" + pattern.toString() + ".*?", caseSensitive ? 2 : 32);
        } else {
            p = Pattern.compile(".*?" + ret + ".*?", caseSensitive ? 2 : 32);
        }
        int i = startRow;
        while (i < this.tableData.size()) {
            int c = 0;
            while (c < this.columns.size()) {
                if (this.columns.get(c).matchSearch(this.tableData.get(i), p)) {
                    return this.tableData.get(i);
                }
                ++c;
            }
            ++i;
        }
        i = 0;
        while (i < startRow) {
            int c = 0;
            while (c < this.columns.size()) {
                if (this.columns.get(c).matchSearch(this.tableData.get(i), p)) {
                    return this.tableData.get(i);
                }
                ++c;
            }
            ++i;
        }
        return null;
    }

    public void removeAll(ArrayList<E> selectedObjects) {
        final ArrayList<E> tmp = new ArrayList<E>(this.tableData);
        tmp.removeAll(selectedObjects);
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                ArrayList selection = ExtTableModel.this.getSelectedObjects();
                ExtTableModel.this.tableData = tmp;
                ExtTableModel.this.refreshSort();
                ExtTableModel.this.fireTableStructureChanged();
                ExtTableModel.this.setSelectedObjects(selection);
                return null;
            }
        }.start();
    }

    public void clear() {
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                ExtTableModel.this.tableData.clear();
                ExtTableModel.this.fireTableStructureChanged();
                return null;
            }
        }.start();
    }

    public int size() {
        return this.tableData.size();
    }

    public E getElementAt(int i) {
        return this.tableData.get(i);
    }

    public boolean contains(E at) {
        return this.tableData.contains(at);
    }

    public void addElement(final E at) {
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                ArrayList selection = ExtTableModel.this.getSelectedObjects();
                ExtTableModel.this.tableData.add(at);
                ExtTableModel.this.refreshSort();
                ExtTableModel.this.fireTableStructureChanged();
                ExtTableModel.this.setSelectedObjects(selection);
                return null;
            }
        }.start();
    }

    public void addAllElements(ArrayList<E> files) {
        final ArrayList<E> tmp = new ArrayList<E>(files);
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                ArrayList selection = ExtTableModel.this.getSelectedObjects();
                ExtTableModel.this.tableData.addAll(tmp);
                ExtTableModel.this.refreshSort();
                ExtTableModel.this.fireTableStructureChanged();
                ExtTableModel.this.setSelectedObjects(selection);
                return null;
            }
        }.start();
    }

    public ArrayList<E> getElements() {
        return new ArrayList<E>(this.tableData);
    }
}

