/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.table.columns;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.appwork.utils.swing.table.ExtColumn;
import org.appwork.utils.swing.table.ExtDefaultRowSorter;
import org.appwork.utils.swing.table.ExtTableModel;

public abstract class ExtComboColumn<E>
extends ExtColumn<E>
implements ActionListener {
    private static final long serialVersionUID = 2114805529462086691L;
    private JComboBox comboBoxRend;
    private JComboBox comboBoxEdit;
    private int selection;
    protected DefaultListCellRenderer renderer;
    private ComboBoxModel dataModel;

    public ExtComboColumn(String name, ExtTableModel<E> table, ComboBoxModel model) {
        super(name, table);
        if (model == null) {
            model = new DefaultComboBoxModel();
        }
        this.dataModel = model;
        this.comboBoxRend = new JComboBox(this.dataModel){
            private static final long serialVersionUID = -7223814300276557968L;

            @Override
            public void addActionListener(ActionListener l) {
                this.listenerList.add(ActionListener.class, l);
            }
        };
        this.comboBoxEdit = new JComboBox(this.dataModel);
        this.comboBoxEdit.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        this.comboBoxRend.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                if (ExtComboColumn.this.getComboBoxItem(o1) == ExtComboColumn.this.getComboBoxItem(o2)) {
                    return 0;
                }
                if (this.isSortOrderToggle()) {
                    return ExtComboColumn.this.getComboBoxItem(o1) > ExtComboColumn.this.getComboBoxItem(o2) ? 1 : -1;
                }
                return ExtComboColumn.this.getComboBoxItem(o2) > ExtComboColumn.this.getComboBoxItem(o1) ? 1 : -1;
            }
        });
    }

    public void setRenderer() {
        this.comboBoxRend.setRenderer(this.renderer);
        this.comboBoxEdit.setRenderer(this.renderer);
    }

    protected abstract int getComboBoxItem(E var1);

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.selection = this.getComboBoxItem(value);
        if (this.selection < 0) {
            return super.getTableCellRendererComponent(table, "", false, hasFocus, row, column);
        }
        this.comboBoxRend.setModel(this.updateModel(this.dataModel, value));
        this.comboBoxEdit.removeActionListener(this);
        this.comboBoxEdit.setToolTipText(this.getTooltip(value));
        this.comboBoxRend.setSelectedIndex(this.getComboBoxItem(value));
        this.comboBoxEdit.addActionListener(this);
        this.comboBoxRend.setEnabled(this.isEnabled(value));
        return this.comboBoxRend;
    }

    public ComboBoxModel updateModel(ComboBoxModel dataModel, Object value) {
        return dataModel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.selection = this.getComboBoxItem(value);
        if (this.selection < 0) {
            return super.getTableCellEditorComponent(table, "", false, row, column);
        }
        this.comboBoxEdit.setModel(this.updateModel(this.dataModel, value));
        this.comboBoxEdit.removeActionListener(this);
        this.comboBoxEdit.setToolTipText(this.getTooltip(value));
        this.comboBoxEdit.setSelectedIndex(this.selection);
        this.comboBoxEdit.addActionListener(this);
        this.comboBoxEdit.setEnabled(this.isEnabled(value));
        return this.comboBoxEdit;
    }

    public String getTooltip(Object value) {
        return null;
    }

    @Override
    public void setValue(Object value, Object object) {
    }

    @Override
    public boolean isEnabled(Object obj) {
        return true;
    }

    @Override
    public boolean isSortable(Object obj) {
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.comboBoxEdit.getSelectedIndex();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.comboBoxEdit.removeActionListener(this);
        this.stopCellEditing();
    }
}

