/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.table.columns;

import java.awt.Component;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import org.appwork.utils.swing.table.ExtColumn;
import org.appwork.utils.swing.table.ExtDefaultRowSorter;
import org.appwork.utils.swing.table.ExtTableModel;

public abstract class ExtProgressColumn<E>
extends ExtColumn<E> {
    private static final long serialVersionUID = -2473320164484034664L;
    protected JProgressBar bar = new JProgressBar(0, this.getMax());

    public ExtProgressColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.bar.setOpaque(false);
        this.bar.setStringPainted(true);
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                if (ExtProgressColumn.this.getValue(o1) == ExtProgressColumn.this.getValue(o2)) {
                    return 0;
                }
                if (this.isSortOrderToggle()) {
                    return ExtProgressColumn.this.getValue(o1) > ExtProgressColumn.this.getValue(o2) ? -1 : 1;
                }
                return ExtProgressColumn.this.getValue(o1) < ExtProgressColumn.this.getValue(o2) ? -1 : 1;
            }
        });
    }

    protected int getMax() {
        return 100;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public void setValue(Object value, E object) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.bar.setIndeterminate(false);
        this.bar.setValue(this.getValue(value));
        this.bar.setString(this.getString(value));
        if (isSelected) {
            this.bar.setForeground(this.getModel().getTable().getColumnForegroundSelected());
            this.bar.setBackground(this.getModel().getTable().getColumnBackgroundSelected());
        } else {
            this.bar.setForeground(this.getModel().getTable().getColumnForeground());
            this.bar.setBackground(this.getModel().getTable().getColumnBackground());
        }
        this.bar.setOpaque(true);
        this.bar.setEnabled(this.isEnabled(value));
        return this.bar;
    }

    protected abstract int getValue(E var1);

    protected abstract String getString(E var1);
}

