/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.appwork.utils.zip.ZipIOException;
import org.appwork.utils.zip.ZipIOFile;

public class ZipIOReader {
    private File zipFile = null;
    private ZipFile zip = null;
    private ZipIOFile rootFS = null;

    public ZipIOReader(File zipFile) throws ZipIOException, ZipException, IOException {
        this.zipFile = zipFile;
        this.openZip();
    }

    private synchronized void openZip() throws ZipIOException, ZipException, IOException {
        if (this.zip != null) {
            return;
        }
        if (this.zipFile == null || this.zipFile.isDirectory() || !this.zipFile.exists()) {
            throw new ZipIOException("invalid zipFile");
        }
        this.zip = new ZipFile(this.zipFile);
    }

    public synchronized void close() throws IOException {
        try {
            if (this.zip != null) {
                this.zip.close();
            }
        }
        finally {
            this.zip = null;
        }
    }

    public synchronized ZipEntry[] getZipFiles() throws ZipIOException {
        ArrayList<ZipEntry> ret = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> zipIter = this.zip.entries();
        while (zipIter.hasMoreElements()) {
            ret.add(zipIter.nextElement());
        }
        return ret.toArray(new ZipEntry[ret.size()]);
    }

    public synchronized int size() throws ZipIOException {
        return this.zip.size();
    }

    public synchronized InputStream getInputStream(ZipEntry entry) throws ZipIOException, IOException {
        if (entry == null) {
            throw new ZipIOException("invalid zipEntry");
        }
        return this.zip.getInputStream(entry);
    }

    public synchronized void extractTo(File outputDirectory) throws ZipIOException, IOException {
        if (outputDirectory.exists() && outputDirectory.isFile()) {
            throw new IOException("cannot extract to a file " + outputDirectory);
        }
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new IOException("could not create outputDirectory " + outputDirectory);
        }
        ZipEntry[] zipEntryArray = this.getZipFiles();
        int n = zipEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZipEntry entry = zipEntryArray[n2];
            File out = new File(outputDirectory, entry.getName());
            if (entry.isDirectory()) {
                if (!out.mkdir()) {
                    throw new IOException("could not create outputDirectory " + out);
                }
            } else {
                this.extract(entry, out);
            }
            ++n2;
        }
    }

    public synchronized void extract(ZipEntry entry, File output) throws ZipIOException, IOException {
        if (entry.isDirectory()) {
            throw new ZipIOException("Cannot extract a directory", entry);
        }
        if (output.exists() && output.isDirectory()) {
            throw new IOException("Cannot extract File to Directory " + output);
        }
        if (output.exists() && !output.delete()) {
            throw new IOException("Cannot overwrite File " + output);
        }
        if (!output.getParentFile().exists() && !output.mkdirs()) {
            throw new IOException("Cannot create File " + output);
        }
        FileOutputStream stream = null;
        FilterInputStream in = null;
        try {
            stream = new FileOutputStream(output);
            in = new CheckedInputStream(this.getInputStream(entry), new CRC32());
            byte[] buffer = new byte[Short.MAX_VALUE];
            int len = 0;
            while ((len = in.read(buffer)) != -1) {
                stream.write(buffer, 0, len);
            }
            if (entry.getCrc() != -1L && entry.getCrc() != ((CheckedInputStream)in).getChecksum().getValue()) {
                throw new ZipIOException("CRC32 Failed", entry);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized ZipEntry getZipFile(String fileName) throws ZipIOException {
        if (fileName == null) {
            throw new ZipIOException("invalid fileName");
        }
        return this.zip.getEntry(fileName);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public synchronized ZipIOFile getZipIOFileSystem() throws ZipIOException {
        if (this.rootFS != null) {
            return this.rootFS;
        }
        ZipEntry[] content = this.getZipFiles();
        ArrayList<ZipIOFile> root = new ArrayList<ZipIOFile>();
        ZipEntry[] zipEntryArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            ZipEntry file = zipEntryArray[n2];
            if (!file.isDirectory() && !file.getName().contains("/")) {
                ZipIOFile tmp = new ZipIOFile(file.getName(), file, this, null);
                root.add(tmp);
            } else if (!file.isDirectory()) {
                String[] parts = file.getName().split("/");
                ZipIOFile currentParent = null;
                String path = "";
                int i = 0;
                while (i < parts.length) {
                    if (i == parts.length - 1) {
                        ZipIOFile tmp = new ZipIOFile(parts[i], file, this, currentParent);
                        currentParent.getFilesInternal().add(tmp);
                    } else {
                        path = String.valueOf(path) + parts[i] + "/";
                        ZipIOFile found = null;
                        for (ZipIOFile tmp : root) {
                            found = this.getFolder(path, tmp);
                            if (found != null) break;
                        }
                        if (found != null) {
                            currentParent = found;
                        } else {
                            ZipIOFile newFolder = new ZipIOFile(parts[i], null, this, currentParent);
                            if (currentParent != null) {
                                currentParent.getFilesInternal().add(newFolder);
                            } else {
                                root.add(newFolder);
                            }
                            currentParent = newFolder;
                        }
                    }
                    ++i;
                }
            }
            ++n2;
        }
        this.rootFS = new ZipIOFile("", null, this, null);
        this.rootFS.getFilesInternal().addAll(root);
        this.rootFS.getFilesInternal().trimToSize();
        this.trimZipIOFiles(this.rootFS);
        return this.rootFS;
    }

    private void trimZipIOFiles(ZipIOFile root) {
        if (root == null) {
            return;
        }
        ZipIOFile[] zipIOFileArray = root.getFiles();
        int n = zipIOFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZipIOFile tmp = zipIOFileArray[n2];
            if (tmp.isDirectory()) {
                this.trimZipIOFiles(tmp);
            }
            ++n2;
        }
        root.getFilesInternal().trimToSize();
    }

    private ZipIOFile getFolder(String path, ZipIOFile currentRoot) {
        if (path == null || currentRoot == null || !currentRoot.isDirectory()) {
            return null;
        }
        if (currentRoot.getAbsolutePath().equalsIgnoreCase(path)) {
            return currentRoot;
        }
        ZipIOFile[] zipIOFileArray = currentRoot.getFiles();
        int n = zipIOFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZipIOFile ret;
            ZipIOFile tmp = zipIOFileArray[n2];
            if (tmp.isDirectory() && tmp.getAbsolutePath().equalsIgnoreCase(path)) {
                return tmp;
            }
            if (tmp.isDirectory() && (ret = this.getFolder(path, tmp)) != null) {
                return ret;
            }
            ++n2;
        }
        return null;
    }
}

