/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.DocumentNotificationListener;
import org.lobobrowser.html.domimpl.ElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.gui.DocumentNotification;
import org.lobobrowser.html.gui.FrameSetPanel;
import org.lobobrowser.html.gui.HtmlBlockPanel;
import org.lobobrowser.html.gui.SelectionChangeEvent;
import org.lobobrowser.html.gui.SelectionChangeListener;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.NodeRenderer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.util.EventDispatch2;
import org.lobobrowser.util.gui.WrapperLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html2.HTMLFrameSetElement;
import org.xml.sax.SAXException;

public class HtmlPanel
extends JComponent
implements FrameContext {
    private final EventDispatch2 selectionDispatch = new SelectionDispatch();
    private final Timer notificationTimer;
    private final DocumentNotificationListener notificationListener;
    private final Runnable notificationImmediateAction;
    private static final int NOTIF_TIMER_DELAY = 300;
    private volatile boolean isFrameSet = false;
    private volatile NodeRenderer nodeRenderer = null;
    private volatile NodeImpl rootNode;
    private volatile int preferredWidth = -1;
    private volatile Insets defaultMarginInsets = new Insets(8, 8, 8, 8);
    private volatile int defaultOverflowX = 2;
    private volatile int defaultOverflowY = 1;
    protected volatile HtmlBlockPanel htmlBlockPanel;
    protected volatile FrameSetPanel frameSetPanel;
    private ArrayList notifications = new ArrayList(1);

    public HtmlPanel() {
        this.setLayout(WrapperLayout.getInstance());
        this.setOpaque(false);
        this.notificationTimer = new Timer(300, new NotificationTimerAction());
        this.notificationTimer.setRepeats(false);
        this.notificationListener = new LocalDocumentNotificationListener();
        this.notificationImmediateAction = new Runnable(){

            @Override
            public void run() {
                HtmlPanel.this.processNotifications();
            }
        };
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
        HtmlBlockPanel htmlBlock = this.htmlBlockPanel;
        if (htmlBlock != null) {
            htmlBlock.setPreferredWidth(width);
        }
    }

    public void scrollTo(Rectangle bounds, boolean xIfNeeded, boolean yIfNeeded) {
        HtmlBlockPanel htmlBlock = this.htmlBlockPanel;
        if (htmlBlock != null) {
            htmlBlock.scrollTo(bounds, xIfNeeded, yIfNeeded);
        }
    }

    public void scrollTo(Node node) {
        HtmlBlockPanel htmlBlock = this.htmlBlockPanel;
        if (htmlBlock != null) {
            htmlBlock.scrollTo(node);
        }
    }

    public BoundableRenderable getBlockRenderable() {
        HtmlBlockPanel htmlBlock = this.htmlBlockPanel;
        return htmlBlock == null ? null : htmlBlock.getRootRenderable();
    }

    public FrameSetPanel getFrameSetPanel() {
        int componentCount = this.getComponentCount();
        if (componentCount == 0) {
            return null;
        }
        Component c = this.getComponent(0);
        if (c instanceof FrameSetPanel) {
            return (FrameSetPanel)c;
        }
        return null;
    }

    private void setUpAsBlock(UserAgentContext ucontext, HtmlRendererContext rcontext) {
        HtmlBlockPanel shp = this.createHtmlBlockPanel(ucontext, rcontext);
        shp.setPreferredWidth(this.preferredWidth);
        shp.setDefaultMarginInsets(this.defaultMarginInsets);
        shp.setDefaultOverflowX(this.defaultOverflowX);
        shp.setDefaultOverflowY(this.defaultOverflowY);
        this.htmlBlockPanel = shp;
        this.frameSetPanel = null;
        this.removeAll();
        this.add(shp);
        this.nodeRenderer = shp;
    }

    private void setUpFrameSet(NodeImpl fsrn) {
        FrameSetPanel fsp;
        this.isFrameSet = true;
        this.htmlBlockPanel = null;
        this.frameSetPanel = fsp = this.createFrameSetPanel();
        this.nodeRenderer = fsp;
        this.removeAll();
        this.add(fsp);
        fsp.setRootNode(fsrn);
    }

    protected HtmlBlockPanel createHtmlBlockPanel(UserAgentContext ucontext, HtmlRendererContext rcontext) {
        return new HtmlBlockPanel(Color.WHITE, true, ucontext, rcontext, this);
    }

    protected FrameSetPanel createFrameSetPanel() {
        return new FrameSetPanel();
    }

    public void scroll(final int x, final int y) {
        if (EventQueue.isDispatchThread()) {
            this.scrollImpl(x, y);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPanel.this.scrollImpl(x, y);
                }
            });
        }
    }

    public void scrollBy(final int x, final int y) {
        if (EventQueue.isDispatchThread()) {
            this.scrollByImpl(x, y);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPanel.this.scrollByImpl(x, y);
                }
            });
        }
    }

    private void scrollImpl(int x, int y) {
        this.scrollTo(new Rectangle(x, y, 16, 16), false, false);
    }

    private void scrollByImpl(int xOffset, int yOffset) {
        HtmlBlockPanel bp = this.htmlBlockPanel;
        if (bp != null) {
            bp.scrollBy(xOffset, yOffset);
        }
    }

    public void clearDocument() {
        if (EventQueue.isDispatchThread()) {
            this.clearDocumentImpl();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPanel.this.clearDocumentImpl();
                }
            });
        }
    }

    private void clearDocumentImpl() {
        NodeRenderer nr;
        HTMLDocumentImpl prevDocument = (HTMLDocumentImpl)this.rootNode;
        if (prevDocument != null) {
            prevDocument.removeDocumentNotificationListener(this.notificationListener);
        }
        if ((nr = this.nodeRenderer) != null) {
            nr.setRootNode(null);
        }
        this.rootNode = null;
        this.htmlBlockPanel = null;
        this.nodeRenderer = null;
        this.isFrameSet = false;
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    public void setDocument(final Document node, final HtmlRendererContext rcontext) {
        if (EventQueue.isDispatchThread()) {
            this.setDocumentImpl(node, rcontext);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPanel.this.setDocumentImpl(node, rcontext);
                }
            });
        }
    }

    public void scrollToElement(final String nameOrId) {
        if (EventQueue.isDispatchThread()) {
            this.scrollToElementImpl(nameOrId);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlPanel.this.scrollToElementImpl(nameOrId);
                }
            });
        }
    }

    private void scrollToElementImpl(String nameOrId) {
        HTMLDocumentImpl doc;
        Element element;
        NodeImpl node = this.rootNode;
        if (node instanceof HTMLDocumentImpl && (element = (doc = (HTMLDocumentImpl)node).getElementById(nameOrId)) != null) {
            this.scrollTo(element);
        }
    }

    private void setDocumentImpl(Document node, HtmlRendererContext rcontext) {
        NodeRenderer nr;
        boolean newIfs;
        if (!(node instanceof HTMLDocumentImpl)) {
            throw new IllegalArgumentException("Only nodes of type HTMLDocumentImpl are currently supported. Use DocumentBuilderImpl.");
        }
        HTMLDocumentImpl prevDocument = (HTMLDocumentImpl)this.rootNode;
        if (prevDocument != null) {
            prevDocument.removeDocumentNotificationListener(this.notificationListener);
        }
        HTMLDocumentImpl nodeImpl = (HTMLDocumentImpl)node;
        nodeImpl.addDocumentNotificationListener(this.notificationListener);
        this.rootNode = nodeImpl;
        NodeImpl fsrn = this.getFrameSetRootNode(nodeImpl);
        boolean bl = newIfs = fsrn != null;
        if (newIfs != this.isFrameSet || this.getComponentCount() == 0) {
            this.isFrameSet = newIfs;
            if (newIfs) {
                this.setUpFrameSet(fsrn);
            } else {
                this.setUpAsBlock(rcontext.getUserAgentContext(), rcontext);
            }
        }
        if ((nr = this.nodeRenderer) != null) {
            if (newIfs) {
                nr.setRootNode(fsrn);
            } else {
                nr.setRootNode(nodeImpl);
            }
        } else {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void setHtml(String htmlSource, String uri, HtmlRendererContext rcontext) {
        try {
            DocumentBuilderImpl builder = new DocumentBuilderImpl(rcontext.getUserAgentContext(), rcontext);
            StringReader reader = new StringReader(htmlSource);
            try {
                InputSourceImpl is = new InputSourceImpl(reader, uri);
                Document document = builder.parse(is);
                this.setDocument(document, rcontext);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected condition.", ioe);
        }
        catch (SAXException se) {
            throw new IllegalStateException("Unexpected condition.", se);
        }
    }

    public NodeImpl getRootNode() {
        return this.rootNode;
    }

    private boolean resetIfFrameSet() {
        boolean newIfs;
        NodeImpl nodeImpl = this.rootNode;
        NodeImpl fsrn = this.getFrameSetRootNode(nodeImpl);
        boolean bl = newIfs = fsrn != null;
        if (newIfs != this.isFrameSet || this.getComponentCount() == 0) {
            this.isFrameSet = newIfs;
            if (newIfs) {
                this.setUpFrameSet(fsrn);
                NodeRenderer nr = this.nodeRenderer;
                nr.setRootNode(fsrn);
                this.validate();
                this.repaint();
                return true;
            }
        }
        return false;
    }

    private NodeImpl getFrameSetRootNode(NodeImpl node) {
        if (node instanceof Document) {
            ElementImpl element = (ElementImpl)((Document)((Object)node)).getDocumentElement();
            if (element != null && "HTML".equalsIgnoreCase(element.getTagName())) {
                return this.getFrameSet(element);
            }
            return this.getFrameSet(node);
        }
        return null;
    }

    private NodeImpl getFrameSet(NodeImpl node) {
        NodeImpl[] children = node.getChildrenArray();
        if (children == null) {
            return null;
        }
        int length = children.length;
        NodeImpl frameSet = null;
        int i = 0;
        while (i < length) {
            String tagName;
            NodeImpl child = children[i];
            if (!(child instanceof Text || !(child instanceof ElementImpl) || "HEAD".equalsIgnoreCase(tagName = child.getNodeName()) || "NOFRAMES".equalsIgnoreCase(tagName) || "TITLE".equalsIgnoreCase(tagName) || "META".equalsIgnoreCase(tagName) || "SCRIPT".equalsIgnoreCase(tagName) || "NOSCRIPT".equalsIgnoreCase(tagName))) {
                if ("FRAMESET".equalsIgnoreCase(tagName)) {
                    frameSet = child;
                    break;
                }
                if (this.hasSomeHtml((ElementImpl)child)) {
                    return null;
                }
            }
            ++i;
        }
        return frameSet;
    }

    private boolean hasSomeHtml(ElementImpl element) {
        String tagName = element.getTagName();
        if ("HEAD".equalsIgnoreCase(tagName) || "TITLE".equalsIgnoreCase(tagName) || "META".equalsIgnoreCase(tagName)) {
            return false;
        }
        NodeImpl[] children = element.getChildrenArray();
        if (children != null) {
            int length = children.length;
            int i = 0;
            while (i < length) {
                String textContent;
                NodeImpl child = children[i];
                if (child instanceof Text ? (textContent = ((Text)((Object)child)).getTextContent()) != null && !"".equals(textContent.trim()) : child instanceof ElementImpl && this.hasSomeHtml((ElementImpl)child)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public void expandSelection(RenderableSpot rpoint) {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            block.setSelectionEnd(rpoint);
            block.repaint();
            this.selectionDispatch.fireEvent(new SelectionChangeEvent(this, block.isSelectionAvailable()));
        }
    }

    @Override
    public void resetSelection(RenderableSpot rpoint) {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            block.setSelectionStart(rpoint);
            block.setSelectionEnd(rpoint);
            block.repaint();
        }
        this.selectionDispatch.fireEvent(new SelectionChangeEvent(this, false));
    }

    public String getSelectionText() {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block == null) {
            return null;
        }
        return block.getSelectionText();
    }

    public Node getSelectionNode() {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block == null) {
            return null;
        }
        return block.getSelectionNode();
    }

    public boolean hasSelection() {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block == null) {
            return false;
        }
        return block.hasSelection();
    }

    public boolean copy() {
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            return block.copy();
        }
        return false;
    }

    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionDispatch.addListener(listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionDispatch.removeListener(listener);
    }

    public void setDefaultMarginInsets(Insets insets) {
        this.defaultMarginInsets = insets;
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            block.setDefaultMarginInsets(insets);
        }
    }

    public void setDefaultOverflowX(int overflow) {
        this.defaultOverflowX = overflow;
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            block.setDefaultOverflowX(overflow);
        }
    }

    public void setDefaultOverflowY(int overflow) {
        this.defaultOverflowY = overflow;
        HtmlBlockPanel block = this.htmlBlockPanel;
        if (block != null) {
            block.setDefaultOverflowY(overflow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotification(DocumentNotification notification) {
        ArrayList notifs;
        ArrayList arrayList = notifs = this.notifications;
        synchronized (arrayList) {
            notifs.add(notification);
        }
        if (EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(this.notificationImmediateAction);
        } else {
            this.notificationTimer.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delayedRelayout(NodeImpl node) {
        ArrayList notifs;
        ArrayList arrayList = notifs = this.notifications;
        synchronized (arrayList) {
            notifs.add(new DocumentNotification(2, node));
        }
        this.notificationTimer.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotifications() {
        FrameSetPanel frameSetPanel;
        DocumentNotification[] notifsArray;
        ArrayList notifs;
        ArrayList arrayList = notifs = this.notifications;
        synchronized (arrayList) {
            int size = notifs.size();
            if (size == 0) {
                return;
            }
            notifsArray = new DocumentNotification[size];
            notifsArray = notifs.toArray(notifsArray);
            notifs.clear();
        }
        int length = notifsArray.length;
        int i = 0;
        while (i < length) {
            DocumentNotification dn = notifsArray[i];
            if (dn.node instanceof HTMLFrameSetElement && this.htmlBlockPanel != null && this.resetIfFrameSet()) {
                return;
            }
            ++i;
        }
        HtmlBlockPanel blockPanel = this.htmlBlockPanel;
        if (blockPanel != null) {
            blockPanel.processDocumentNotifications(notifsArray);
        }
        if ((frameSetPanel = this.frameSetPanel) != null) {
            frameSetPanel.processDocumentNotifications(notifsArray);
        }
    }

    private class LocalDocumentNotificationListener
    implements DocumentNotificationListener {
        private LocalDocumentNotificationListener() {
        }

        @Override
        public void allInvalidated() {
            HtmlPanel.this.addNotification(new DocumentNotification(3, null));
        }

        @Override
        public void invalidated(NodeImpl node) {
            HtmlPanel.this.addNotification(new DocumentNotification(3, node));
        }

        @Override
        public void lookInvalidated(NodeImpl node) {
            HtmlPanel.this.addNotification(new DocumentNotification(0, node));
        }

        @Override
        public void positionInvalidated(NodeImpl node) {
            HtmlPanel.this.addNotification(new DocumentNotification(1, node));
        }

        @Override
        public void sizeInvalidated(NodeImpl node) {
            HtmlPanel.this.addNotification(new DocumentNotification(2, node));
        }

        @Override
        public void externalScriptLoading(NodeImpl node) {
        }

        @Override
        public void nodeLoaded(NodeImpl node) {
            HtmlPanel.this.addNotification(new DocumentNotification(3, node));
        }

        @Override
        public void structureInvalidated(NodeImpl node) {
            HtmlPanel.this.addNotification(new DocumentNotification(3, node));
        }
    }

    private class NotificationTimerAction
    implements ActionListener {
        private NotificationTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HtmlPanel.this.processNotifications();
        }
    }

    private class SelectionDispatch
    extends EventDispatch2 {
        private SelectionDispatch() {
        }

        @Override
        protected void dispatchEvent(EventListener listener, EventObject event) {
            ((SelectionChangeListener)listener).selectionChanged((SelectionChangeEvent)event);
        }
    }
}

