/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.schedule;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.plugins.optional.schedule.Actions;
import jd.plugins.optional.schedule.AddGui;
import jd.plugins.optional.schedule.Schedule;
import jd.plugins.optional.schedule.SchedulerTable;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;

public class MainGui
extends SwitchPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 3439995751143746593L;
    private static final String JDL_PREFIX = "jd.plugins.optional.schedule.MainGui.";
    private Schedule schedule;
    private SchedulerTable table;
    private JButton add;
    private JButton delete;
    private JButton edit;
    private JTabbedPane tabs;

    public MainGui(Schedule schedule) {
        this.schedule = schedule;
        this.tabs = new JTabbedPane();
        this.table = new SchedulerTable(schedule);
        this.table.addMouseListener(this);
        this.add = new JButton("+");
        this.add.addActionListener(this);
        this.delete = new JButton("-");
        this.delete.addActionListener(this);
        this.delete.setEnabled(false);
        this.edit = new JButton(JDL.L((String)"jd.plugins.optional.schedule.MainGui.edit", (String)"Edit"));
        this.edit.addActionListener(this);
        this.edit.setEnabled(false);
        JPanel buttons = new JPanel();
        buttons.add(this.add);
        buttons.add(this.delete);
        buttons.add(this.edit);
        JPanel p = new JPanel((LayoutManager)new MigLayout("ins 5,wrap 1", "[fill,grow]", "[fill,grow][]"));
        p.add(new JScrollPane((Component)((Object)this.table)));
        p.add(buttons);
        this.tabs.addTab("Main", p);
        this.setLayout((LayoutManager)new MigLayout("ins 5,wrap 1", "[fill,grow]", "[fill,grow][]"));
        this.add(this.tabs);
        this.table.getModel().fireTableDataChanged();
    }

    public void updateActions(Component p) {
        this.table.getModel().fireTableDataChanged();
        this.schedule.saveActions();
        if (p != null) {
            this.removeTab(p);
        }
        this.schedule.updateTable();
    }

    public void removeTab(Component p) {
        int i = 0;
        while (i < this.tabs.getTabCount()) {
            if (this.tabs.getComponentAt(i) == p) {
                this.tabs.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removeTab(Actions e) {
        int i = 0;
        while (i < this.tabs.getTabCount()) {
            if (this.tabs.getComponentAt(i) instanceof AddGui && ((AddGui)this.tabs.getComponentAt(i)).getAction() == e) {
                this.tabs.remove(i);
                return;
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.add) {
            this.tabs.addTab("Schedule Plan", new AddGui(this.schedule, this, new Actions("Schedule Plan"), false));
            this.tabs.setSelectedIndex(this.tabs.getTabCount() - 1);
        } else if (e.getSource() == this.delete) {
            if (this.table.getSelectedRow() < 0) {
                return;
            }
            this.removeTab(this.schedule.getActions().get(this.table.getSelectedRow()));
            this.schedule.removeAction(this.table.getSelectedRow());
            this.table.getModel().fireTableDataChanged();
            this.updateButtons();
        } else if (e.getSource() == this.edit) {
            if (this.table.getSelectedRow() < 0) {
                return;
            }
            Actions a = this.schedule.getActions().get(this.table.getSelectedRow());
            int i = 0;
            while (i < this.tabs.getTabCount()) {
                if (this.tabs.getComponentAt(i) instanceof AddGui && ((AddGui)this.tabs.getComponentAt(i)).getAction() == a) {
                    this.tabs.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
            this.tabs.addTab(a.getName(), new AddGui(this.schedule, this, a, true));
            this.tabs.setSelectedIndex(this.tabs.getTabCount() - 1);
        }
    }

    public void changeTabText(Actions e, String newText) {
        int i = 0;
        while (i < this.tabs.getTabCount()) {
            if (this.tabs.getComponentAt(i) instanceof AddGui && ((AddGui)this.tabs.getComponentAt(i)).getAction() == e) {
                this.tabs.setTitleAt(i, newText);
                return;
            }
            ++i;
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.updateButtons();
    }

    private void updateButtons() {
        boolean b = this.table.getSelectedRow() >= 0;
        this.delete.setEnabled(b);
        this.edit.setEnabled(b);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    protected void onHide() {
    }

    protected void onShow() {
        this.table.getModel().refreshModel();
    }

    public void updateTable() {
        this.table.getModel().refreshModel();
        this.table.getModel().fireTableDataChanged();
    }
}

