/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.flv;

import de.savemytube.avi.AVIWriter;
import de.savemytube.avi.Framerate;
import de.savemytube.avi.FramerateCalculator;
import de.savemytube.flv.ByteData;
import de.savemytube.flv.FLVTag;
import de.savemytube.flv.FLVTagAudio;
import de.savemytube.flv.FLVTagVideo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;

public class FLV {
    private String filename;
    private boolean video = false;
    private boolean audio = false;
    private byte version;
    private String signature;
    private int offset;
    private ArrayList tagsAudio = new ArrayList();
    private ArrayList videoTimeStamps = new ArrayList();
    boolean debug = false;
    private AVIWriter aviWriter;
    private boolean extract_audio;
    private boolean extract_video;

    public FLV() {
    }

    public FLV(String filename, boolean extract_audio, boolean extract_video) {
        this.filename = filename;
        this.extract_audio = extract_audio;
        this.extract_video = extract_video;
        this.read();
    }

    private void read() {
        try {
            File file = new File(this.filename);
            long size = file.length();
            FileChannel channel = new FileInputStream(this.filename).getChannel();
            ByteData byteData = this.read(channel, 9);
            ByteBuffer buf = byteData.getByteBuffer();
            this.signature = new String(this.getBytes(buf, 0, 3));
            this.version = this.getBytes(buf, 4, 1)[0];
            byte audio_video = this.getBytes(buf, 5, 1)[0];
            if ((audio_video & 4) == 4) {
                this.audio = true;
            }
            if ((audio_video & 1) == 1) {
                this.video = true;
            }
            byte[] bOffset = this.getBytes(buf, 6, 4);
            this.offset = FLV.getInt(bOffset);
            this.read(channel, 3);
            this.readTags(channel);
            channel.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readTags(ReadableByteChannel channel) throws Exception {
        ByteData byteData = this.read(channel, 1);
        ByteBuffer buf = byteData.getByteBuffer();
        byte bFLVStream = this.getBytes(buf, 0, 1)[0];
        int counterAudio = 0;
        int counterVideo = 0;
        while (byteData != null && !byteData.isEof()) {
            byteData = this.read(channel, 11);
            buf = byteData.getByteBuffer();
            byte type = this.getBytes(buf, 0, 1)[0];
            int bodyLength = FLV.getInt(this.getBytes(buf, 1, 3));
            int timestamp = FLV.getInt(this.getBytes(buf, 4, 3));
            byte timestampExt = this.getBytes(buf, 7, 1)[0];
            int streamId = FLV.getInt(this.getBytes(buf, 8, 3));
            timestamp |= timestampExt << 24;
            FLVTagAudio tag = null;
            switch (type) {
                case 8: {
                    if (!this.extract_audio) break;
                    tag = new FLVTagAudio(type, bodyLength, timestamp, timestampExt, streamId);
                    ((FLVTag)tag).read(channel);
                    ++counterAudio;
                    this.tagsAudio.add(tag);
                    break;
                }
                case 9: {
                    if (!this.extract_video) break;
                    FLVTagVideo tagVideo = new FLVTagVideo(type, bodyLength, timestamp, timestampExt, streamId);
                    tagVideo.read(channel);
                    AVIWriter aw = this.getAVIWriter(String.valueOf(this.filename.substring(0, this.filename.length() - 4)) + ".avi", tagVideo.getCodecID());
                    aw.writeChunk(tagVideo.getBody(), timestamp, tagVideo.getFrameType());
                    this.videoTimeStamps.add(new Long(timestamp));
                    ++counterVideo;
                    break;
                }
                default: {
                    byteData = this.read(channel, bodyLength);
                }
            }
            this.read(channel, 4);
        }
        if (this.audio) {
            this.writeAudioFile(String.valueOf(this.filename.substring(0, this.filename.length() - 4)) + ".mp3", this.tagsAudio);
        }
        if (this.video) {
            Framerate framerate = FramerateCalculator.calculateTrueFrameRate(this.videoTimeStamps);
            this.getAVIWriter("", 0).finish(framerate);
        }
    }

    public ByteData read(ReadableByteChannel channel, int bytes) throws IOException {
        if (bytes == 0) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(bytes);
        buf.rewind();
        int eof = channel.read(buf);
        if (buf != null) {
            buf.rewind();
        }
        if (this.debug) {
            byte[] byArray = this.getBytes(buf);
        }
        ByteData bd = new ByteData(buf, eof == -1);
        return bd;
    }

    public byte[] getBytes(ByteBuffer buf) {
        return this.getBytes(buf, 0, buf.capacity());
    }

    public byte[] getBytes(ByteBuffer buf, int from, int len) {
        byte[] bytes = new byte[len];
        buf.get(bytes, 0, bytes.length);
        return bytes;
    }

    public static int getInt(byte[] data) {
        int number = 0;
        int i = 0;
        while (i < data.length) {
            byte b = data[data.length - 1 - i];
            int bitsToShift = i << 3;
            int add = (b & 0xFF) << bitsToShift;
            number |= add;
            ++i;
        }
        return number;
    }

    public static long arr2long(byte[] arr, int start) {
        int i = 0;
        int len = 4;
        int cnt = 0;
        byte[] tmp = new byte[len];
        i = start;
        while (i < start + len) {
            tmp[cnt] = arr[i];
            ++cnt;
            ++i;
        }
        long accum = 0L;
        i = 0;
        int shiftBy = 0;
        while (shiftBy < 32) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
            shiftBy += 8;
        }
        return accum;
    }

    public byte[] getBytes(int number) {
        byte[] data = new byte[4];
        int i = 0;
        while (i < 4) {
            int shift = i << 3;
            data[3 - i] = (byte)((number & 255 << shift) >>> shift);
            ++i;
        }
        return data;
    }

    public void writeAudioFile(String filename, ArrayList lTags) throws FileNotFoundException, IOException {
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        int i = 0;
        while (i < lTags.size()) {
            FLVTag tag = (FLVTag)lTags.get(i);
            file.write(tag.getBody());
            ++i;
        }
        file.close();
    }

    public void reverse(byte[] b) {
        int left = 0;
        int right = b.length - 1;
        while (left < right) {
            byte temp = b[left];
            b[left] = b[right];
            b[right] = temp;
            ++left;
            --right;
        }
    }

    public String toString() {
        String s = "FLVInformation - Signature:" + this.signature + " Version:" + this.version + " hasAudio:" + this.audio + " hasVideo:" + this.video + " Offset:" + this.offset;
        return s;
    }

    private AVIWriter getAVIWriter(String filename, int codec) throws Exception {
        if (this.aviWriter == null) {
            this.aviWriter = new AVIWriter(filename, codec);
        }
        return this.aviWriter;
    }
}

