/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.flv;

import de.savemytube.flv.ByteData;
import de.savemytube.flv.FLVTag;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class FLVTagAudio
extends FLVTag {
    public static final int SOUND_TYPE_MONO = 0;
    public static final int SOUND_TYPE_STEREO = 1;
    public static final int SOUND_SIZE_8BIT = 0;
    public static final int SOUND_SIZE_16BIT = 1;
    public static final int SOUND_RATE_5_5 = 0;
    public static final int SOUND_RATE_11 = 1;
    public static final int SOUND_RATE_22 = 2;
    public static final int SOUND_RATE_44 = 3;
    public static final int SOUND_FORMAT_UNCOMPRESSED = 0;
    public static final int SOUND_FORMAT_ADPCM = 1;
    public static final int SOUND_FORMAT_MP3 = 2;
    public static final int SOUND_FORMAT_NELLYMOSER_8_MONO = 5;
    public static final int SOUND_FORMAT_NELLYMOSER = 6;
    public static String[] S_TYPES = new String[]{"Mono", "Stereo"};
    public static String[] S_SIZE = new String[]{"8 Bit", "16 Bit"};
    public static String[] S_RATE = new String[]{"5.5 kHz", "11 kHz", "22 kHz", "44 kHz"};
    public static String[] S_FORMAT = new String[]{"uncompressed", "ADPCM", "Mp3", "", "", "Nellymoser 8 Bit Mono", "Nellymoser"};
    private int soundType;
    private int soundSize;
    private int soundRate;
    private int soundFormat;

    public FLVTagAudio(byte type, int bodyLength, int timestamp, byte timestampExtended, int streamId) {
        super(type, bodyLength, timestamp, timestampExtended, streamId);
    }

    public void read(ReadableByteChannel channel) throws IOException {
        ByteData bData = this.read(channel, 1);
        ByteBuffer buf = bData.getByteBuffer();
        byte b = this.getBytes(buf)[0];
        this.setInfo(b);
        this.setBodyLength(this.getBodyLength() - 1);
        bData = this.read(channel, this.getBodyLength());
        this.setBody(this.getBytes(bData.getByteBuffer()));
    }

    private void setInfo(byte b) {
        this.soundFormat = (b & 0xF0) >> 4;
        this.soundType = (b & 1) >> 0;
        this.soundSize = (b & 2) >> 1;
        this.soundRate = (b & 0xC) >> 2;
    }

    public String toString() {
        String s = "---- AudioFormat ----\n";
        s = String.valueOf(s) + super.toString() + "\n";
        s = String.valueOf(s) + S_FORMAT[this.soundFormat] + " " + S_SIZE[this.soundSize] + " " + S_TYPES[this.soundType] + " " + S_RATE[this.soundRate];
        return s;
    }
}

