/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import jd.controlling.JDLogger;
import jd.nutils.io.JDFileFilter;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDClassLoader
extends ClassLoader {
    private ClassLoader classLoaderParent;
    private Vector<File> jarFile;
    private JarFile[] jars;
    private Logger logger = JDLogger.getLogger();
    private URLClassLoader rootClassLoader;
    private String rootDir;
    private ArrayList<File> lafs;
    private static byte[] S;

    static {
        byte[] byArray = new byte[692];
        byArray[0] = 2;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 49;
        byArray[4] = 11;
        byArray[5] = 48;
        byArray[6] = 9;
        byArray[7] = 6;
        byArray[8] = 5;
        byArray[9] = 43;
        byArray[10] = 14;
        byArray[11] = 3;
        byArray[12] = 2;
        byArray[13] = 26;
        byArray[14] = 5;
        byArray[16] = 48;
        byArray[17] = 11;
        byArray[18] = 6;
        byArray[19] = 9;
        byArray[20] = 42;
        byArray[21] = -122;
        byArray[22] = 72;
        byArray[23] = -122;
        byArray[24] = -9;
        byArray[25] = 13;
        byArray[26] = 1;
        byArray[27] = 7;
        byArray[28] = 1;
        byArray[29] = -96;
        byArray[30] = -126;
        byArray[31] = 2;
        byArray[32] = -111;
        byArray[33] = 48;
        byArray[34] = -126;
        byArray[35] = 2;
        byArray[36] = -115;
        byArray[37] = 48;
        byArray[38] = -126;
        byArray[39] = 2;
        byArray[40] = 75;
        byArray[41] = 2;
        byArray[42] = 4;
        byArray[43] = 70;
        byArray[44] = -60;
        byArray[45] = 21;
        byArray[46] = -27;
        byArray[47] = 48;
        byArray[48] = 11;
        byArray[49] = 6;
        byArray[50] = 7;
        byArray[51] = 42;
        byArray[52] = -122;
        byArray[53] = 72;
        byArray[54] = -50;
        byArray[55] = 56;
        byArray[56] = 4;
        byArray[57] = 3;
        byArray[58] = 5;
        byArray[60] = 48;
        byArray[61] = 44;
        byArray[62] = 49;
        byArray[63] = 24;
        byArray[64] = 48;
        byArray[65] = 22;
        byArray[66] = 6;
        byArray[67] = 3;
        byArray[68] = 85;
        byArray[69] = 4;
        byArray[70] = 10;
        byArray[71] = 19;
        byArray[72] = 15;
        byArray[73] = 103;
        byArray[74] = 117;
        byArray[75] = 108;
        byArray[76] = 108;
        byArray[77] = 105;
        byArray[78] = 32;
        byArray[79] = 67;
        byArray[80] = 111;
        byArray[81] = 109;
        byArray[82] = 109;
        byArray[83] = 117;
        byArray[84] = 110;
        byArray[85] = 105;
        byArray[86] = 116;
        byArray[87] = 121;
        byArray[88] = 49;
        byArray[89] = 16;
        byArray[90] = 48;
        byArray[91] = 14;
        byArray[92] = 6;
        byArray[93] = 3;
        byArray[94] = 85;
        byArray[95] = 4;
        byArray[96] = 3;
        byArray[97] = 19;
        byArray[98] = 7;
        byArray[99] = 97;
        byArray[100] = 115;
        byArray[101] = 116;
        byArray[102] = 97;
        byArray[103] = 108;
        byArray[104] = 100;
        byArray[105] = 111;
        byArray[106] = 48;
        byArray[107] = 30;
        byArray[108] = 23;
        byArray[109] = 13;
        byArray[110] = 48;
        byArray[111] = 55;
        byArray[112] = 48;
        byArray[113] = 56;
        byArray[114] = 49;
        byArray[115] = 54;
        byArray[116] = 48;
        byArray[117] = 57;
        byArray[118] = 49;
        byArray[119] = 54;
        byArray[120] = 50;
        byArray[121] = 49;
        byArray[122] = 90;
        byArray[123] = 23;
        byArray[124] = 13;
        byArray[125] = 48;
        byArray[126] = 57;
        byArray[127] = 48;
        byArray[128] = 56;
        byArray[129] = 48;
        byArray[130] = 53;
        byArray[131] = 48;
        byArray[132] = 57;
        byArray[133] = 49;
        byArray[134] = 54;
        byArray[135] = 50;
        byArray[136] = 49;
        byArray[137] = 90;
        byArray[138] = 48;
        byArray[139] = 44;
        byArray[140] = 49;
        byArray[141] = 24;
        byArray[142] = 48;
        byArray[143] = 22;
        byArray[144] = 6;
        byArray[145] = 3;
        byArray[146] = 85;
        byArray[147] = 4;
        byArray[148] = 10;
        byArray[149] = 19;
        byArray[150] = 15;
        byArray[151] = 103;
        byArray[152] = 117;
        byArray[153] = 108;
        byArray[154] = 108;
        byArray[155] = 105;
        byArray[156] = 32;
        byArray[157] = 67;
        byArray[158] = 111;
        byArray[159] = 109;
        byArray[160] = 109;
        byArray[161] = 117;
        byArray[162] = 110;
        byArray[163] = 105;
        byArray[164] = 116;
        byArray[165] = 121;
        byArray[166] = 49;
        byArray[167] = 16;
        byArray[168] = 48;
        byArray[169] = 14;
        byArray[170] = 6;
        byArray[171] = 3;
        byArray[172] = 85;
        byArray[173] = 4;
        byArray[174] = 3;
        byArray[175] = 19;
        byArray[176] = 7;
        byArray[177] = 97;
        byArray[178] = 115;
        byArray[179] = 116;
        byArray[180] = 97;
        byArray[181] = 108;
        byArray[182] = 100;
        byArray[183] = 111;
        byArray[184] = 48;
        byArray[185] = -126;
        byArray[186] = 1;
        byArray[187] = -72;
        byArray[188] = 48;
        byArray[189] = -126;
        byArray[190] = 1;
        byArray[191] = 44;
        byArray[192] = 6;
        byArray[193] = 7;
        byArray[194] = 42;
        byArray[195] = -122;
        byArray[196] = 72;
        byArray[197] = -50;
        byArray[198] = 56;
        byArray[199] = 4;
        byArray[200] = 1;
        byArray[201] = 48;
        byArray[202] = -126;
        byArray[203] = 1;
        byArray[204] = 31;
        byArray[205] = 2;
        byArray[206] = -127;
        byArray[207] = -127;
        byArray[209] = -3;
        byArray[210] = 127;
        byArray[211] = 83;
        byArray[212] = -127;
        byArray[213] = 29;
        byArray[214] = 117;
        byArray[215] = 18;
        byArray[216] = 41;
        byArray[217] = 82;
        byArray[218] = -33;
        byArray[219] = 74;
        byArray[220] = -100;
        byArray[221] = 46;
        byArray[222] = -20;
        byArray[223] = -28;
        byArray[224] = -25;
        byArray[225] = -10;
        byArray[226] = 17;
        byArray[227] = -73;
        byArray[228] = 82;
        byArray[229] = 60;
        byArray[230] = -17;
        byArray[231] = 68;
        byArray[233] = -61;
        byArray[234] = 30;
        byArray[235] = 63;
        byArray[236] = -128;
        byArray[237] = -74;
        byArray[238] = 81;
        byArray[239] = 38;
        byArray[240] = 105;
        byArray[241] = 69;
        byArray[242] = 93;
        byArray[243] = 64;
        byArray[244] = 34;
        byArray[245] = 81;
        byArray[246] = -5;
        byArray[247] = 89;
        byArray[248] = 61;
        byArray[249] = -115;
        byArray[250] = 88;
        byArray[251] = -6;
        byArray[252] = -65;
        byArray[253] = -59;
        byArray[254] = -11;
        byArray[255] = -70;
        byArray[256] = 48;
        byArray[257] = -10;
        byArray[258] = -53;
        byArray[259] = -101;
        byArray[260] = 85;
        byArray[261] = 108;
        byArray[262] = -41;
        byArray[263] = -127;
        byArray[264] = 59;
        byArray[265] = -128;
        byArray[266] = 29;
        byArray[267] = 52;
        byArray[268] = 111;
        byArray[269] = -14;
        byArray[270] = 102;
        byArray[271] = 96;
        byArray[272] = -73;
        byArray[273] = 107;
        byArray[274] = -103;
        byArray[275] = 80;
        byArray[276] = -91;
        byArray[277] = -92;
        byArray[278] = -97;
        byArray[279] = -97;
        byArray[280] = -24;
        byArray[281] = 4;
        byArray[282] = 123;
        byArray[283] = 16;
        byArray[284] = 34;
        byArray[285] = -62;
        byArray[286] = 79;
        byArray[287] = -69;
        byArray[288] = -87;
        byArray[289] = -41;
        byArray[290] = -2;
        byArray[291] = -73;
        byArray[292] = -58;
        byArray[293] = 27;
        byArray[294] = -8;
        byArray[295] = 59;
        byArray[296] = 87;
        byArray[297] = -25;
        byArray[298] = -58;
        byArray[299] = -88;
        byArray[300] = -90;
        byArray[301] = 21;
        byArray[302] = 15;
        byArray[303] = 4;
        byArray[304] = -5;
        byArray[305] = -125;
        byArray[306] = -10;
        byArray[307] = -45;
        byArray[308] = -59;
        byArray[309] = 30;
        byArray[310] = -61;
        byArray[311] = 2;
        byArray[312] = 53;
        byArray[313] = 84;
        byArray[314] = 19;
        byArray[315] = 90;
        byArray[316] = 22;
        byArray[317] = -111;
        byArray[318] = 50;
        byArray[319] = -10;
        byArray[320] = 117;
        byArray[321] = -13;
        byArray[322] = -82;
        byArray[323] = 43;
        byArray[324] = 97;
        byArray[325] = -41;
        byArray[326] = 42;
        byArray[327] = -17;
        byArray[328] = -14;
        byArray[329] = 34;
        byArray[330] = 3;
        byArray[331] = 25;
        byArray[332] = -99;
        byArray[333] = -47;
        byArray[334] = 72;
        byArray[335] = 1;
        byArray[336] = -57;
        byArray[337] = 2;
        byArray[338] = 21;
        byArray[340] = -105;
        byArray[341] = 96;
        byArray[342] = 80;
        byArray[343] = -113;
        byArray[344] = 21;
        byArray[345] = 35;
        byArray[346] = 11;
        byArray[347] = -52;
        byArray[348] = -78;
        byArray[349] = -110;
        byArray[350] = -71;
        byArray[351] = -126;
        byArray[352] = -94;
        byArray[353] = -21;
        byArray[354] = -124;
        byArray[355] = 11;
        byArray[356] = -16;
        byArray[357] = 88;
        byArray[358] = 28;
        byArray[359] = -11;
        byArray[360] = 2;
        byArray[361] = -127;
        byArray[362] = -127;
        byArray[364] = -9;
        byArray[365] = -31;
        byArray[366] = -96;
        byArray[367] = -123;
        byArray[368] = -42;
        byArray[369] = -101;
        byArray[370] = 61;
        byArray[371] = -34;
        byArray[372] = -53;
        byArray[373] = -68;
        byArray[374] = -85;
        byArray[375] = 92;
        byArray[376] = 54;
        byArray[377] = -72;
        byArray[378] = 87;
        byArray[379] = -71;
        byArray[380] = 121;
        byArray[381] = -108;
        byArray[382] = -81;
        byArray[383] = -69;
        byArray[384] = -6;
        byArray[385] = 58;
        byArray[386] = -22;
        byArray[387] = -126;
        byArray[388] = -7;
        byArray[389] = 87;
        byArray[390] = 76;
        byArray[391] = 11;
        byArray[392] = 61;
        byArray[393] = 7;
        byArray[394] = -126;
        byArray[395] = 103;
        byArray[396] = 81;
        byArray[397] = 89;
        byArray[398] = 87;
        byArray[399] = -114;
        byArray[400] = -70;
        byArray[401] = -44;
        byArray[402] = 89;
        byArray[403] = 79;
        byArray[404] = -26;
        byArray[405] = 113;
        byArray[406] = 7;
        byArray[407] = 16;
        byArray[408] = -127;
        byArray[409] = -128;
        byArray[410] = -76;
        byArray[411] = 73;
        byArray[412] = 22;
        byArray[413] = 113;
        byArray[414] = 35;
        byArray[415] = -24;
        byArray[416] = 76;
        byArray[417] = 40;
        byArray[418] = 22;
        byArray[419] = 19;
        byArray[420] = -73;
        byArray[421] = -49;
        byArray[422] = 9;
        byArray[423] = 50;
        byArray[424] = -116;
        byArray[425] = -56;
        byArray[426] = -90;
        byArray[427] = -31;
        byArray[428] = 60;
        byArray[429] = 22;
        byArray[430] = 122;
        byArray[431] = -117;
        byArray[432] = 84;
        byArray[433] = 124;
        byArray[434] = -115;
        byArray[435] = 40;
        byArray[436] = -32;
        byArray[437] = -93;
        byArray[438] = -82;
        byArray[439] = 30;
        byArray[440] = 43;
        byArray[441] = -77;
        byArray[442] = -90;
        byArray[443] = 117;
        byArray[444] = -111;
        byArray[445] = 110;
        byArray[446] = -93;
        byArray[447] = 127;
        byArray[448] = 11;
        byArray[449] = -6;
        byArray[450] = 33;
        byArray[451] = 53;
        byArray[452] = 98;
        byArray[453] = -15;
        byArray[454] = -5;
        byArray[455] = 98;
        byArray[456] = 122;
        byArray[457] = 1;
        byArray[458] = 36;
        byArray[459] = 59;
        byArray[460] = -52;
        byArray[461] = -92;
        byArray[462] = -15;
        byArray[463] = -66;
        byArray[464] = -88;
        byArray[465] = 81;
        byArray[466] = -112;
        byArray[467] = -119;
        byArray[468] = -88;
        byArray[469] = -125;
        byArray[470] = -33;
        byArray[471] = -31;
        byArray[472] = 90;
        byArray[473] = -27;
        byArray[474] = -97;
        byArray[475] = 6;
        byArray[476] = -110;
        byArray[477] = -117;
        byArray[478] = 102;
        byArray[479] = 94;
        byArray[480] = -128;
        byArray[481] = 123;
        byArray[482] = 85;
        byArray[483] = 37;
        byArray[484] = 100;
        byArray[485] = 1;
        byArray[486] = 76;
        byArray[487] = 59;
        byArray[488] = -2;
        byArray[489] = -49;
        byArray[490] = 73;
        byArray[491] = 42;
        byArray[492] = 3;
        byArray[493] = -127;
        byArray[494] = -123;
        byArray[496] = 2;
        byArray[497] = -127;
        byArray[498] = -127;
        byArray[500] = -116;
        byArray[501] = 41;
        byArray[502] = 78;
        byArray[503] = 97;
        byArray[504] = 29;
        byArray[505] = -39;
        byArray[506] = -6;
        byArray[507] = -125;
        byArray[508] = -99;
        byArray[509] = -18;
        byArray[510] = -77;
        byArray[511] = 120;
        byArray[512] = 40;
        byArray[513] = 126;
        byArray[514] = -104;
        byArray[515] = 69;
        byArray[516] = -60;
        byArray[517] = -33;
        byArray[518] = 40;
        byArray[519] = 9;
        byArray[520] = 11;
        byArray[521] = -48;
        byArray[522] = 85;
        byArray[523] = -62;
        byArray[524] = -93;
        byArray[525] = 100;
        byArray[526] = 38;
        byArray[527] = 106;
        byArray[528] = 74;
        byArray[529] = -116;
        byArray[531] = 123;
        byArray[532] = -11;
        byArray[533] = -122;
        byArray[534] = 125;
        byArray[535] = 127;
        byArray[536] = 2;
        byArray[537] = 21;
        byArray[538] = -77;
        byArray[539] = 18;
        byArray[540] = -53;
        byArray[541] = -85;
        byArray[542] = 48;
        byArray[543] = 118;
        byArray[544] = 56;
        byArray[545] = 80;
        byArray[546] = -38;
        byArray[547] = 67;
        byArray[548] = -56;
        byArray[549] = -96;
        byArray[550] = 122;
        byArray[551] = 66;
        byArray[552] = 9;
        byArray[553] = -7;
        byArray[554] = -124;
        byArray[555] = -90;
        byArray[556] = -3;
        byArray[557] = 115;
        byArray[558] = 122;
        byArray[559] = -128;
        byArray[560] = -32;
        byArray[561] = -31;
        byArray[562] = -22;
        byArray[563] = -12;
        byArray[564] = 1;
        byArray[565] = 76;
        byArray[566] = 102;
        byArray[567] = -54;
        byArray[568] = 124;
        byArray[569] = -112;
        byArray[571] = -55;
        byArray[572] = -11;
        byArray[573] = -101;
        byArray[574] = -69;
        byArray[575] = -19;
        byArray[576] = 77;
        byArray[577] = -65;
        byArray[578] = -86;
        byArray[579] = 61;
        byArray[580] = 111;
        byArray[581] = 119;
        byArray[582] = -107;
        byArray[583] = -56;
        byArray[584] = 110;
        byArray[585] = -116;
        byArray[586] = -39;
        byArray[587] = -9;
        byArray[588] = 46;
        byArray[589] = 18;
        byArray[590] = -106;
        byArray[591] = -28;
        byArray[592] = 23;
        byArray[593] = 113;
        byArray[594] = -39;
        byArray[595] = -12;
        byArray[596] = 41;
        byArray[597] = 47;
        byArray[598] = -79;
        byArray[599] = -72;
        byArray[600] = 125;
        byArray[601] = -84;
        byArray[602] = -120;
        byArray[603] = -115;
        byArray[604] = 125;
        byArray[605] = -95;
        byArray[606] = 111;
        byArray[607] = -44;
        byArray[608] = 125;
        byArray[609] = -77;
        byArray[610] = 45;
        byArray[611] = 10;
        byArray[612] = -5;
        byArray[613] = -104;
        byArray[614] = 47;
        byArray[615] = -41;
        byArray[616] = -119;
        byArray[617] = 106;
        byArray[618] = 97;
        byArray[619] = -95;
        byArray[620] = -9;
        byArray[621] = 80;
        byArray[622] = -29;
        byArray[623] = 26;
        byArray[624] = -111;
        byArray[625] = -102;
        byArray[626] = -109;
        byArray[627] = -116;
        byArray[628] = 48;
        byArray[629] = 11;
        byArray[630] = 6;
        byArray[631] = 7;
        byArray[632] = 42;
        byArray[633] = -122;
        byArray[634] = 72;
        byArray[635] = -50;
        byArray[636] = 56;
        byArray[637] = 4;
        byArray[638] = 3;
        byArray[639] = 5;
        byArray[641] = 3;
        byArray[642] = 47;
        byArray[644] = 48;
        byArray[645] = 44;
        byArray[646] = 2;
        byArray[647] = 20;
        byArray[648] = 31;
        byArray[649] = 93;
        byArray[650] = -31;
        byArray[651] = 109;
        byArray[652] = -22;
        byArray[653] = -112;
        byArray[654] = -62;
        byArray[655] = 99;
        byArray[656] = -20;
        byArray[657] = -5;
        byArray[658] = 17;
        byArray[659] = -9;
        byArray[660] = 123;
        byArray[661] = 116;
        byArray[662] = 1;
        byArray[663] = -78;
        byArray[664] = 3;
        byArray[665] = 60;
        byArray[666] = 122;
        byArray[667] = 60;
        byArray[668] = 2;
        byArray[669] = 20;
        byArray[670] = 48;
        byArray[671] = -86;
        byArray[672] = 15;
        byArray[673] = 10;
        byArray[674] = 63;
        byArray[675] = -70;
        byArray[676] = -20;
        byArray[677] = 37;
        byArray[678] = -16;
        byArray[679] = -79;
        byArray[680] = 19;
        byArray[681] = 58;
        byArray[682] = 104;
        byArray[683] = -122;
        byArray[684] = 26;
        byArray[685] = -85;
        byArray[686] = -49;
        byArray[687] = 63;
        byArray[688] = 104;
        byArray[689] = 49;
        byArray[690] = 49;
        byArray[691] = -127;
        S = byArray;
    }

    public JDClassLoader(String rootDir, ClassLoader classLoaderParent) {
        if (rootDir == null) {
            throw new IllegalArgumentException("Null root directory");
        }
        this.rootDir = rootDir;
        this.classLoaderParent = classLoaderParent;
        this.logger.finest("rootDir:" + rootDir);
        try {
            this.rootClassLoader = new URLClassLoader(new URL[]{new File(rootDir).toURI().toURL()}, null);
        }
        catch (MalformedURLException e1) {
            JDLogger.exception(e1);
        }
        boolean isWebupdater = false;
        System.out.println(rootDir);
        System.out.println(" " + this.rootClassLoader.getResource("jd"));
        boolean bl = isWebupdater = ("" + classLoaderParent.getResource("jd")).contains("jdupdate.jar") || ("" + classLoaderParent.getResource("jd")).contains("webupdater.jar");
        if (!isWebupdater) {
            int i;
            Vector<JarFile> jarFiles = new Vector<JarFile>();
            this.jarFile = new Vector();
            ArrayList<String> names = new ArrayList<String>();
            File[] files = new File(new File(rootDir), "plugins").listFiles(new JDFileFilter(null, ".jar", false));
            if (files != null) {
                i = 0;
                while (i < files.length) {
                    try {
                        if (!files[i].getAbsolutePath().endsWith("webupdater.jar") || !files[i].getAbsolutePath().endsWith("jdupdate.jar")) {
                            if (JDUtilities.getRunType() == 2 && !this.comp(JDClassLoader.getSig(files[i].getAbsolutePath()))) {
                                this.logger.severe("Not loaded due to sig violation: " + files[i]);
                            } else if (names.contains(files[i].getName())) {
                                this.logger.severe("Duplicate Jars found: " + files[i].getAbsolutePath());
                            } else {
                                names.add(files[i].getName());
                                this.logger.finer("Jar file loaded: " + files[i].getAbsolutePath());
                                this.jarFile.add(files[i]);
                                jarFiles.add(new JarFile(files[i]));
                            }
                        }
                    }
                    catch (Exception e) {
                        JDLogger.exception(e);
                    }
                    ++i;
                }
            }
            if ((files = new File(rootDir).listFiles(new JDFileFilter(null, ".jar", false))) != null) {
                i = 0;
                while (i < files.length) {
                    try {
                        if (!files[i].getAbsolutePath().endsWith("webupdater.jar") && !files[i].getAbsolutePath().endsWith("jdupdate.jar")) {
                            if (!this.comp(JDClassLoader.getSig(files[i].getAbsolutePath()))) {
                                this.logger.severe("Not loaded due to sig violation: " + files[i]);
                            } else if (names.contains(files[i].getName())) {
                                this.logger.severe("Duplicate Jars found: " + files[i].getAbsolutePath());
                            } else {
                                names.add(files[i].getName());
                                this.logger.finer("Jar file loaded: " + files[i].getAbsolutePath());
                                this.jarFile.add(files[i]);
                                jarFiles.add(new JarFile(files[i]));
                            }
                        }
                    }
                    catch (IOException e) {
                        JDLogger.exception(e);
                    }
                    ++i;
                }
            }
            files = new File(rootDir, "libs/laf").listFiles(new JDFileFilter(null, ".jar", false));
            this.lafs = new ArrayList();
            if (files != null) {
                i = 0;
                while (i < files.length) {
                    try {
                        if (!files[i].getAbsolutePath().endsWith("webupdater.jar") && !files[i].getAbsolutePath().endsWith("jdupdate.jar")) {
                            if (names.contains(files[i].getName())) {
                                this.logger.severe("Duplicate Jars found: " + files[i].getAbsolutePath());
                            } else {
                                names.add(files[i].getName());
                                this.logger.finer("Look and Feel JAR loaded: " + files[i].getAbsolutePath());
                                this.jarFile.add(files[i]);
                                this.lafs.add(files[i]);
                                jarFiles.add(new JarFile(files[i]));
                            }
                        }
                    }
                    catch (IOException e) {
                        JDLogger.exception(e);
                    }
                    ++i;
                }
            }
            this.jars = jarFiles.toArray(new JarFile[0]);
        }
    }

    public ArrayList<File> getLafs() {
        return this.lafs;
    }

    private boolean comp(byte[] sig) {
        if (sig == null) {
            return false;
        }
        int i = 0;
        while (i < S.length) {
            byte a = S[i];
            byte b = sig[i];
            if (a != b) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] getSig(String jarfile) {
        try {
            JarFile jar = new JarFile(jarfile);
            String dsa = "META-INF/JDOWNLOA.DSA";
            ZipEntry entry = jar.getEntry(dsa);
            byte[] b = new byte[1];
            BufferedInputStream in = new BufferedInputStream(jar.getInputStream(entry));
            byte[] res = new byte[692];
            int c = 0;
            int n = 0;
            while ((n = ((InputStream)in).read(b)) > -1) {
                if (n <= 0 || ++c < 24 || c >= 716) continue;
                res[c - 24] = b[0];
            }
            return res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected URL findResource(String name) {
        URL url = this.rootClassLoader.findResource(name);
        if (url != null) {
            return url;
        }
        return super.findResource(name);
    }

    public Vector<File> getJars() {
        Vector<File> ret = new Vector<File>();
        ret.addAll(this.jarFile);
        return ret;
    }

    public URL getResource(byte[] key) {
        return this.getResource(new String(key));
    }

    @Override
    public URL getResource(String name) {
        URL url;
        if (this.jars != null) {
            JarFile[] jarFileArray = this.jars;
            int n = this.jars.length;
            int n2 = 0;
            while (n2 < n) {
                JarEntry entry;
                JarFile element = jarFileArray[n2];
                if (element != null && (entry = element.getJarEntry(name)) != null) {
                    try {
                        return new URL(entry.getName());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        if ((url = this.rootClassLoader.getResource(name)) != null) {
            return url;
        }
        url = super.getResource(name);
        if (url != null) {
            return url;
        }
        url = this.classLoaderParent.getResource(name);
        if (url != null) {
            return url;
        }
        try {
            return new File(new File(this.rootDir), name).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> urls = new Vector<URL>();
        Enumeration<URL> en = this.classLoaderParent.getResources(name);
        while (en.hasMoreElements()) {
            URL tmp = en.nextElement();
            urls.add(tmp);
        }
        if (this.jars != null) {
            JarFile[] jarFileArray = this.jars;
            int n = this.jars.length;
            int n2 = 0;
            while (n2 < n) {
                JarEntry entry;
                JarFile element = jarFileArray[n2];
                if (element != null && (entry = element.getJarEntry(name)) != null) {
                    try {
                        String url = new File(element.getName().replace("\\", "/")).toURI().toURL() + "!/" + entry.getName();
                        urls.add(new URL("jar", "", url));
                    }
                    catch (MalformedURLException e) {
                        JDLogger.exception(e);
                    }
                }
                ++n2;
            }
        }
        this.logger.info("" + urls);
        return urls.elements();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findSystemClass(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (c == null) {
                try {
                    c = this.classLoaderParent.loadClass(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (c == null) {
            JarEntry entry = null;
            JarFile[] jarFileArray = this.jars;
            int n = this.jars.length;
            int n2 = 0;
            while (n2 < n) {
                JarFile element = jarFileArray[n2];
                entry = element.getJarEntry(String.valueOf(name.replace('.', '/')) + ".class");
                if (entry != null) {
                    try {
                        byte[] data = this.loadClassData(element, entry);
                        System.out.println("Loaded class " + name + " from " + element.getName());
                        c = this.defineClass(name, data, 0, data.length, this.getClass().getProtectionDomain());
                        if (c == null) {
                            throw new ClassNotFoundException(name);
                        }
                    }
                    catch (ClassFormatError e) {
                        JDLogger.exception(e);
                    }
                    catch (IOException e) {
                        JDLogger.exception(e);
                    }
                }
                ++n2;
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public String findJar(String name) throws ClassNotFoundException {
        JarEntry entry = null;
        JarFile[] jarFileArray = this.jars;
        int n = this.jars.length;
        int n2 = 0;
        while (n2 < n) {
            JarFile element = jarFileArray[n2];
            entry = element.getJarEntry(String.valueOf(name.replace('.', '/')) + ".class");
            if (entry != null) {
                return element.getName();
            }
            ++n2;
        }
        return null;
    }

    private byte[] loadClassData(JarFile jarFile, JarEntry jarEntry) throws IOException {
        byte[] buff = new byte[(int)jarEntry.getSize()];
        DataInputStream dis = new DataInputStream(jarFile.getInputStream(jarEntry));
        dis.readFully(buff);
        dis.close();
        return buff;
    }
}

