/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import jd.config.ConfigEntry;
import jd.config.ConfigGroup;
import jd.config.Property;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigContainer
implements Serializable {
    public static final int ACTION_REQUEST_SAVE = 0;
    private static final long serialVersionUID = 6583843494325603616L;
    public static final int TYPE_TEXTFIELD = 0;
    public static final int TYPE_COMBOBOX = 1;
    public static final int TYPE_BUTTON = 2;
    public static final int TYPE_CHECKBOX = 3;
    public static final int TYPE_LABEL = 4;
    public static final int TYPE_RADIOFIELD = 5;
    public static final int TYPE_SEPARATOR = 6;
    public static final int TYPE_BROWSEFILE = 7;
    public static final int TYPE_SPINNER = 8;
    public static final int TYPE_BROWSEFOLDER = 9;
    public static final int TYPE_TEXTAREA = 10;
    public static final int TYPE_PASSWORDFIELD = 11;
    public static final int TYPE_LINK = 12;
    public static final int TYPE_CONTAINER = 13;
    public static final int TYPE_LISTCONTROLLED = 110;
    public static final int TYPE_COMBOBOX_INDEX = 15;
    private ActionListener actionListener;
    private int containers = 0;
    private ArrayList<ConfigEntry> content;
    private Property propertyInstance;
    private String title;
    private ConfigGroup group;

    public ConfigContainer() {
        this(JDL.L((String)"config.container.defaultname", (String)"Allgemein"));
    }

    public ConfigContainer(String title) {
        this.title = title;
        this.propertyInstance = JDUtilities.getConfiguration();
        this.content = new ArrayList();
    }

    public void addEntry(ConfigEntry entry) {
        if (entry.getGroup() == null) {
            entry.setGroup(this.group);
        }
        if (entry.getContainer() != null) {
            ++this.containers;
        }
        if (entry.getPropertyInstance() == null) {
            entry.setPropertyInstance(this.propertyInstance);
        }
        this.content.add(entry);
    }

    public int getContainerNum() {
        return this.containers;
    }

    public ArrayList<ConfigEntry> getEntries() {
        return this.content;
    }

    public ConfigEntry getEntryAt(int i) {
        if (this.content.size() <= i) {
            return null;
        }
        return this.content.get(i);
    }

    public Property getPropertyInstance() {
        return this.propertyInstance;
    }

    public String getTitle() {
        return this.title;
    }

    public void requestSave() {
        if (this.actionListener == null) {
            return;
        }
        this.actionListener.actionPerformed(new ActionEvent(this, 0, "save"));
    }

    public void setActionListener(ActionListener listener) {
        this.actionListener = listener;
    }

    public void setPropertyInstance(Property propertInstance) {
        this.propertyInstance = propertInstance;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setGroup(ConfigGroup configGroup) {
        this.group = configGroup;
    }

    public ConfigGroup getGroup() {
        return this.group;
    }
}

