/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Logger;
import jd.controlling.JDLogger;
import jd.event.ControlEvent;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property
implements Serializable {
    private static final long serialVersionUID = -6093927038856757256L;
    public static final Object NULL = new Object();
    protected transient Logger logger = null;
    private HashMap<String, Object> properties = new HashMap();
    private HashMap<String, Integer> propertiesHashes = new HashMap();
    protected transient boolean changes = false;

    public Property() {
        this.logger = JDLogger.getLogger();
    }

    public Property(String value, Object obj) {
        this();
        this.setProperty(value, obj);
    }

    public <E> E getGenericProperty(String key, E def) {
        Object r = this.getProperty(key, def);
        try {
            Object ret = r;
            return (E)ret;
        }
        catch (Exception e) {
            this.logger.finer("Could not cast " + r.getClass().getSimpleName() + " to " + e.getClass().getSimpleName() + " for key " + key);
            return def;
        }
    }

    public Boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, false);
    }

    public Boolean getBooleanProperty(String key, boolean def) {
        try {
            Object r = this.getProperty(key, def);
            if (!(r instanceof Boolean)) {
                r = ((String)(r = String.valueOf(r))).equals("false") ? Boolean.valueOf(false) : Boolean.valueOf(((String)r).length() > 0);
            }
            Boolean ret = (Boolean)r;
            return ret;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Double getDoubleProperty(String key) {
        return this.getDoubleProperty(key, -1.0);
    }

    public Double getDoubleProperty(String key, Double def) {
        try {
            Object r = this.getProperty(key, def);
            if (r instanceof String) {
                r = Double.parseDouble((String)r);
            }
            Double ret = (Double)r;
            return ret;
        }
        catch (Exception e) {
            return def;
        }
    }

    public int getIntegerProperty(String key) {
        return this.getIntegerProperty(key, -1);
    }

    public int getIntegerProperty(String key, int def) {
        try {
            Object r = this.getProperty(key, def);
            if (r instanceof String) {
                r = Integer.parseInt((String)r);
            }
            Integer ret = (Integer)r;
            return ret;
        }
        catch (Exception e) {
            return def;
        }
    }

    public HashMap<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties.get(key);
    }

    public Object getProperty(String key, Object def) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if (this.properties.get(key) == null) {
            this.setProperty(key, def);
            return def;
        }
        return this.properties.get(key);
    }

    public String getStringProperty(String key) {
        return this.getStringProperty(key, null);
    }

    public String getStringProperty(String key, String def) {
        try {
            Object r = this.getProperty(key, def);
            String ret = r == null ? null : r.toString();
            return ret;
        }
        catch (Exception e) {
            return def;
        }
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public void setProperties(HashMap<String, Object> properties) {
        this.properties = properties;
        this.propertiesHashes = new HashMap();
    }

    public void setProperty(String key, Object value) {
        if (value == NULL) {
            if (this.properties.containsKey(key)) {
                this.properties.remove(key);
                this.propertiesHashes.remove(key);
                JDUtilities.getController().fireControlEvent(new ControlEvent(this, 27, key));
                this.changes = true;
            }
            return;
        }
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if (this.propertiesHashes == null) {
            this.propertiesHashes = new HashMap();
        }
        Object old = this.getProperty(key);
        this.properties.put(key, value);
        Integer oldHash = this.propertiesHashes.get(key);
        this.propertiesHashes.put(key, value == null ? null : Integer.valueOf(value.toString().hashCode()));
        if (JDUtilities.getController() == null) {
            return;
        }
        try {
            if (old == null && value != null) {
                JDUtilities.getController().fireControlEvent(new ControlEvent(this, 27, key));
                this.changes = true;
                return;
            }
            if (value instanceof Comparable) {
                if (((Comparable)value).compareTo((Comparable)old) != 0) {
                    JDUtilities.getController().fireControlEvent(new ControlEvent(this, 27, key));
                    this.changes = true;
                }
                return;
            }
            if (value instanceof Object) {
                if (!value.equals(old) || oldHash.intValue() != value.hashCode()) {
                    JDUtilities.getController().fireControlEvent(new ControlEvent(this, 27, key));
                    this.changes = true;
                }
                return;
            }
            if (value != old) {
                JDUtilities.getController().fireControlEvent(new ControlEvent(this, 27, key));
                this.changes = true;
            }
        }
        catch (Exception e) {
            JDUtilities.getController().fireControlEvent(new ControlEvent(this, 27, key));
            this.changes = true;
        }
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public String toString() {
        if (this.properties.size() == 0) {
            return "";
        }
        return "Property: " + this.properties;
    }
}

