/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import jd.captcha.JACMethod;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.pixelgrid.Captcha;
import jd.config.SubConfiguration;
import jd.gui.UserIO;
import jd.utils.JDUtilities;

public class CaptchaController {
    private String methodname;
    private File captchafile;
    private String explain;
    private String suggest;

    public CaptchaController(String method, File file, String suggest, String explain) {
        this.methodname = method;
        this.captchafile = file;
        this.explain = explain;
        this.suggest = suggest;
    }

    private boolean isMethodEnabled() {
        return JDUtilities.getConfiguration() != null && JDUtilities.getConfiguration().getBooleanProperty("CAPTCHA_JAC_DISBALE", false) == false && JACMethod.hasMethod((String)this.methodname) && JDUtilities.getConfiguration().getBooleanProperty("JAC_METHODS_" + this.methodname.toLowerCase(), true) != false;
    }

    public String getCode(int flag) {
        if ((flag & 1) > 0) {
            return UserIO.getInstance().requestCaptchaDialog(flag, this.methodname, this.captchafile, this.suggest, this.explain);
        }
        if (!this.isMethodEnabled()) {
            if ((flag & 2) > 0) {
                return null;
            }
            return UserIO.getInstance().requestCaptchaDialog(flag | 1, this.methodname, this.captchafile, this.suggest, this.explain);
        }
        JAntiCaptcha jac = new JAntiCaptcha(JDUtilities.getJACMethodsDirectory(), this.methodname);
        try {
            BufferedImage captchaImage = ImageIO.read(this.captchafile);
            Captcha captcha = jac.createCaptcha((Image)captchaImage);
            String captchaCode = jac.checkCaptcha(this.captchafile, captcha);
            if (jac.isExtern()) {
                if ((flag & 2) == 0 && captchaCode == null || captchaCode.trim().length() == 0) {
                    captchaCode = UserIO.getInstance().requestCaptchaDialog(flag | 1, this.methodname, this.captchafile, this.suggest, this.explain);
                }
                return captchaCode;
            }
            LetterComperator[] lcs = captcha.getLetterComperators();
            double vp = 0.0;
            if (lcs == null) {
                vp = 100.0;
            } else {
                LetterComperator[] letterComperatorArray = lcs;
                int n = lcs.length;
                int n2 = 0;
                while (n2 < n) {
                    LetterComperator element = letterComperatorArray[n2];
                    if (element == null) {
                        vp = 100.0;
                        break;
                    }
                    vp = Math.max(vp, element.getValityPercent());
                    ++n2;
                }
            }
            if (vp > (double)SubConfiguration.getConfig("JAC").getIntegerProperty("AUTOTRAIN_ERROR_LEVEL", 95)) {
                if ((flag & 2) > 0) {
                    return captchaCode;
                }
                return UserIO.getInstance().requestCaptchaDialog(flag | 1, this.methodname, this.captchafile, captchaCode, null);
            }
            return captchaCode;
        }
        catch (Exception e) {
            return null;
        }
    }
}

