/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.io.File;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import jd.config.SubConfiguration;
import jd.controlling.DownloadController;
import jd.controlling.JDLogger;
import jd.controlling.interaction.Interaction;
import jd.event.ControlEvent;
import jd.gui.UserIO;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.Balloon;
import jd.gui.swing.dialog.AgbDialog;
import jd.http.Browser;
import jd.nutils.Formatter;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.LinkStatus;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.download.DownloadInterface;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class SingleDownloadController
extends Thread {
    public static final String WAIT_TIME_ON_CONNECTION_LOSS = "WAIT_TIME_ON_CONNECTION_LOSS";
    private static final Object DUPELOCK = new Object();
    private boolean aborted;
    private PluginForHost currentPlugin;
    private DownloadLink downloadLink;
    private LinkStatus linkStatus;
    private Logger logger = JDLogger.getLogger();
    private long startTime;

    public SingleDownloadController(DownloadLink dlink) {
        super("JD-StartDownloads");
        this.downloadLink = dlink;
        this.linkStatus = this.downloadLink.getLinkStatus();
        this.setPriority(1);
        this.downloadLink.setDownloadLinkController(this);
    }

    public SingleDownloadController abortDownload() {
        this.aborted = true;
        this.interrupt();
        return this;
    }

    private void fireControlEvent(ControlEvent controlEvent) {
        JDUtilities.getController().fireControlEvent(controlEvent);
    }

    private void fireControlEvent(int controlID, Object param) {
        JDUtilities.getController().fireControlEvent(controlID, param);
    }

    public PluginForHost getCurrentPlugin() {
        return this.currentPlugin;
    }

    public DownloadLink getDownloadLink() {
        return this.downloadLink;
    }

    private void handlePlugin() {
        try {
            this.startTime = System.currentTimeMillis();
            this.linkStatus.setStatusText(JDL.L((String)"gui.download.create_connection", (String)"Connecting..."));
            System.out.println("PreDupeChecked: no mirror found!");
            this.fireControlEvent(5, this.currentPlugin);
            DownloadController.getInstance().fireDownloadLinkUpdate(this.downloadLink);
            this.currentPlugin.init();
            try {
                try {
                    this.currentPlugin.handle(this.downloadLink);
                }
                catch (Browser.BrowserException e) {
                    e.closeConnection();
                    if (e.getException() != null) {
                        throw e.getException();
                    }
                    throw e;
                }
            }
            catch (UnknownHostException e) {
                this.linkStatus.addStatus(2048);
                this.linkStatus.setErrorMessage(JDL.L((String)"plugins.errors.nointernetconn", (String)"No Internet connection?"));
                this.linkStatus.setValue(300000L);
            }
            catch (SocketTimeoutException e) {
                this.linkStatus.addStatus(2048);
                this.linkStatus.setErrorMessage(JDL.L((String)"plugins.errors.hosteroffline", (String)"Hoster offline?"));
                this.linkStatus.setValue(600000L);
            }
            catch (SocketException e) {
                this.linkStatus.addStatus(2048);
                this.linkStatus.setErrorMessage(JDL.L((String)"plugins.errors.disconnect", (String)"Disconnect?"));
                this.linkStatus.setValue(300000L);
            }
            catch (InterruptedException e) {
                this.logger.finest("Hoster Plugin Version: " + this.downloadLink.getPlugin().getVersion());
                this.linkStatus.addStatus(131072);
                this.linkStatus.setErrorMessage(String.valueOf(JDL.L((String)"plugins.errors.error", (String)"Error: ")) + JDUtilities.convertExceptionReadable(e));
            }
            catch (NullPointerException e) {
                this.logger.finest("Hoster Plugin Version: " + this.downloadLink.getPlugin().getVersion());
                JDLogger.exception(e);
                this.linkStatus.addStatus(0x400000);
                this.linkStatus.setErrorMessage(String.valueOf(JDL.L((String)"plugins.errors.error", (String)"Error: ")) + JDUtilities.convertExceptionReadable(e));
            }
            catch (Exception e) {
                this.logger.finest("Hoster Plugin Version: " + this.downloadLink.getPlugin().getVersion());
                JDLogger.exception(e);
                this.linkStatus.addStatus(131072);
                this.linkStatus.setErrorMessage(String.valueOf(JDL.L((String)"plugins.errors.error", (String)"Error: ")) + JDUtilities.convertExceptionReadable(e));
            }
            if (this.isAborted()) {
                this.logger.finest("Thread aborted");
                this.linkStatus.setStatus(1);
                return;
            }
            if (this.linkStatus.isFailed()) {
                this.logger.warning("\r\nError occured- " + this.downloadLink.getLinkStatus());
            }
            if (this.aborted) {
                this.linkStatus.setErrorMessage(null);
            }
            switch (this.linkStatus.getLatestStatus()) {
                case 0x200000: {
                    this.onErrorLocalIO(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 16: {
                    this.onErrorWaittime(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 2048: {
                    this.onErrorTemporarilyUnavailable(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 65536: {
                    this.onErrorAGBNotSigned(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 32: {
                    Balloon.showIfHidden((String)JDL.L((String)"ballon.download.error.title", (String)"Error"), (ImageIcon)JDTheme.II("gui.images.bad", 32, 32), (String)JDL.LF((String)"ballon.download.fnf.message", (String)"<b>%s<b><hr>File not found", (Object[])new Object[]{String.valueOf(this.downloadLink.getName()) + " (" + Formatter.formatReadable(this.downloadLink.getDownloadSize()) + ")"}));
                    this.onErrorFileNotFound(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 524288: {
                    this.onErrorLinkBlock(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 131072: {
                    Balloon.showIfHidden((String)JDL.L((String)"ballon.download.error.title", (String)"Error"), (ImageIcon)JDTheme.II("gui.images.bad", 32, 32), (String)JDL.LF((String)"ballon.download.fatalerror.message", (String)"<b>%s<b><hr>Fatal Plugin Error", (Object[])new Object[]{this.downloadLink.getHost()}));
                    this.onErrorFatal(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 8: {
                    this.onErrorCaptcha(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 256: {
                    this.onErrorPremium(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 512: {
                    this.onErrorIncomplete(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 8192: {
                    this.onErrorFileExists(this.downloadLink, this.currentPlugin);
                    break;
                }
                case 16384: {
                    this.onErrorChunkloadFailed(this.downloadLink, this.currentPlugin);
                    Balloon.showIfHidden((String)JDL.L((String)"ballon.download.error.title", (String)"Error"), (ImageIcon)JDTheme.II("gui.images.bad", 32, 32), (String)JDL.LF((String)"ballon.download.failed.message", (String)"<b>%s<b><hr>failed", (Object[])new Object[]{String.valueOf(this.downloadLink.getName()) + " (" + Formatter.formatReadable(this.downloadLink.getDownloadSize()) + ")"}));
                    break;
                }
                case 0x400000: {
                    this.onErrorPluginDefect(this.downloadLink, this.currentPlugin);
                    Balloon.showIfHidden((String)JDL.L((String)"ballon.download.error.title", (String)"Error"), (ImageIcon)JDTheme.II("gui.images.bad", 32, 32), (String)JDL.LF((String)"ballon.download.plugindefect.message", (String)"<b>%s<b><hr>Plugin defect", (Object[])new Object[]{this.downloadLink.getHost()}));
                    break;
                }
                case 32768: 
                case 0x100000: {
                    Balloon.showIfHidden((String)JDL.L((String)"ballon.download.error.title", (String)"Error"), (ImageIcon)JDTheme.II("gui.images.bad", 32, 32), (String)JDL.LF((String)"ballon.download.connectionlost.message", (String)"<b>%s<b><hr>Connection lost", (Object[])new Object[]{this.downloadLink.getHost()}));
                    this.onErrorNoConnection(this.downloadLink, this.currentPlugin);
                    break;
                }
                default: {
                    if (this.linkStatus.hasStatus(2)) {
                        this.logger.finest("\r\nFinished- " + this.downloadLink.getLinkStatus());
                        this.logger.info("\r\nFinished- " + this.downloadLink.getFileOutput());
                        this.onDownloadFinishedSuccessFull(this.downloadLink);
                        break;
                    }
                    this.retry(this.downloadLink, this.currentPlugin);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.severe("Error in Plugin Version: " + this.downloadLink.getPlugin().getVersion());
            JDLogger.exception(e);
        }
    }

    private void onErrorLinkBlock(DownloadLink downloadLink, PluginForHost currentPlugin) {
        LinkStatus status = downloadLink.getLinkStatus();
        if (status.hasStatus(8192)) {
            this.onErrorFileExists(downloadLink, currentPlugin);
        } else {
            status.resetWaitTime();
            downloadLink.setEnabled(false);
        }
    }

    private void onErrorPluginDefect(DownloadLink downloadLink2, PluginForHost currentPlugin2) {
        this.logger.warning("The Plugin for " + this.currentPlugin.getHost() + " seems to be out of date(rev" + this.downloadLink.getPlugin().getVersion() + "). Please inform the Support-team http://jdownloader.org/support.");
        this.logger.warning(downloadLink2.getLinkStatus().getErrorMessage());
        this.logger.finest("" + currentPlugin2.getBrowser());
        downloadLink2.getLinkStatus().addStatus(131072);
        downloadLink2.getLinkStatus().setErrorMessage(JDL.L((String)"controller.status.pluindefekt", (String)"Plugin out of date"));
        this.downloadLink.requestGuiUpdate();
    }

    public boolean isAborted() {
        return this.aborted;
    }

    private void onDownloadFinishedSuccessFull(DownloadLink downloadLink) {
        if (System.currentTimeMillis() - this.startTime > 30000L) {
            Balloon.showIfHidden((String)JDL.L((String)"ballon.download.successfull.title", (String)"Download"), (ImageIcon)JDTheme.II("gui.images.ok", 32, 32), (String)JDL.LF((String)"ballon.download.successfull.message", (String)"<b>%s<b><hr>finished successfully", (Object[])new Object[]{String.valueOf(downloadLink.getName()) + " (" + Formatter.formatReadable(downloadLink.getDownloadSize()) + ")"}));
        }
        downloadLink.setProperty("STATIC_OUTPUTFILE", (Object)downloadLink.getFileOutput());
        DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
        Interaction.handleInteraction(Interaction.INTERACTION_SINGLE_DOWNLOAD_FINISHED, downloadLink);
        if (JDUtilities.getController().isContainerFile(new File(downloadLink.getFileOutput()))) {
            Interaction.handleInteraction(Interaction.INTERACTION_CONTAINER_DOWNLOAD, downloadLink);
            if (JDUtilities.getConfiguration().getBooleanProperty("RELOADCONTAINER", true).booleanValue()) {
                JDUtilities.getController().loadContainerFile(new File(downloadLink.getFileOutput()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onErrorAGBNotSigned(DownloadLink downloadLink2, PluginForHost plugin) throws InterruptedException {
        downloadLink2.getLinkStatus().setStatusText(JDL.L((String)"controller.status.agb_tos", (String)"TOS haven't been accepted."));
        if (!plugin.isAGBChecked()) {
            Object object = JDUtilities.USERIO_LOCK;
            synchronized (object) {
                if (!plugin.isAGBChecked()) {
                    this.showAGBDialog(downloadLink2);
                } else {
                    downloadLink2.getLinkStatus().reset();
                }
            }
        } else {
            downloadLink2.getLinkStatus().reset();
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(this.downloadLink);
    }

    private void showAGBDialog(final DownloadLink downloadLink2) {
        new GuiRunnable<Object>(){

            public Object runSave() {
                AgbDialog.showDialog((DownloadLink)downloadLink2);
                return null;
            }
        }.waitForEDT();
    }

    private void onErrorCaptcha(DownloadLink downloadLink, PluginForHost plugin) {
        this.retry(downloadLink, plugin);
    }

    private void retry(DownloadLink downloadLink, PluginForHost plugin) {
        int r;
        if (downloadLink.getLinkStatus().getValue() > 0L) {
            downloadLink.getLinkStatus().setStatusText(null);
        }
        if ((r = downloadLink.getLinkStatus().getRetryCount()) <= plugin.getMaxRetries()) {
            downloadLink.getLinkStatus().reset();
            downloadLink.getLinkStatus().setRetryCount(r + 1);
            downloadLink.getLinkStatus().setErrorMessage(null);
            try {
                plugin.sleep((long)Math.max((int)downloadLink.getLinkStatus().getValue(), 2000), downloadLink);
            }
            catch (PluginException e) {
                downloadLink.getLinkStatus().setStatusText(null);
                DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
                return;
            }
        } else {
            downloadLink.getLinkStatus().addStatus(131072);
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
    }

    private void onErrorChunkloadFailed(DownloadLink downloadLink, PluginForHost plugin) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        if (linkStatus.getErrorMessage() == null) {
            linkStatus.setErrorMessage(JDL.L((String)"plugins.error.downloadfailed", (String)"Download failed"));
        }
        if (linkStatus.getValue() != 0x8000000L) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                return;
            }
            this.retry(downloadLink, plugin);
        }
    }

    private void onErrorFatal(DownloadLink downloadLink, PluginForHost currentPlugin) {
        downloadLink.requestGuiUpdate();
    }

    private void onErrorFileExists(DownloadLink downloadLink, PluginForHost plugin) {
        LinkStatus status = downloadLink.getLinkStatus();
        Object[] fileExists = new String[]{JDL.L((String)"system.download.triggerfileexists.overwrite", (String)"Datei \u00fcberschreiben"), JDL.L((String)"system.download.triggerfileexists.skip", (String)"Link \u00fcberspringen"), JDL.L((String)"system.download.triggerfileexists.rename", (String)"Auto rename")};
        String title = JDL.L((String)"jd.controlling.SingleDownloadController.askexists.title", (String)"File exists");
        String msg = JDL.LF((String)"jd.controlling.SingleDownloadController.askexists", (String)"The file \r\n%s\r\n already exists. What do you want to do?", (Object[])new Object[]{downloadLink.getFileOutput()});
        int doit = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty("FILE_EXISTS");
        if (doit == 4) {
            doit = UserIO.getInstance().requestComboDialog(4, title, msg, fileExists, 0, null, null, null, null);
        }
        if (doit == 3) {
            if (downloadLink.getFilePackage().getIntegerProperty("DO_WHEN_EXISTS", -1) > 0) {
                doit = downloadLink.getFilePackage().getIntegerProperty("DO_WHEN_EXISTS", -1);
                int cd = UserIO.getCountdownTime();
                try {
                    UserIO.setCountdownTime((int)10);
                    doit = UserIO.getInstance().requestComboDialog(0, title, msg, fileExists, doit, null, null, null, null);
                    downloadLink.getFilePackage().setProperty("DO_WHEN_EXISTS", (Object)doit);
                }
                finally {
                    UserIO.setCountdownTime((int)cd);
                }
            } else {
                doit = UserIO.getInstance().requestComboDialog(0, title, msg, fileExists, 0, null, null, null, null);
                downloadLink.getFilePackage().setProperty("DO_WHEN_EXISTS", (Object)doit);
            }
        }
        switch (doit) {
            case 1: {
                status.setErrorMessage(JDL.L((String)"controller.status.fileexists.skip", (String)"File already exists."));
                downloadLink.setEnabled(false);
                break;
            }
            case 2: {
                status.reset();
                File file = new File(downloadLink.getFileOutput());
                String filename = file.getName();
                String extension = JDIO.getFileExtension(file);
                String name = filename.substring(0, filename.length() - extension.length() - 1);
                int copy = 2;
                try {
                    String[] num = new Regex(name, "(.*)_(\\d+)").getRow(0);
                    copy = Integer.parseInt(num[1]) + 1;
                    downloadLink.setFinalFileName(String.valueOf(name) + "_" + copy + "." + extension);
                    while (new File(downloadLink.getFileOutput()).exists()) {
                        downloadLink.setFinalFileName(String.valueOf(name) + "_" + ++copy + "." + extension);
                    }
                }
                catch (Exception e) {
                    copy = 2;
                    downloadLink.setFinalFileName(String.valueOf(name) + "_" + copy + "." + extension);
                }
                break;
            }
            default: {
                if (new File(downloadLink.getFileOutput()).delete()) {
                    status.reset();
                    break;
                }
                status.addStatus(131072);
                status.setErrorMessage(String.valueOf(JDL.L((String)"controller.status.fileexists.overwritefailed", (String)"\u00dcberschreiben fehlgeschlagen ")) + downloadLink.getFileOutput());
            }
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
    }

    private void onErrorFileNotFound(DownloadLink downloadLink, PluginForHost plugin) {
        this.logger.severe("File not found :" + downloadLink.getDownloadURL());
        downloadLink.setEnabled(false);
    }

    private void onErrorIncomplete(DownloadLink downloadLink, PluginForHost plugin) {
        this.retry(downloadLink, plugin);
    }

    private void onErrorNoConnection(DownloadLink downloadLink, PluginForHost plugin) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        this.logger.severe("Error occurred: No Server connection");
        long milliSeconds = SubConfiguration.getConfig("DOWNLOAD").getIntegerProperty(WAIT_TIME_ON_CONNECTION_LOSS, 300) * 1000;
        linkStatus.addStatus(2048);
        linkStatus.setWaitTime(milliSeconds);
        if (linkStatus.getErrorMessage() == null) {
            linkStatus.setErrorMessage(JDL.L((String)"controller.status.connectionproblems", (String)"Connection lost."));
        }
    }

    private void onErrorPremium(DownloadLink downloadLink, PluginForHost plugin) {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        linkStatus.reset();
    }

    private void onErrorLocalIO(DownloadLink downloadLink, PluginForHost plugin) {
        LinkStatus status = downloadLink.getLinkStatus();
        status.setWaitTime(1800000L);
        downloadLink.setEnabled(false);
    }

    private void onErrorTemporarilyUnavailable(DownloadLink downloadLink, PluginForHost plugin) {
        this.logger.warning("Error occurred: Temporarily unavailably: PLease wait " + downloadLink.getLinkStatus().getValue() + " ms for a retry");
        LinkStatus status = downloadLink.getLinkStatus();
        if (status.getErrorMessage() == null) {
            status.setErrorMessage(JDL.L((String)"controller.status.tempUnavailable", (String)"kurzzeitig nicht verf\u00fcgbar"));
        }
        if (status.getValue() > 0L) {
            status.setWaitTime(status.getValue());
        } else if (status.getValue() == 0L) {
            status.setWaitTime(1800000L);
        } else {
            status.resetWaitTime();
            downloadLink.setEnabled(false);
        }
        DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
    }

    private void onErrorWaittime(DownloadLink downloadLink, PluginForHost plugin) {
        LinkStatus status = downloadLink.getLinkStatus();
        long milliSeconds = downloadLink.getLinkStatus().getValue();
        if (milliSeconds <= 0L) {
            this.logger.severe(JDL.L((String)"plugins.errors.pluginerror", (String)"Plugin error. Please inform Support"));
            milliSeconds = 3600000L;
        }
        status.setWaitTime(milliSeconds);
        plugin.setHosterWaittime(milliSeconds);
        DownloadController.getInstance().fireDownloadLinkUpdate(downloadLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            PluginForHost plugin;
            this.linkStatus.setStatusText(null);
            this.linkStatus.setErrorMessage(null);
            this.linkStatus.resetWaitTime();
            this.logger.info("Start working on " + this.downloadLink.getName());
            this.currentPlugin = plugin = this.downloadLink.getPlugin();
            this.fireControlEvent(new ControlEvent(this.currentPlugin, 5, this));
            if (this.downloadLink.getDownloadURL() == null) {
                this.downloadLink.getLinkStatus().setStatusText(JDL.L((String)"controller.status.containererror", (String)"Container Error"));
                this.downloadLink.getLinkStatus().setErrorMessage(JDL.L((String)"controller.status.containererror", (String)"Container Error"));
                this.downloadLink.setEnabled(false);
                this.fireControlEvent(new ControlEvent(this.currentPlugin, 4, this));
                Interaction.handleInteraction(Interaction.INTERACTION_DOWNLOAD_FAILED, this);
                return;
            }
            Object object = DUPELOCK;
            synchronized (object) {
                if (DownloadInterface.preDownloadCheckFailed((DownloadLink)this.downloadLink)) {
                    this.onErrorLinkBlock(this.downloadLink, this.currentPlugin);
                    this.fireControlEvent(new ControlEvent(this.currentPlugin, 4, this));
                    return;
                }
                this.linkStatus.setInProgress(true);
            }
            this.handlePlugin();
            this.fireControlEvent(new ControlEvent(this.currentPlugin, 4, this));
            plugin.clean();
            this.downloadLink.requestGuiUpdate();
            return;
        }
        finally {
            this.linkStatus.setInProgress(false);
            this.linkStatus.setActive(false);
        }
    }
}

